/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiAudioInputDeviceInfo;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiPageDisplayMode;
import org.teamapps.dto.UiVideoInputDeviceInfo;
import org.teamapps.dto.UiWaitingVideoInfo;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiLiveStreamComponent
extends UiComponent
implements UiObject {
    protected String backgroundImage;
    protected UiPageDisplayMode backgroundImageDisplayMode = UiPageDisplayMode.COVER;
    protected float volume = 1.0f;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_LIVE_STREAM_COMPONENT;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("backgroundImage=" + this.backgroundImage) + ", " + ("backgroundImageDisplayMode=" + this.backgroundImageDisplayMode) + ", " + ("volume=" + this.volume);
    }

    @JsonGetter(value="backgroundImage")
    public String getBackgroundImage() {
        return this.backgroundImage;
    }

    @JsonGetter(value="backgroundImageDisplayMode")
    public UiPageDisplayMode getBackgroundImageDisplayMode() {
        return this.backgroundImageDisplayMode;
    }

    @JsonGetter(value="volume")
    public float getVolume() {
        return this.volume;
    }

    @Override
    @JsonSetter(value="id")
    public UiLiveStreamComponent setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiLiveStreamComponent setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiLiveStreamComponent setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiLiveStreamComponent setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="backgroundImage")
    public UiLiveStreamComponent setBackgroundImage(String backgroundImage) {
        this.backgroundImage = backgroundImage;
        return this;
    }

    @JsonSetter(value="backgroundImageDisplayMode")
    public UiLiveStreamComponent setBackgroundImageDisplayMode(UiPageDisplayMode backgroundImageDisplayMode) {
        this.backgroundImageDisplayMode = backgroundImageDisplayMode;
        return this;
    }

    @JsonSetter(value="volume")
    public UiLiveStreamComponent setVolume(float volume) {
        this.volume = volume;
        return this;
    }

    public static class SetVolumeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected float volume;

        @Deprecated
        public SetVolumeCommand() {
        }

        public SetVolumeCommand(String componentId, float volume) {
            this.componentId = componentId;
            this.volume = volume;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("volume=" + this.volume);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="volume")
        public float getVolume() {
            return this.volume;
        }
    }

    public static class RemoveInfoTextOverlayCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public RemoveInfoTextOverlayCommand() {
        }

        public RemoveInfoTextOverlayCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class DisplayInfoTextOverlayCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String text;

        @Deprecated
        public DisplayInfoTextOverlayCommand() {
        }

        public DisplayInfoTextOverlayCommand(String componentId, String text) {
            this.componentId = componentId;
            this.text = text;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("text=" + this.text);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="text")
        public String getText() {
            return this.text;
        }
    }

    public static class RemoveImageOverlayCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public RemoveImageOverlayCommand() {
        }

        public RemoveImageOverlayCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class DisplayImageOverlayCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String imageUrl;
        protected UiPageDisplayMode displayMode;
        protected boolean useVideoAreaAsFrame;

        @Deprecated
        public DisplayImageOverlayCommand() {
        }

        public DisplayImageOverlayCommand(String componentId, String imageUrl, UiPageDisplayMode displayMode, boolean useVideoAreaAsFrame) {
            this.componentId = componentId;
            this.imageUrl = imageUrl;
            this.displayMode = displayMode;
            this.useVideoAreaAsFrame = useVideoAreaAsFrame;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("imageUrl=" + this.imageUrl) + ", " + ("displayMode=" + this.displayMode) + ", " + ("useVideoAreaAsFrame=" + this.useVideoAreaAsFrame);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="imageUrl")
        public String getImageUrl() {
            return this.imageUrl;
        }

        @JsonGetter(value="displayMode")
        public UiPageDisplayMode getDisplayMode() {
            return this.displayMode;
        }

        @JsonGetter(value="useVideoAreaAsFrame")
        public boolean getUseVideoAreaAsFrame() {
            return this.useVideoAreaAsFrame;
        }
    }

    public static class StopLiveStreamCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public StopLiveStreamCommand() {
        }

        public StopLiveStreamCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class StartCustomEmbeddedLiveStreamPlayerCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String playerEmbedHtml;
        protected String embedContainerId;

        @Deprecated
        public StartCustomEmbeddedLiveStreamPlayerCommand() {
        }

        public StartCustomEmbeddedLiveStreamPlayerCommand(String componentId, String playerEmbedHtml, String embedContainerId) {
            this.componentId = componentId;
            this.playerEmbedHtml = playerEmbedHtml;
            this.embedContainerId = embedContainerId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("embedContainerId=" + this.embedContainerId) + ", " + ("playerEmbedHtml=" + this.playerEmbedHtml);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="playerEmbedHtml")
        public String getPlayerEmbedHtml() {
            return this.playerEmbedHtml;
        }

        @JsonGetter(value="embedContainerId")
        public String getEmbedContainerId() {
            return this.embedContainerId;
        }
    }

    public static class StartYouTubeLiveStreamCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String url;

        @Deprecated
        public StartYouTubeLiveStreamCommand() {
        }

        public StartYouTubeLiveStreamCommand(String componentId, String url) {
            this.componentId = componentId;
            this.url = url;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("url=" + this.url);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="url")
        public String getUrl() {
            return this.url;
        }
    }

    public static class StartLiveStreamComLiveStreamCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String url;

        @Deprecated
        public StartLiveStreamComLiveStreamCommand() {
        }

        public StartLiveStreamComLiveStreamCommand(String componentId, String url) {
            this.componentId = componentId;
            this.url = url;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("url=" + this.url);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="url")
        public String getUrl() {
            return this.url;
        }
    }

    public static class StartHttpLiveStreamCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String url;

        @Deprecated
        public StartHttpLiveStreamCommand() {
        }

        public StartHttpLiveStreamCommand(String componentId, String url) {
            this.componentId = componentId;
            this.url = url;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("url=" + this.url);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="url")
        public String getUrl() {
            return this.url;
        }
    }

    public static class StopWaitingVideosCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public StopWaitingVideosCommand() {
        }

        public StopWaitingVideosCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class ShowWaitingVideosCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<UiWaitingVideoInfo> videoInfos;
        protected long offsetSeconds;
        protected boolean stopLiveStream;

        @Deprecated
        public ShowWaitingVideosCommand() {
        }

        public ShowWaitingVideosCommand(String componentId, List<UiWaitingVideoInfo> videoInfos, long offsetSeconds, boolean stopLiveStream) {
            this.componentId = componentId;
            this.videoInfos = videoInfos;
            this.offsetSeconds = offsetSeconds;
            this.stopLiveStream = stopLiveStream;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("offsetSeconds=" + this.offsetSeconds) + ", " + ("stopLiveStream=" + this.stopLiveStream) + ", " + (String)(this.videoInfos != null ? "videoInfos={" + this.videoInfos.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="videoInfos")
        public List<UiWaitingVideoInfo> getVideoInfos() {
            return this.videoInfos;
        }

        @JsonGetter(value="offsetSeconds")
        public long getOffsetSeconds() {
            return this.offsetSeconds;
        }

        @JsonGetter(value="stopLiveStream")
        public boolean getStopLiveStream() {
            return this.stopLiveStream;
        }
    }

    public static class ResultOfRequestInputDeviceInfoEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected UiAudioInputDeviceInfo audioInputDeviceInfo;
        protected UiVideoInputDeviceInfo videoInputDeviceInfo;

        @Deprecated
        public ResultOfRequestInputDeviceInfoEvent() {
        }

        public ResultOfRequestInputDeviceInfoEvent(String componentId, UiAudioInputDeviceInfo audioInputDeviceInfo, UiVideoInputDeviceInfo videoInputDeviceInfo) {
            this.componentId = componentId;
            this.audioInputDeviceInfo = audioInputDeviceInfo;
            this.videoInputDeviceInfo = videoInputDeviceInfo;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_LIVE_STREAM_COMPONENT_RESULT_OF_REQUEST_INPUT_DEVICE_INFO;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.audioInputDeviceInfo != null ? "audioInputDeviceInfo={" + this.audioInputDeviceInfo.toString() + "}" : "") + ", " + (String)(this.videoInputDeviceInfo != null ? "videoInputDeviceInfo={" + this.videoInputDeviceInfo.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="audioInputDeviceInfo")
        public UiAudioInputDeviceInfo getAudioInputDeviceInfo() {
            return this.audioInputDeviceInfo;
        }

        @JsonGetter(value="videoInputDeviceInfo")
        public UiVideoInputDeviceInfo getVideoInputDeviceInfo() {
            return this.videoInputDeviceInfo;
        }
    }

    public static class ResultOfRequestInputDeviceAccessEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected boolean microphoneAccessGranted;
        protected boolean cameraAccessGranted;

        @Deprecated
        public ResultOfRequestInputDeviceAccessEvent() {
        }

        public ResultOfRequestInputDeviceAccessEvent(String componentId, boolean microphoneAccessGranted, boolean cameraAccessGranted) {
            this.componentId = componentId;
            this.microphoneAccessGranted = microphoneAccessGranted;
            this.cameraAccessGranted = cameraAccessGranted;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_LIVE_STREAM_COMPONENT_RESULT_OF_REQUEST_INPUT_DEVICE_ACCESS;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("microphoneAccessGranted=" + this.microphoneAccessGranted) + ", " + ("cameraAccessGranted=" + this.cameraAccessGranted);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="microphoneAccessGranted")
        public boolean getMicrophoneAccessGranted() {
            return this.microphoneAccessGranted;
        }

        @JsonGetter(value="cameraAccessGranted")
        public boolean getCameraAccessGranted() {
            return this.cameraAccessGranted;
        }
    }
}

