/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiPageViewBlock;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiPageView
extends UiComponent
implements UiObject {
    protected List<UiPageViewBlock> blocks;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_PAGE_VIEW;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + (String)(this.blocks != null ? "blocks={" + this.blocks.toString() + "}" : "");
    }

    @JsonGetter(value="blocks")
    public List<UiPageViewBlock> getBlocks() {
        return this.blocks;
    }

    @Override
    @JsonSetter(value="id")
    public UiPageView setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiPageView setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiPageView setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiPageView setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="blocks")
    public UiPageView setBlocks(List<UiPageViewBlock> blocks) {
        this.blocks = blocks;
        return this;
    }

    public static class RemoveBlockCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String blockId;

        @Deprecated
        public RemoveBlockCommand() {
        }

        public RemoveBlockCommand(String componentId, String blockId) {
            this.componentId = componentId;
            this.blockId = blockId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("blockId=" + this.blockId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="blockId")
        public String getBlockId() {
            return this.blockId;
        }
    }

    public static class AddBlockCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiPageViewBlock block;
        protected boolean before;
        protected String otherBlockId;

        @Deprecated
        public AddBlockCommand() {
        }

        public AddBlockCommand(String componentId, UiPageViewBlock block, boolean before, String otherBlockId) {
            this.componentId = componentId;
            this.block = block;
            this.before = before;
            this.otherBlockId = otherBlockId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("otherBlockId=" + this.otherBlockId) + ", " + ("before=" + this.before) + ", " + (String)(this.block != null ? "block={" + this.block.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="block")
        public UiPageViewBlock getBlock() {
            return this.block;
        }

        @JsonGetter(value="before")
        public boolean getBefore() {
            return this.before;
        }

        @JsonGetter(value="otherBlockId")
        public String getOtherBlockId() {
            return this.otherBlockId;
        }
    }
}

