package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiHtmlView extends UiComponent implements UiObject {


	protected String html;
	protected Map<String, List<UiClientObjectReference>> componentsByContainerElementSelector;
	protected Map<String, String> contentHtmlByContainerElementSelector;

	public UiHtmlView() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_HTML_VIEW;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("html=" + html).append(", ")
				.append("contentHtmlByContainerElementSelector=" + contentHtmlByContainerElementSelector).append(", ")
				.append(componentsByContainerElementSelector != null ? "componentsByContainerElementSelector={" + componentsByContainerElementSelector.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("html")
	public String getHtml() {
		return html;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("componentsByContainerElementSelector")
	public Map<String, List<UiClientObjectReference>> getComponentsByContainerElementSelector() {
		return componentsByContainerElementSelector;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("contentHtmlByContainerElementSelector")
	public Map<String, String> getContentHtmlByContainerElementSelector() {
		return contentHtmlByContainerElementSelector;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiHtmlView setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiHtmlView setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiHtmlView setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiHtmlView setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("html")
	public UiHtmlView setHtml(String html) {
		this.html = html;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("componentsByContainerElementSelector")
	public UiHtmlView setComponentsByContainerElementSelector(Map<String, List<UiClientObjectReference>> componentsByContainerElementSelector) {
		this.componentsByContainerElementSelector = componentsByContainerElementSelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("contentHtmlByContainerElementSelector")
	public UiHtmlView setContentHtmlByContainerElementSelector(Map<String, String> contentHtmlByContainerElementSelector) {
		this.contentHtmlByContainerElementSelector = contentHtmlByContainerElementSelector;
		return this;
	}


	public static class AddComponentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String containerElementSelector;
		protected UiClientObjectReference component;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddComponentCommand() {
			// default constructor for Jackson
		}

		public AddComponentCommand(String componentId, String containerElementSelector, UiClientObjectReference component) {
			this.componentId = componentId;
			this.containerElementSelector = containerElementSelector;
			this.component = component;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("containerElementSelector=" + containerElementSelector).append(", ")
					.append(component != null ? "component={" + component.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("containerElementSelector")
		public String getContainerElementSelector() {
			return containerElementSelector;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("component")
		public UiClientObjectReference getComponent() {
			return component;
		}

	}

	public static class RemoveComponentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiClientObjectReference component;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveComponentCommand() {
			// default constructor for Jackson
		}

		public RemoveComponentCommand(String componentId, UiClientObjectReference component) {
			this.componentId = componentId;
			this.component = component;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(component != null ? "component={" + component.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("component")
		public UiClientObjectReference getComponent() {
			return component;
		}

	}

	public static class SetContentHtmlCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String containerElementSelector;
		protected String html;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetContentHtmlCommand() {
			// default constructor for Jackson
		}

		public SetContentHtmlCommand(String componentId, String containerElementSelector, String html) {
			this.componentId = componentId;
			this.containerElementSelector = containerElementSelector;
			this.html = html;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("containerElementSelector=" + containerElementSelector).append(", ")
					.append("html=" + html)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("containerElementSelector")
		public String getContainerElementSelector() {
			return containerElementSelector;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("html")
		public String getHtml() {
			return html;
		}

	}




}