package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiSplitPane extends UiComponent implements Emptyable, UiObject {


	protected UiSplitDirection splitDirection;
	protected UiSplitSizePolicy sizePolicy;
	protected float referenceChildSize = 0.5f;
	protected UiClientObjectReference firstChild;
	protected UiClientObjectReference lastChild;
	protected int firstChildMinSize = 10;
	protected int lastChildMinSize = 10;
	protected boolean resizable = true;
	protected boolean fillIfSingleChild = true;
	protected boolean collapseEmptyChildren = true;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiSplitPane() {
		// default constructor for Jackson
	}

	public UiSplitPane(UiSplitDirection splitDirection, UiSplitSizePolicy sizePolicy) {
		super();
		this.splitDirection = splitDirection;
		this.sizePolicy = sizePolicy;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_SPLIT_PANE;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("splitDirection=" + splitDirection).append(", ")
				.append("sizePolicy=" + sizePolicy).append(", ")
				.append("referenceChildSize=" + referenceChildSize).append(", ")
				.append("firstChildMinSize=" + firstChildMinSize).append(", ")
				.append("lastChildMinSize=" + lastChildMinSize).append(", ")
				.append("resizable=" + resizable).append(", ")
				.append("fillIfSingleChild=" + fillIfSingleChild).append(", ")
				.append("collapseEmptyChildren=" + collapseEmptyChildren).append(", ")
				.append(firstChild != null ? "firstChild={" + firstChild.toString() + "}" : "").append(", ")
				.append(lastChild != null ? "lastChild={" + lastChild.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("splitDirection")
	public UiSplitDirection getSplitDirection() {
		return splitDirection;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("sizePolicy")
	public UiSplitSizePolicy getSizePolicy() {
		return sizePolicy;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("referenceChildSize")
	public float getReferenceChildSize() {
		return referenceChildSize;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("firstChild")
	public UiClientObjectReference getFirstChild() {
		return firstChild;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("lastChild")
	public UiClientObjectReference getLastChild() {
		return lastChild;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("firstChildMinSize")
	public int getFirstChildMinSize() {
		return firstChildMinSize;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("lastChildMinSize")
	public int getLastChildMinSize() {
		return lastChildMinSize;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("resizable")
	public boolean getResizable() {
		return resizable;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("fillIfSingleChild")
	public boolean getFillIfSingleChild() {
		return fillIfSingleChild;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("collapseEmptyChildren")
	public boolean getCollapseEmptyChildren() {
		return collapseEmptyChildren;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiSplitPane setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiSplitPane setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiSplitPane setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiSplitPane setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("referenceChildSize")
	public UiSplitPane setReferenceChildSize(float referenceChildSize) {
		this.referenceChildSize = referenceChildSize;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("firstChild")
	public UiSplitPane setFirstChild(UiClientObjectReference firstChild) {
		this.firstChild = firstChild;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("lastChild")
	public UiSplitPane setLastChild(UiClientObjectReference lastChild) {
		this.lastChild = lastChild;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("firstChildMinSize")
	public UiSplitPane setFirstChildMinSize(int firstChildMinSize) {
		this.firstChildMinSize = firstChildMinSize;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("lastChildMinSize")
	public UiSplitPane setLastChildMinSize(int lastChildMinSize) {
		this.lastChildMinSize = lastChildMinSize;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("resizable")
	public UiSplitPane setResizable(boolean resizable) {
		this.resizable = resizable;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("fillIfSingleChild")
	public UiSplitPane setFillIfSingleChild(boolean fillIfSingleChild) {
		this.fillIfSingleChild = fillIfSingleChild;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("collapseEmptyChildren")
	public UiSplitPane setCollapseEmptyChildren(boolean collapseEmptyChildren) {
		this.collapseEmptyChildren = collapseEmptyChildren;
		return this;
	}

	public static class SplitResizedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected float referenceChildSize;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SplitResizedEvent() {
			// default constructor for Jackson
		}

		public SplitResizedEvent(String componentId, float referenceChildSize) {
			this.componentId = componentId;
			this.referenceChildSize = referenceChildSize;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_SPLIT_PANE_SPLIT_RESIZED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("referenceChildSize=" + referenceChildSize)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("referenceChildSize")
		public float getReferenceChildSize() {
			return referenceChildSize;
		}

	}

	public static class SetFirstChildCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiClientObjectReference firstChild;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetFirstChildCommand() {
			// default constructor for Jackson
		}

		public SetFirstChildCommand(String componentId, UiClientObjectReference firstChild) {
			this.componentId = componentId;
			this.firstChild = firstChild;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(firstChild != null ? "firstChild={" + firstChild.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("firstChild")
		public UiClientObjectReference getFirstChild() {
			return firstChild;
		}

	}

	public static class SetLastChildCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiClientObjectReference lastChild;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetLastChildCommand() {
			// default constructor for Jackson
		}

		public SetLastChildCommand(String componentId, UiClientObjectReference lastChild) {
			this.componentId = componentId;
			this.lastChild = lastChild;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(lastChild != null ? "lastChild={" + lastChild.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("lastChild")
		public UiClientObjectReference getLastChild() {
			return lastChild;
		}

	}

	public static class SetSizeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected float referenceChildSize;
		protected UiSplitSizePolicy sizePolicy;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetSizeCommand() {
			// default constructor for Jackson
		}

		public SetSizeCommand(String componentId, float referenceChildSize, UiSplitSizePolicy sizePolicy) {
			this.componentId = componentId;
			this.referenceChildSize = referenceChildSize;
			this.sizePolicy = sizePolicy;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("referenceChildSize=" + referenceChildSize).append(", ")
					.append("sizePolicy=" + sizePolicy)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("referenceChildSize")
		public float getReferenceChildSize() {
			return referenceChildSize;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizePolicy")
		public UiSplitSizePolicy getSizePolicy() {
			return sizePolicy;
		}

	}

	public static class SetFirstChildMinSizeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int firstChildMinSize;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetFirstChildMinSizeCommand() {
			// default constructor for Jackson
		}

		public SetFirstChildMinSizeCommand(String componentId, int firstChildMinSize) {
			this.componentId = componentId;
			this.firstChildMinSize = firstChildMinSize;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("firstChildMinSize=" + firstChildMinSize)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("firstChildMinSize")
		public int getFirstChildMinSize() {
			return firstChildMinSize;
		}

	}

	public static class SetLastChildMinSizeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int lastChildMinSize;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetLastChildMinSizeCommand() {
			// default constructor for Jackson
		}

		public SetLastChildMinSizeCommand(String componentId, int lastChildMinSize) {
			this.componentId = componentId;
			this.lastChildMinSize = lastChildMinSize;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("lastChildMinSize=" + lastChildMinSize)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("lastChildMinSize")
		public int getLastChildMinSize() {
			return lastChildMinSize;
		}

	}




}