package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiTabPanel extends UiComponent implements Emptyable, UiObject {


	protected List<UiTab> tabs;
	protected String selectedTabId;
	protected boolean hideTabBarIfSingleTab = false;
	protected UiTabPanelTabStyle tabStyle = UiTabPanelTabStyle.BLOCKS;
	protected List<UiClientObjectReference> toolButtons;
	protected List<UiWindowButtonType> windowButtons;

	public UiTabPanel() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_TAB_PANEL;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("selectedTabId=" + selectedTabId).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("hideTabBarIfSingleTab=" + hideTabBarIfSingleTab).append(", ")
				.append("tabStyle=" + tabStyle).append(", ")
				.append("windowButtons=" + windowButtons).append(", ")
				.append(tabs != null ? "tabs={" + tabs.toString() + "}" : "").append(", ")
				.append(toolButtons != null ? "toolButtons={" + toolButtons.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("tabs")
	public List<UiTab> getTabs() {
		return tabs;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("selectedTabId")
	public String getSelectedTabId() {
		return selectedTabId;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("hideTabBarIfSingleTab")
	public boolean getHideTabBarIfSingleTab() {
		return hideTabBarIfSingleTab;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("tabStyle")
	public UiTabPanelTabStyle getTabStyle() {
		return tabStyle;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("toolButtons")
	public List<UiClientObjectReference> getToolButtons() {
		return toolButtons;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("windowButtons")
	public List<UiWindowButtonType> getWindowButtons() {
		return windowButtons;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiTabPanel setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiTabPanel setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiTabPanel setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiTabPanel setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("tabs")
	public UiTabPanel setTabs(List<UiTab> tabs) {
		this.tabs = tabs;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("selectedTabId")
	public UiTabPanel setSelectedTabId(String selectedTabId) {
		this.selectedTabId = selectedTabId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("hideTabBarIfSingleTab")
	public UiTabPanel setHideTabBarIfSingleTab(boolean hideTabBarIfSingleTab) {
		this.hideTabBarIfSingleTab = hideTabBarIfSingleTab;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("tabStyle")
	public UiTabPanel setTabStyle(UiTabPanelTabStyle tabStyle) {
		this.tabStyle = tabStyle;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("toolButtons")
	public UiTabPanel setToolButtons(List<UiClientObjectReference> toolButtons) {
		this.toolButtons = toolButtons;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("windowButtons")
	public UiTabPanel setWindowButtons(List<UiWindowButtonType> windowButtons) {
		this.windowButtons = windowButtons;
		return this;
	}

	public static class TabSelectedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String tabId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public TabSelectedEvent() {
			// default constructor for Jackson
		}

		public TabSelectedEvent(String componentId, String tabId) {
			this.componentId = componentId;
			this.tabId = tabId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TAB_PANEL_TAB_SELECTED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("tabId=" + tabId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("tabId")
		public String getTabId() {
			return tabId;
		}

	}

	public static class TabNeedsRefreshEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String tabId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public TabNeedsRefreshEvent() {
			// default constructor for Jackson
		}

		public TabNeedsRefreshEvent(String componentId, String tabId) {
			this.componentId = componentId;
			this.tabId = tabId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TAB_PANEL_TAB_NEEDS_REFRESH;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("tabId=" + tabId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("tabId")
		public String getTabId() {
			return tabId;
		}

	}

	public static class TabClosedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String tabId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public TabClosedEvent() {
			// default constructor for Jackson
		}

		public TabClosedEvent(String componentId, String tabId) {
			this.componentId = componentId;
			this.tabId = tabId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TAB_PANEL_TAB_CLOSED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("tabId=" + tabId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("tabId")
		public String getTabId() {
			return tabId;
		}

	}

	public static class WindowButtonClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiWindowButtonType windowButton;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public WindowButtonClickedEvent() {
			// default constructor for Jackson
		}

		public WindowButtonClickedEvent(String componentId, UiWindowButtonType windowButton) {
			this.componentId = componentId;
			this.windowButton = windowButton;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TAB_PANEL_WINDOW_BUTTON_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("windowButton=" + windowButton)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("windowButton")
		public UiWindowButtonType getWindowButton() {
			return windowButton;
		}

	}

	public static class SetHideTabBarIfSingleTabCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean hideTabBarIfSingleTab;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetHideTabBarIfSingleTabCommand() {
			// default constructor for Jackson
		}

		public SetHideTabBarIfSingleTabCommand(String componentId, boolean hideTabBarIfSingleTab) {
			this.componentId = componentId;
			this.hideTabBarIfSingleTab = hideTabBarIfSingleTab;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("hideTabBarIfSingleTab=" + hideTabBarIfSingleTab)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("hideTabBarIfSingleTab")
		public boolean getHideTabBarIfSingleTab() {
			return hideTabBarIfSingleTab;
		}

	}

	public static class SetTabStyleCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiTabPanelTabStyle tabStyle;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetTabStyleCommand() {
			// default constructor for Jackson
		}

		public SetTabStyleCommand(String componentId, UiTabPanelTabStyle tabStyle) {
			this.componentId = componentId;
			this.tabStyle = tabStyle;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("tabStyle=" + tabStyle)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("tabStyle")
		public UiTabPanelTabStyle getTabStyle() {
			return tabStyle;
		}

	}

	public static class SetToolButtonsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<UiClientObjectReference> toolButtons;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetToolButtonsCommand() {
			// default constructor for Jackson
		}

		public SetToolButtonsCommand(String componentId, List<UiClientObjectReference> toolButtons) {
			this.componentId = componentId;
			this.toolButtons = toolButtons;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(toolButtons != null ? "toolButtons={" + toolButtons.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("toolButtons")
		public List<UiClientObjectReference> getToolButtons() {
			return toolButtons;
		}

	}

	public static class SetWindowButtonsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<UiWindowButtonType> windowButtons;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetWindowButtonsCommand() {
			// default constructor for Jackson
		}

		public SetWindowButtonsCommand(String componentId, List<UiWindowButtonType> windowButtons) {
			this.componentId = componentId;
			this.windowButtons = windowButtons;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("windowButtons=" + windowButtons)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("windowButtons")
		public List<UiWindowButtonType> getWindowButtons() {
			return windowButtons;
		}

	}

	public static class SelectTabCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String tabId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SelectTabCommand() {
			// default constructor for Jackson
		}

		public SelectTabCommand(String componentId, String tabId) {
			this.componentId = componentId;
			this.tabId = tabId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("tabId=" + tabId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("tabId")
		public String getTabId() {
			return tabId;
		}

	}

	public static class AddTabCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiTab tab;
		protected boolean select;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddTabCommand() {
			// default constructor for Jackson
		}

		public AddTabCommand(String componentId, UiTab tab, boolean select) {
			this.componentId = componentId;
			this.tab = tab;
			this.select = select;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("select=" + select).append(", ")
					.append(tab != null ? "tab={" + tab.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("tab")
		public UiTab getTab() {
			return tab;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("select")
		public boolean getSelect() {
			return select;
		}

	}

	public static class RemoveTabCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String tabId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveTabCommand() {
			// default constructor for Jackson
		}

		public RemoveTabCommand(String componentId, String tabId) {
			this.componentId = componentId;
			this.tabId = tabId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("tabId=" + tabId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("tabId")
		public String getTabId() {
			return tabId;
		}

	}

	public static class SetTabToolbarCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String tabId;
		protected UiClientObjectReference toolbar;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetTabToolbarCommand() {
			// default constructor for Jackson
		}

		public SetTabToolbarCommand(String componentId, String tabId, UiClientObjectReference toolbar) {
			this.componentId = componentId;
			this.tabId = tabId;
			this.toolbar = toolbar;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("tabId=" + tabId).append(", ")
					.append(toolbar != null ? "toolbar={" + toolbar.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("tabId")
		public String getTabId() {
			return tabId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("toolbar")
		public UiClientObjectReference getToolbar() {
			return toolbar;
		}

	}

	public static class SetTabContentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String tabId;
		protected UiClientObjectReference component;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetTabContentCommand() {
			// default constructor for Jackson
		}

		public SetTabContentCommand(String componentId, String tabId, UiClientObjectReference component) {
			this.componentId = componentId;
			this.tabId = tabId;
			this.component = component;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("tabId=" + tabId).append(", ")
					.append(component != null ? "component={" + component.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("tabId")
		public String getTabId() {
			return tabId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("component")
		public UiClientObjectReference getComponent() {
			return component;
		}

	}

	public static class SetTabConfigurationCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String tabId;
		protected String icon;
		protected String caption;
		protected boolean closeable;
		protected boolean visible;
		protected boolean rightSide;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetTabConfigurationCommand() {
			// default constructor for Jackson
		}

		public SetTabConfigurationCommand(String componentId, String tabId, String icon, String caption, boolean closeable, boolean visible, boolean rightSide) {
			this.componentId = componentId;
			this.tabId = tabId;
			this.icon = icon;
			this.caption = caption;
			this.closeable = closeable;
			this.visible = visible;
			this.rightSide = rightSide;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("tabId=" + tabId).append(", ")
					.append("icon=" + icon).append(", ")
					.append("caption=" + caption).append(", ")
					.append("closeable=" + closeable).append(", ")
					.append("visible=" + visible).append(", ")
					.append("rightSide=" + rightSide)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("tabId")
		public String getTabId() {
			return tabId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("icon")
		public String getIcon() {
			return icon;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("caption")
		public String getCaption() {
			return caption;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("closeable")
		public boolean getCloseable() {
			return closeable;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("visible")
		public boolean getVisible() {
			return visible;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("rightSide")
		public boolean getRightSide() {
			return rightSide;
		}

	}




}