package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiTreeGraphNodeImage implements UiObject {

	public enum CornerShape {
		ORIGINAL, ROUNDED, CIRCLE;

		@com.fasterxml.jackson.annotation.JsonValue
		public int jsonValue() {
			return ordinal();
		}
	}

	protected String url;
	protected int width;
	protected int height;
	protected int centerTopDistance;
	protected int centerLeftDistance;
	protected CornerShape cornerShape = CornerShape.ROUNDED;
	protected boolean shadow = false;
	protected float borderWidth = 0;
	protected String borderColor = "rgb(100, 100, 100)";

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiTreeGraphNodeImage() {
		// default constructor for Jackson
	}

	public UiTreeGraphNodeImage(String url, int width, int height) {
		this.url = url;
		this.width = width;
		this.height = height;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_TREE_GRAPH_NODE_IMAGE;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("url=" + url).append(", ")
				.append("width=" + width).append(", ")
				.append("height=" + height).append(", ")
				.append("centerTopDistance=" + centerTopDistance).append(", ")
				.append("centerLeftDistance=" + centerLeftDistance).append(", ")
				.append("cornerShape=" + cornerShape).append(", ")
				.append("shadow=" + shadow).append(", ")
				.append("borderWidth=" + borderWidth).append(", ")
				.append("borderColor=" + borderColor)
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("url")
	public String getUrl() {
		return url;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("width")
	public int getWidth() {
		return width;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("height")
	public int getHeight() {
		return height;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("centerTopDistance")
	public int getCenterTopDistance() {
		return centerTopDistance;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("centerLeftDistance")
	public int getCenterLeftDistance() {
		return centerLeftDistance;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("cornerShape")
	public CornerShape getCornerShape() {
		return cornerShape;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("shadow")
	public boolean getShadow() {
		return shadow;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("borderWidth")
	public float getBorderWidth() {
		return borderWidth;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("borderColor")
	public String getBorderColor() {
		return borderColor;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("centerTopDistance")
	public UiTreeGraphNodeImage setCenterTopDistance(int centerTopDistance) {
		this.centerTopDistance = centerTopDistance;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("centerLeftDistance")
	public UiTreeGraphNodeImage setCenterLeftDistance(int centerLeftDistance) {
		this.centerLeftDistance = centerLeftDistance;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("cornerShape")
	public UiTreeGraphNodeImage setCornerShape(CornerShape cornerShape) {
		this.cornerShape = cornerShape;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("shadow")
	public UiTreeGraphNodeImage setShadow(boolean shadow) {
		this.shadow = shadow;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("borderWidth")
	public UiTreeGraphNodeImage setBorderWidth(float borderWidth) {
		this.borderWidth = borderWidth;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("borderColor")
	public UiTreeGraphNodeImage setBorderColor(String borderColor) {
		this.borderColor = borderColor;
		return this;
	}






}