/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.Emptyable;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiTab;
import org.teamapps.dto.UiTabPanelTabStyle;
import org.teamapps.dto.UiWindowButtonType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiTabPanel
extends UiComponent
implements Emptyable,
UiObject {
    protected List<UiTab> tabs;
    protected String selectedTabId;
    protected boolean hideTabBarIfSingleTab = false;
    protected UiTabPanelTabStyle tabStyle = UiTabPanelTabStyle.BLOCKS;
    protected List<UiClientObjectReference> toolButtons;
    protected List<UiWindowButtonType> windowButtons;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_TAB_PANEL;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("selectedTabId=" + this.selectedTabId) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("hideTabBarIfSingleTab=" + this.hideTabBarIfSingleTab) + ", " + ("tabStyle=" + this.tabStyle) + ", " + ("windowButtons=" + this.windowButtons) + ", " + (String)(this.tabs != null ? "tabs={" + this.tabs.toString() + "}" : "") + ", " + (String)(this.toolButtons != null ? "toolButtons={" + this.toolButtons.toString() + "}" : "");
    }

    @JsonGetter(value="tabs")
    public List<UiTab> getTabs() {
        return this.tabs;
    }

    @JsonGetter(value="selectedTabId")
    public String getSelectedTabId() {
        return this.selectedTabId;
    }

    @JsonGetter(value="hideTabBarIfSingleTab")
    public boolean getHideTabBarIfSingleTab() {
        return this.hideTabBarIfSingleTab;
    }

    @JsonGetter(value="tabStyle")
    public UiTabPanelTabStyle getTabStyle() {
        return this.tabStyle;
    }

    @JsonGetter(value="toolButtons")
    public List<UiClientObjectReference> getToolButtons() {
        return this.toolButtons;
    }

    @JsonGetter(value="windowButtons")
    public List<UiWindowButtonType> getWindowButtons() {
        return this.windowButtons;
    }

    @Override
    @JsonSetter(value="id")
    public UiTabPanel setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiTabPanel setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiTabPanel setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiTabPanel setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="tabs")
    public UiTabPanel setTabs(List<UiTab> tabs) {
        this.tabs = tabs;
        return this;
    }

    @JsonSetter(value="selectedTabId")
    public UiTabPanel setSelectedTabId(String selectedTabId) {
        this.selectedTabId = selectedTabId;
        return this;
    }

    @JsonSetter(value="hideTabBarIfSingleTab")
    public UiTabPanel setHideTabBarIfSingleTab(boolean hideTabBarIfSingleTab) {
        this.hideTabBarIfSingleTab = hideTabBarIfSingleTab;
        return this;
    }

    @JsonSetter(value="tabStyle")
    public UiTabPanel setTabStyle(UiTabPanelTabStyle tabStyle) {
        this.tabStyle = tabStyle;
        return this;
    }

    @JsonSetter(value="toolButtons")
    public UiTabPanel setToolButtons(List<UiClientObjectReference> toolButtons) {
        this.toolButtons = toolButtons;
        return this;
    }

    @JsonSetter(value="windowButtons")
    public UiTabPanel setWindowButtons(List<UiWindowButtonType> windowButtons) {
        this.windowButtons = windowButtons;
        return this;
    }

    public static class SetTabConfigurationCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String tabId;
        protected String icon;
        protected String caption;
        protected boolean closeable;
        protected boolean visible;
        protected boolean rightSide;

        @Deprecated
        public SetTabConfigurationCommand() {
        }

        public SetTabConfigurationCommand(String componentId, String tabId, String icon, String caption, boolean closeable, boolean visible, boolean rightSide) {
            this.componentId = componentId;
            this.tabId = tabId;
            this.icon = icon;
            this.caption = caption;
            this.closeable = closeable;
            this.visible = visible;
            this.rightSide = rightSide;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("tabId=" + this.tabId) + ", " + ("icon=" + this.icon) + ", " + ("caption=" + this.caption) + ", " + ("closeable=" + this.closeable) + ", " + ("visible=" + this.visible) + ", " + ("rightSide=" + this.rightSide);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="tabId")
        public String getTabId() {
            return this.tabId;
        }

        @JsonGetter(value="icon")
        public String getIcon() {
            return this.icon;
        }

        @JsonGetter(value="caption")
        public String getCaption() {
            return this.caption;
        }

        @JsonGetter(value="closeable")
        public boolean getCloseable() {
            return this.closeable;
        }

        @JsonGetter(value="visible")
        public boolean getVisible() {
            return this.visible;
        }

        @JsonGetter(value="rightSide")
        public boolean getRightSide() {
            return this.rightSide;
        }
    }

    public static class SetTabContentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String tabId;
        protected UiClientObjectReference component;

        @Deprecated
        public SetTabContentCommand() {
        }

        public SetTabContentCommand(String componentId, String tabId, UiClientObjectReference component) {
            this.componentId = componentId;
            this.tabId = tabId;
            this.component = component;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("tabId=" + this.tabId) + ", " + (String)(this.component != null ? "component={" + this.component.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="tabId")
        public String getTabId() {
            return this.tabId;
        }

        @JsonGetter(value="component")
        public UiClientObjectReference getComponent() {
            return this.component;
        }
    }

    public static class SetTabToolbarCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String tabId;
        protected UiClientObjectReference toolbar;

        @Deprecated
        public SetTabToolbarCommand() {
        }

        public SetTabToolbarCommand(String componentId, String tabId, UiClientObjectReference toolbar) {
            this.componentId = componentId;
            this.tabId = tabId;
            this.toolbar = toolbar;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("tabId=" + this.tabId) + ", " + (String)(this.toolbar != null ? "toolbar={" + this.toolbar.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="tabId")
        public String getTabId() {
            return this.tabId;
        }

        @JsonGetter(value="toolbar")
        public UiClientObjectReference getToolbar() {
            return this.toolbar;
        }
    }

    public static class RemoveTabCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String tabId;

        @Deprecated
        public RemoveTabCommand() {
        }

        public RemoveTabCommand(String componentId, String tabId) {
            this.componentId = componentId;
            this.tabId = tabId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("tabId=" + this.tabId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="tabId")
        public String getTabId() {
            return this.tabId;
        }
    }

    public static class AddTabCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiTab tab;
        protected boolean select;

        @Deprecated
        public AddTabCommand() {
        }

        public AddTabCommand(String componentId, UiTab tab, boolean select) {
            this.componentId = componentId;
            this.tab = tab;
            this.select = select;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("select=" + this.select) + ", " + (String)(this.tab != null ? "tab={" + this.tab.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="tab")
        public UiTab getTab() {
            return this.tab;
        }

        @JsonGetter(value="select")
        public boolean getSelect() {
            return this.select;
        }
    }

    public static class SelectTabCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String tabId;

        @Deprecated
        public SelectTabCommand() {
        }

        public SelectTabCommand(String componentId, String tabId) {
            this.componentId = componentId;
            this.tabId = tabId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("tabId=" + this.tabId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="tabId")
        public String getTabId() {
            return this.tabId;
        }
    }

    public static class SetWindowButtonsCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<UiWindowButtonType> windowButtons;

        @Deprecated
        public SetWindowButtonsCommand() {
        }

        public SetWindowButtonsCommand(String componentId, List<UiWindowButtonType> windowButtons) {
            this.componentId = componentId;
            this.windowButtons = windowButtons;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("windowButtons=" + this.windowButtons);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="windowButtons")
        public List<UiWindowButtonType> getWindowButtons() {
            return this.windowButtons;
        }
    }

    public static class SetToolButtonsCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<UiClientObjectReference> toolButtons;

        @Deprecated
        public SetToolButtonsCommand() {
        }

        public SetToolButtonsCommand(String componentId, List<UiClientObjectReference> toolButtons) {
            this.componentId = componentId;
            this.toolButtons = toolButtons;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.toolButtons != null ? "toolButtons={" + this.toolButtons.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="toolButtons")
        public List<UiClientObjectReference> getToolButtons() {
            return this.toolButtons;
        }
    }

    public static class SetTabStyleCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiTabPanelTabStyle tabStyle;

        @Deprecated
        public SetTabStyleCommand() {
        }

        public SetTabStyleCommand(String componentId, UiTabPanelTabStyle tabStyle) {
            this.componentId = componentId;
            this.tabStyle = tabStyle;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("tabStyle=" + this.tabStyle);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="tabStyle")
        public UiTabPanelTabStyle getTabStyle() {
            return this.tabStyle;
        }
    }

    public static class SetHideTabBarIfSingleTabCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected boolean hideTabBarIfSingleTab;

        @Deprecated
        public SetHideTabBarIfSingleTabCommand() {
        }

        public SetHideTabBarIfSingleTabCommand(String componentId, boolean hideTabBarIfSingleTab) {
            this.componentId = componentId;
            this.hideTabBarIfSingleTab = hideTabBarIfSingleTab;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("hideTabBarIfSingleTab=" + this.hideTabBarIfSingleTab);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="hideTabBarIfSingleTab")
        public boolean getHideTabBarIfSingleTab() {
            return this.hideTabBarIfSingleTab;
        }
    }

    public static class WindowButtonClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected UiWindowButtonType windowButton;

        @Deprecated
        public WindowButtonClickedEvent() {
        }

        public WindowButtonClickedEvent(String componentId, UiWindowButtonType windowButton) {
            this.componentId = componentId;
            this.windowButton = windowButton;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TAB_PANEL_WINDOW_BUTTON_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("windowButton=" + this.windowButton);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="windowButton")
        public UiWindowButtonType getWindowButton() {
            return this.windowButton;
        }
    }

    public static class TabClosedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String tabId;

        @Deprecated
        public TabClosedEvent() {
        }

        public TabClosedEvent(String componentId, String tabId) {
            this.componentId = componentId;
            this.tabId = tabId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TAB_PANEL_TAB_CLOSED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("tabId=" + this.tabId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="tabId")
        public String getTabId() {
            return this.tabId;
        }
    }

    public static class TabNeedsRefreshEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String tabId;

        @Deprecated
        public TabNeedsRefreshEvent() {
        }

        public TabNeedsRefreshEvent(String componentId, String tabId) {
            this.componentId = componentId;
            this.tabId = tabId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TAB_PANEL_TAB_NEEDS_REFRESH;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("tabId=" + this.tabId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="tabId")
        public String getTabId() {
            return this.tabId;
        }
    }

    public static class TabSelectedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String tabId;

        @Deprecated
        public TabSelectedEvent() {
        }

        public TabSelectedEvent(String componentId, String tabId) {
            this.componentId = componentId;
            this.tabId = tabId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TAB_PANEL_TAB_SELECTED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("tabId=" + this.tabId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="tabId")
        public String getTabId() {
            return this.tabId;
        }
    }
}

