/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiMediaDeviceInfo;
import org.teamapps.dto.UiMediaRetrievalFailureReason;
import org.teamapps.dto.UiMediaSoupPlaybackParameters;
import org.teamapps.dto.UiMediaSoupPublishingParameters;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiSourceMediaTrackType;
import org.teamapps.dto.WebRtcClientSpinnerPolicy;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiMediaSoupV3WebRtcClient
extends UiComponent
implements UiObject {
    protected Float displayAreaAspectRatio = Float.valueOf(1.3333334f);
    protected boolean activityLineVisible;
    protected String activityInactiveColor;
    protected String activityActiveColor;
    protected List<String> icons;
    protected String caption;
    protected String noVideoImageUrl;
    protected WebRtcClientSpinnerPolicy spinnerPolicy;
    protected double playbackVolume = 1.0;
    protected boolean contextMenuEnabled = false;
    protected boolean bitrateDisplayEnabled = false;
    protected UiMediaSoupPublishingParameters publishingParameters;
    protected UiMediaSoupPlaybackParameters playbackParameters;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("displayAreaAspectRatio=" + this.displayAreaAspectRatio) + ", " + ("activityLineVisible=" + this.activityLineVisible) + ", " + ("activityInactiveColor=" + this.activityInactiveColor) + ", " + ("activityActiveColor=" + this.activityActiveColor) + ", " + ("icons=" + this.icons) + ", " + ("caption=" + this.caption) + ", " + ("noVideoImageUrl=" + this.noVideoImageUrl) + ", " + ("spinnerPolicy=" + this.spinnerPolicy) + ", " + ("playbackVolume=" + this.playbackVolume) + ", " + ("contextMenuEnabled=" + this.contextMenuEnabled) + ", " + ("bitrateDisplayEnabled=" + this.bitrateDisplayEnabled) + ", " + (String)(this.publishingParameters != null ? "publishingParameters={" + this.publishingParameters.toString() + "}" : "") + ", " + (String)(this.playbackParameters != null ? "playbackParameters={" + this.playbackParameters.toString() + "}" : "");
    }

    @JsonGetter(value="displayAreaAspectRatio")
    public Float getDisplayAreaAspectRatio() {
        return this.displayAreaAspectRatio;
    }

    @JsonGetter(value="activityLineVisible")
    public boolean getActivityLineVisible() {
        return this.activityLineVisible;
    }

    @JsonGetter(value="activityInactiveColor")
    public String getActivityInactiveColor() {
        return this.activityInactiveColor;
    }

    @JsonGetter(value="activityActiveColor")
    public String getActivityActiveColor() {
        return this.activityActiveColor;
    }

    @JsonGetter(value="icons")
    public List<String> getIcons() {
        return this.icons;
    }

    @JsonGetter(value="caption")
    public String getCaption() {
        return this.caption;
    }

    @JsonGetter(value="noVideoImageUrl")
    public String getNoVideoImageUrl() {
        return this.noVideoImageUrl;
    }

    @JsonGetter(value="spinnerPolicy")
    public WebRtcClientSpinnerPolicy getSpinnerPolicy() {
        return this.spinnerPolicy;
    }

    @JsonGetter(value="playbackVolume")
    public double getPlaybackVolume() {
        return this.playbackVolume;
    }

    @JsonGetter(value="contextMenuEnabled")
    public boolean getContextMenuEnabled() {
        return this.contextMenuEnabled;
    }

    @JsonGetter(value="bitrateDisplayEnabled")
    public boolean getBitrateDisplayEnabled() {
        return this.bitrateDisplayEnabled;
    }

    @JsonGetter(value="publishingParameters")
    public UiMediaSoupPublishingParameters getPublishingParameters() {
        return this.publishingParameters;
    }

    @JsonGetter(value="playbackParameters")
    public UiMediaSoupPlaybackParameters getPlaybackParameters() {
        return this.playbackParameters;
    }

    @Override
    @JsonSetter(value="id")
    public UiMediaSoupV3WebRtcClient setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiMediaSoupV3WebRtcClient setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiMediaSoupV3WebRtcClient setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiMediaSoupV3WebRtcClient setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="displayAreaAspectRatio")
    public UiMediaSoupV3WebRtcClient setDisplayAreaAspectRatio(Float displayAreaAspectRatio) {
        this.displayAreaAspectRatio = displayAreaAspectRatio;
        return this;
    }

    @JsonSetter(value="activityLineVisible")
    public UiMediaSoupV3WebRtcClient setActivityLineVisible(boolean activityLineVisible) {
        this.activityLineVisible = activityLineVisible;
        return this;
    }

    @JsonSetter(value="activityInactiveColor")
    public UiMediaSoupV3WebRtcClient setActivityInactiveColor(String activityInactiveColor) {
        this.activityInactiveColor = activityInactiveColor;
        return this;
    }

    @JsonSetter(value="activityActiveColor")
    public UiMediaSoupV3WebRtcClient setActivityActiveColor(String activityActiveColor) {
        this.activityActiveColor = activityActiveColor;
        return this;
    }

    @JsonSetter(value="icons")
    public UiMediaSoupV3WebRtcClient setIcons(List<String> icons) {
        this.icons = icons;
        return this;
    }

    @JsonSetter(value="caption")
    public UiMediaSoupV3WebRtcClient setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    @JsonSetter(value="noVideoImageUrl")
    public UiMediaSoupV3WebRtcClient setNoVideoImageUrl(String noVideoImageUrl) {
        this.noVideoImageUrl = noVideoImageUrl;
        return this;
    }

    @JsonSetter(value="spinnerPolicy")
    public UiMediaSoupV3WebRtcClient setSpinnerPolicy(WebRtcClientSpinnerPolicy spinnerPolicy) {
        this.spinnerPolicy = spinnerPolicy;
        return this;
    }

    @JsonSetter(value="playbackVolume")
    public UiMediaSoupV3WebRtcClient setPlaybackVolume(double playbackVolume) {
        this.playbackVolume = playbackVolume;
        return this;
    }

    @JsonSetter(value="contextMenuEnabled")
    public UiMediaSoupV3WebRtcClient setContextMenuEnabled(boolean contextMenuEnabled) {
        this.contextMenuEnabled = contextMenuEnabled;
        return this;
    }

    @JsonSetter(value="bitrateDisplayEnabled")
    public UiMediaSoupV3WebRtcClient setBitrateDisplayEnabled(boolean bitrateDisplayEnabled) {
        this.bitrateDisplayEnabled = bitrateDisplayEnabled;
        return this;
    }

    @JsonSetter(value="publishingParameters")
    public UiMediaSoupV3WebRtcClient setPublishingParameters(UiMediaSoupPublishingParameters publishingParameters) {
        this.publishingParameters = publishingParameters;
        return this;
    }

    @JsonSetter(value="playbackParameters")
    public UiMediaSoupV3WebRtcClient setPlaybackParameters(UiMediaSoupPlaybackParameters playbackParameters) {
        this.playbackParameters = playbackParameters;
        return this;
    }

    public static class EnumerateDevicesCommand
    implements UiCommand<List<UiMediaDeviceInfo>> {
        public String toString() {
            return this.getClass().getSimpleName() + ": ";
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class CloseContextMenuCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int requestId;

        @Deprecated
        public CloseContextMenuCommand() {
        }

        public CloseContextMenuCommand(String componentId, int requestId) {
            this.componentId = componentId;
            this.requestId = requestId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("requestId=" + this.requestId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="requestId")
        public int getRequestId() {
            return this.requestId;
        }
    }

    public static class SetContextMenuContentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int requestId;
        protected UiClientObjectReference component;

        @Deprecated
        public SetContextMenuContentCommand() {
        }

        public SetContextMenuContentCommand(String componentId, int requestId, UiClientObjectReference component) {
            this.componentId = componentId;
            this.requestId = requestId;
            this.component = component;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("requestId=" + this.requestId) + ", " + (String)(this.component != null ? "component={" + this.component.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="requestId")
        public int getRequestId() {
            return this.requestId;
        }

        @JsonGetter(value="component")
        public UiClientObjectReference getComponent() {
            return this.component;
        }
    }

    public static class SetActiveCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected boolean active;

        @Deprecated
        public SetActiveCommand() {
        }

        public SetActiveCommand(String componentId, boolean active) {
            this.componentId = componentId;
            this.active = active;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("active=" + this.active);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="active")
        public boolean getActive() {
            return this.active;
        }
    }

    public static class UpdateCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiMediaSoupV3WebRtcClient config;

        @Deprecated
        public UpdateCommand() {
        }

        public UpdateCommand(String componentId, UiMediaSoupV3WebRtcClient config) {
            this.componentId = componentId;
            this.config = config;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.config != null ? "config={" + this.config.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="config")
        public UiMediaSoupV3WebRtcClient getConfig() {
            return this.config;
        }
    }

    public static class ContextMenuRequestedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int requestId;

        @Deprecated
        public ContextMenuRequestedEvent() {
        }

        public ContextMenuRequestedEvent(String componentId, int requestId) {
            this.componentId = componentId;
            this.requestId = requestId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_CONTEXT_MENU_REQUESTED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("requestId=" + this.requestId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="requestId")
        public int getRequestId() {
            return this.requestId;
        }
    }

    public static class ClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public ClickedEvent() {
        }

        public ClickedEvent(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class VoiceActivityChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected boolean active;

        @Deprecated
        public VoiceActivityChangedEvent() {
        }

        public VoiceActivityChangedEvent(String componentId, boolean active) {
            this.componentId = componentId;
            this.active = active;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_VOICE_ACTIVITY_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("active=" + this.active);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="active")
        public boolean getActive() {
            return this.active;
        }
    }

    public static class SubscriptionPlaybackFailedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String errorMessage;

        @Deprecated
        public SubscriptionPlaybackFailedEvent() {
        }

        public SubscriptionPlaybackFailedEvent(String componentId, String errorMessage) {
            this.componentId = componentId;
            this.errorMessage = errorMessage;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_SUBSCRIPTION_PLAYBACK_FAILED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("errorMessage=" + this.errorMessage);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="errorMessage")
        public String getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static class SubscribingFailedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String errorMessage;

        @Deprecated
        public SubscribingFailedEvent() {
        }

        public SubscribingFailedEvent(String componentId, String errorMessage) {
            this.componentId = componentId;
            this.errorMessage = errorMessage;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_SUBSCRIBING_FAILED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("errorMessage=" + this.errorMessage);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="errorMessage")
        public String getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static class SubscribingSuccessfulEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public SubscribingSuccessfulEvent() {
        }

        public SubscribingSuccessfulEvent(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_SUBSCRIBING_SUCCESSFUL;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class ConnectionStateChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected boolean connected;

        @Deprecated
        public ConnectionStateChangedEvent() {
        }

        public ConnectionStateChangedEvent(String componentId, boolean connected) {
            this.componentId = componentId;
            this.connected = connected;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_CONNECTION_STATE_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("connected=" + this.connected);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="connected")
        public boolean getConnected() {
            return this.connected;
        }
    }

    public static class TrackPublishingFailedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected boolean audio;
        protected boolean video;
        protected String errorMessage;

        @Deprecated
        public TrackPublishingFailedEvent() {
        }

        public TrackPublishingFailedEvent(String componentId, boolean audio, boolean video, String errorMessage) {
            this.componentId = componentId;
            this.audio = audio;
            this.video = video;
            this.errorMessage = errorMessage;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_TRACK_PUBLISHING_FAILED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("audio=" + this.audio) + ", " + ("video=" + this.video) + ", " + ("errorMessage=" + this.errorMessage);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="audio")
        public boolean getAudio() {
            return this.audio;
        }

        @JsonGetter(value="video")
        public boolean getVideo() {
            return this.video;
        }

        @JsonGetter(value="errorMessage")
        public String getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static class TrackPublishingSuccessfulEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected boolean audio;
        protected boolean video;

        @Deprecated
        public TrackPublishingSuccessfulEvent() {
        }

        public TrackPublishingSuccessfulEvent(String componentId, boolean audio, boolean video) {
            this.componentId = componentId;
            this.audio = audio;
            this.video = video;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_TRACK_PUBLISHING_SUCCESSFUL;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("audio=" + this.audio) + ", " + ("video=" + this.video);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="audio")
        public boolean getAudio() {
            return this.audio;
        }

        @JsonGetter(value="video")
        public boolean getVideo() {
            return this.video;
        }
    }

    public static class SourceMediaTrackEndedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected UiSourceMediaTrackType trackType;

        @Deprecated
        public SourceMediaTrackEndedEvent() {
        }

        public SourceMediaTrackEndedEvent(String componentId, UiSourceMediaTrackType trackType) {
            this.componentId = componentId;
            this.trackType = trackType;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_SOURCE_MEDIA_TRACK_ENDED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("trackType=" + this.trackType);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="trackType")
        public UiSourceMediaTrackType getTrackType() {
            return this.trackType;
        }
    }

    public static class SourceMediaTrackRetrievalFailedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected UiMediaRetrievalFailureReason reason;

        @Deprecated
        public SourceMediaTrackRetrievalFailedEvent() {
        }

        public SourceMediaTrackRetrievalFailedEvent(String componentId, UiMediaRetrievalFailureReason reason) {
            this.componentId = componentId;
            this.reason = reason;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_SOURCE_MEDIA_TRACK_RETRIEVAL_FAILED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("reason=" + this.reason);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="reason")
        public UiMediaRetrievalFailureReason getReason() {
            return this.reason;
        }
    }
}

