/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiCalendarEventClientRecord;
import org.teamapps.dto.UiCalendarViewMode;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiTemplate;
import org.teamapps.dto.UiWeekDay;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiCalendar
extends UiComponent
implements UiObject {
    protected Map<String, UiTemplate> templates;
    protected List<UiCalendarEventClientRecord> initialData;
    protected UiCalendarViewMode activeViewMode = UiCalendarViewMode.MONTH;
    protected long displayedDate = System.currentTimeMillis();
    protected boolean showHeader = true;
    protected boolean tableBorder = true;
    protected boolean showWeekNumbers = true;
    protected int businessHoursStart = 8;
    protected int businessHoursEnd = 17;
    protected UiWeekDay firstDayOfWeek = null;
    protected List<UiWeekDay> workingDays = Arrays.asList(UiWeekDay.MONDAY, UiWeekDay.TUESDAY, UiWeekDay.WEDNESDAY, UiWeekDay.THURSDAY, UiWeekDay.FRIDAY);
    protected String tableHeaderBackgroundColor = "rgb(255, 255, 255)";
    protected String defaultBackgroundColor = "rgb(154, 204, 228)";
    protected String defaultBorderColor = "rgb(154, 204, 228)";
    protected boolean navigateOnHeaderClicks = true;
    protected int minYearViewMonthTileWidth = 175;
    protected int maxYearViewMonthTileWidth = 0;
    protected String locale;
    protected String timeZoneId = "UTC";

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_CALENDAR;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("timeZoneId=" + this.timeZoneId) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + (String)(this.templates != null ? "templates={" + this.templates.toString() + "}" : "") + ", " + ("activeViewMode=" + this.activeViewMode) + ", " + ("displayedDate=" + this.displayedDate) + ", " + ("showHeader=" + this.showHeader) + ", " + ("tableBorder=" + this.tableBorder) + ", " + ("showWeekNumbers=" + this.showWeekNumbers) + ", " + ("businessHoursStart=" + this.businessHoursStart) + ", " + ("businessHoursEnd=" + this.businessHoursEnd) + ", " + ("firstDayOfWeek=" + this.firstDayOfWeek) + ", " + ("workingDays=" + this.workingDays) + ", " + ("tableHeaderBackgroundColor=" + this.tableHeaderBackgroundColor) + ", " + ("defaultBackgroundColor=" + this.defaultBackgroundColor) + ", " + ("defaultBorderColor=" + this.defaultBorderColor) + ", " + ("navigateOnHeaderClicks=" + this.navigateOnHeaderClicks) + ", " + ("minYearViewMonthTileWidth=" + this.minYearViewMonthTileWidth) + ", " + ("maxYearViewMonthTileWidth=" + this.maxYearViewMonthTileWidth) + ", " + ("locale=" + this.locale) + ", " + (String)(this.initialData != null ? "initialData={" + this.initialData.toString() + "}" : "");
    }

    @JsonGetter(value="templates")
    public Map<String, UiTemplate> getTemplates() {
        return this.templates;
    }

    @JsonGetter(value="initialData")
    public List<UiCalendarEventClientRecord> getInitialData() {
        return this.initialData;
    }

    @JsonGetter(value="activeViewMode")
    public UiCalendarViewMode getActiveViewMode() {
        return this.activeViewMode;
    }

    @JsonGetter(value="displayedDate")
    public long getDisplayedDate() {
        return this.displayedDate;
    }

    @JsonGetter(value="showHeader")
    public boolean getShowHeader() {
        return this.showHeader;
    }

    @JsonGetter(value="tableBorder")
    public boolean getTableBorder() {
        return this.tableBorder;
    }

    @JsonGetter(value="showWeekNumbers")
    public boolean getShowWeekNumbers() {
        return this.showWeekNumbers;
    }

    @JsonGetter(value="businessHoursStart")
    public int getBusinessHoursStart() {
        return this.businessHoursStart;
    }

    @JsonGetter(value="businessHoursEnd")
    public int getBusinessHoursEnd() {
        return this.businessHoursEnd;
    }

    @JsonGetter(value="firstDayOfWeek")
    public UiWeekDay getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    @JsonGetter(value="workingDays")
    public List<UiWeekDay> getWorkingDays() {
        return this.workingDays;
    }

    @JsonGetter(value="tableHeaderBackgroundColor")
    public String getTableHeaderBackgroundColor() {
        return this.tableHeaderBackgroundColor;
    }

    @JsonGetter(value="defaultBackgroundColor")
    public String getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    @JsonGetter(value="defaultBorderColor")
    public String getDefaultBorderColor() {
        return this.defaultBorderColor;
    }

    @JsonGetter(value="navigateOnHeaderClicks")
    public boolean getNavigateOnHeaderClicks() {
        return this.navigateOnHeaderClicks;
    }

    @JsonGetter(value="minYearViewMonthTileWidth")
    public int getMinYearViewMonthTileWidth() {
        return this.minYearViewMonthTileWidth;
    }

    @JsonGetter(value="maxYearViewMonthTileWidth")
    public int getMaxYearViewMonthTileWidth() {
        return this.maxYearViewMonthTileWidth;
    }

    @JsonGetter(value="locale")
    public String getLocale() {
        return this.locale;
    }

    @JsonGetter(value="timeZoneId")
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    @Override
    @JsonSetter(value="id")
    public UiCalendar setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiCalendar setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiCalendar setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiCalendar setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="templates")
    public UiCalendar setTemplates(Map<String, UiTemplate> templates) {
        this.templates = templates;
        return this;
    }

    @JsonSetter(value="initialData")
    public UiCalendar setInitialData(List<UiCalendarEventClientRecord> initialData) {
        this.initialData = initialData;
        return this;
    }

    @JsonSetter(value="activeViewMode")
    public UiCalendar setActiveViewMode(UiCalendarViewMode activeViewMode) {
        this.activeViewMode = activeViewMode;
        return this;
    }

    @JsonSetter(value="displayedDate")
    public UiCalendar setDisplayedDate(long displayedDate) {
        this.displayedDate = displayedDate;
        return this;
    }

    @JsonSetter(value="showHeader")
    public UiCalendar setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
        return this;
    }

    @JsonSetter(value="tableBorder")
    public UiCalendar setTableBorder(boolean tableBorder) {
        this.tableBorder = tableBorder;
        return this;
    }

    @JsonSetter(value="showWeekNumbers")
    public UiCalendar setShowWeekNumbers(boolean showWeekNumbers) {
        this.showWeekNumbers = showWeekNumbers;
        return this;
    }

    @JsonSetter(value="businessHoursStart")
    public UiCalendar setBusinessHoursStart(int businessHoursStart) {
        this.businessHoursStart = businessHoursStart;
        return this;
    }

    @JsonSetter(value="businessHoursEnd")
    public UiCalendar setBusinessHoursEnd(int businessHoursEnd) {
        this.businessHoursEnd = businessHoursEnd;
        return this;
    }

    @JsonSetter(value="firstDayOfWeek")
    public UiCalendar setFirstDayOfWeek(UiWeekDay firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
        return this;
    }

    @JsonSetter(value="workingDays")
    public UiCalendar setWorkingDays(List<UiWeekDay> workingDays) {
        this.workingDays = workingDays;
        return this;
    }

    @JsonSetter(value="tableHeaderBackgroundColor")
    public UiCalendar setTableHeaderBackgroundColor(String tableHeaderBackgroundColor) {
        this.tableHeaderBackgroundColor = tableHeaderBackgroundColor;
        return this;
    }

    @JsonSetter(value="defaultBackgroundColor")
    public UiCalendar setDefaultBackgroundColor(String defaultBackgroundColor) {
        this.defaultBackgroundColor = defaultBackgroundColor;
        return this;
    }

    @JsonSetter(value="defaultBorderColor")
    public UiCalendar setDefaultBorderColor(String defaultBorderColor) {
        this.defaultBorderColor = defaultBorderColor;
        return this;
    }

    @JsonSetter(value="navigateOnHeaderClicks")
    public UiCalendar setNavigateOnHeaderClicks(boolean navigateOnHeaderClicks) {
        this.navigateOnHeaderClicks = navigateOnHeaderClicks;
        return this;
    }

    @JsonSetter(value="minYearViewMonthTileWidth")
    public UiCalendar setMinYearViewMonthTileWidth(int minYearViewMonthTileWidth) {
        this.minYearViewMonthTileWidth = minYearViewMonthTileWidth;
        return this;
    }

    @JsonSetter(value="maxYearViewMonthTileWidth")
    public UiCalendar setMaxYearViewMonthTileWidth(int maxYearViewMonthTileWidth) {
        this.maxYearViewMonthTileWidth = maxYearViewMonthTileWidth;
        return this;
    }

    @JsonSetter(value="locale")
    public UiCalendar setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    @JsonSetter(value="timeZoneId")
    public UiCalendar setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
        return this;
    }

    public static class SetTimeZoneIdCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String timeZoneId;

        @Deprecated
        public SetTimeZoneIdCommand() {
        }

        public SetTimeZoneIdCommand(String componentId, String timeZoneId) {
            this.componentId = componentId;
            this.timeZoneId = timeZoneId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("timeZoneId=" + this.timeZoneId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="timeZoneId")
        public String getTimeZoneId() {
            return this.timeZoneId;
        }
    }

    public static class RegisterTemplateCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String id;
        protected UiTemplate template;

        @Deprecated
        public RegisterTemplateCommand() {
        }

        public RegisterTemplateCommand(String componentId, String id, UiTemplate template) {
            this.componentId = componentId;
            this.id = id;
            this.template = template;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("componentId=" + this.componentId) + ", " + (String)(this.template != null ? "template={" + this.template.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="id")
        public String getId() {
            return this.id;
        }

        @JsonGetter(value="template")
        public UiTemplate getTemplate() {
            return this.template;
        }
    }

    public static class ClearCalendarCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public ClearCalendarCommand() {
        }

        public ClearCalendarCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class SetCalendarDataCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<UiCalendarEventClientRecord> events;

        @Deprecated
        public SetCalendarDataCommand() {
        }

        public SetCalendarDataCommand(String componentId, List<UiCalendarEventClientRecord> events) {
            this.componentId = componentId;
            this.events = events;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.events != null ? "events={" + this.events.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="events")
        public List<UiCalendarEventClientRecord> getEvents() {
            return this.events;
        }
    }

    public static class RemoveEventCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int eventId;

        @Deprecated
        public RemoveEventCommand() {
        }

        public RemoveEventCommand(String componentId, int eventId) {
            this.componentId = componentId;
            this.eventId = eventId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("eventId=" + this.eventId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="eventId")
        public int getEventId() {
            return this.eventId;
        }
    }

    public static class AddEventCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiCalendarEventClientRecord theEvent;

        @Deprecated
        public AddEventCommand() {
        }

        public AddEventCommand(String componentId, UiCalendarEventClientRecord theEvent) {
            this.componentId = componentId;
            this.theEvent = theEvent;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.theEvent != null ? "theEvent={" + this.theEvent.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="theEvent")
        public UiCalendarEventClientRecord getTheEvent() {
            return this.theEvent;
        }
    }

    public static class SetDisplayedDateCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected long date;

        @Deprecated
        public SetDisplayedDateCommand() {
        }

        public SetDisplayedDateCommand(String componentId, long date) {
            this.componentId = componentId;
            this.date = date;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("date=" + this.date);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="date")
        public long getDate() {
            return this.date;
        }
    }

    public static class SetViewModeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiCalendarViewMode viewMode;

        @Deprecated
        public SetViewModeCommand() {
        }

        public SetViewModeCommand(String componentId, UiCalendarViewMode viewMode) {
            this.componentId = componentId;
            this.viewMode = viewMode;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("viewMode=" + this.viewMode);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="viewMode")
        public UiCalendarViewMode getViewMode() {
            return this.viewMode;
        }
    }

    public static class DataNeededEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected long requestIntervalStart;
        protected long requestIntervalEnd;

        @Deprecated
        public DataNeededEvent() {
        }

        public DataNeededEvent(String componentId, long requestIntervalStart, long requestIntervalEnd) {
            this.componentId = componentId;
            this.requestIntervalStart = requestIntervalStart;
            this.requestIntervalEnd = requestIntervalEnd;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_CALENDAR_DATA_NEEDED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("requestIntervalStart=" + this.requestIntervalStart) + ", " + ("requestIntervalEnd=" + this.requestIntervalEnd);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="requestIntervalStart")
        public long getRequestIntervalStart() {
            return this.requestIntervalStart;
        }

        @JsonGetter(value="requestIntervalEnd")
        public long getRequestIntervalEnd() {
            return this.requestIntervalEnd;
        }
    }

    public static class ViewChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected UiCalendarViewMode viewMode;
        protected long mainIntervalStart;
        protected long mainIntervalEnd;
        protected long displayedIntervalStart;
        protected long displayedIntervalEnd;

        @Deprecated
        public ViewChangedEvent() {
        }

        public ViewChangedEvent(String componentId, UiCalendarViewMode viewMode, long mainIntervalStart, long mainIntervalEnd, long displayedIntervalStart, long displayedIntervalEnd) {
            this.componentId = componentId;
            this.viewMode = viewMode;
            this.mainIntervalStart = mainIntervalStart;
            this.mainIntervalEnd = mainIntervalEnd;
            this.displayedIntervalStart = displayedIntervalStart;
            this.displayedIntervalEnd = displayedIntervalEnd;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_CALENDAR_VIEW_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("viewMode=" + this.viewMode) + ", " + ("mainIntervalStart=" + this.mainIntervalStart) + ", " + ("mainIntervalEnd=" + this.mainIntervalEnd) + ", " + ("displayedIntervalStart=" + this.displayedIntervalStart) + ", " + ("displayedIntervalEnd=" + this.displayedIntervalEnd);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="viewMode")
        public UiCalendarViewMode getViewMode() {
            return this.viewMode;
        }

        @JsonGetter(value="mainIntervalStart")
        public long getMainIntervalStart() {
            return this.mainIntervalStart;
        }

        @JsonGetter(value="mainIntervalEnd")
        public long getMainIntervalEnd() {
            return this.mainIntervalEnd;
        }

        @JsonGetter(value="displayedIntervalStart")
        public long getDisplayedIntervalStart() {
            return this.displayedIntervalStart;
        }

        @JsonGetter(value="displayedIntervalEnd")
        public long getDisplayedIntervalEnd() {
            return this.displayedIntervalEnd;
        }
    }

    public static class MonthHeaderClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int year;
        protected int month;
        protected long monthStartDate;

        @Deprecated
        public MonthHeaderClickedEvent() {
        }

        public MonthHeaderClickedEvent(String componentId, int year, int month, long monthStartDate) {
            this.componentId = componentId;
            this.year = year;
            this.month = month;
            this.monthStartDate = monthStartDate;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_CALENDAR_MONTH_HEADER_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("year=" + this.year) + ", " + ("month=" + this.month) + ", " + ("monthStartDate=" + this.monthStartDate);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="year")
        public int getYear() {
            return this.year;
        }

        @JsonGetter(value="month")
        public int getMonth() {
            return this.month;
        }

        @JsonGetter(value="monthStartDate")
        public long getMonthStartDate() {
            return this.monthStartDate;
        }
    }

    public static class WeekHeaderClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int year;
        protected int week;
        protected long weekStartDate;

        @Deprecated
        public WeekHeaderClickedEvent() {
        }

        public WeekHeaderClickedEvent(String componentId, int year, int week, long weekStartDate) {
            this.componentId = componentId;
            this.year = year;
            this.week = week;
            this.weekStartDate = weekStartDate;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_CALENDAR_WEEK_HEADER_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("year=" + this.year) + ", " + ("week=" + this.week) + ", " + ("weekStartDate=" + this.weekStartDate);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="year")
        public int getYear() {
            return this.year;
        }

        @JsonGetter(value="week")
        public int getWeek() {
            return this.week;
        }

        @JsonGetter(value="weekStartDate")
        public long getWeekStartDate() {
            return this.weekStartDate;
        }
    }

    public static class DayHeaderClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected long date;

        @Deprecated
        public DayHeaderClickedEvent() {
        }

        public DayHeaderClickedEvent(String componentId, long date) {
            this.componentId = componentId;
            this.date = date;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_CALENDAR_DAY_HEADER_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("date=" + this.date);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="date")
        public long getDate() {
            return this.date;
        }
    }

    public static class IntervalSelectedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected long start;
        protected long end;
        protected boolean allDay;

        @Deprecated
        public IntervalSelectedEvent() {
        }

        public IntervalSelectedEvent(String componentId, long start, long end, boolean allDay) {
            this.componentId = componentId;
            this.start = start;
            this.end = end;
            this.allDay = allDay;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_CALENDAR_INTERVAL_SELECTED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("start=" + this.start) + ", " + ("end=" + this.end) + ", " + ("allDay=" + this.allDay);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="start")
        public long getStart() {
            return this.start;
        }

        @JsonGetter(value="end")
        public long getEnd() {
            return this.end;
        }

        @JsonGetter(value="allDay")
        public boolean getAllDay() {
            return this.allDay;
        }
    }

    public static class DayClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected long date;
        protected boolean isDoubleClick;

        @Deprecated
        public DayClickedEvent() {
        }

        public DayClickedEvent(String componentId, long date, boolean isDoubleClick) {
            this.componentId = componentId;
            this.date = date;
            this.isDoubleClick = isDoubleClick;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_CALENDAR_DAY_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("date=" + this.date) + ", " + ("isDoubleClick=" + this.isDoubleClick);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="date")
        public long getDate() {
            return this.date;
        }

        @JsonGetter(value="isDoubleClick")
        public boolean getIsDoubleClick() {
            return this.isDoubleClick;
        }
    }

    public static class EventMovedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int eventId;
        protected long newStart;
        protected long newEnd;

        @Deprecated
        public EventMovedEvent() {
        }

        public EventMovedEvent(String componentId, int eventId, long newStart, long newEnd) {
            this.componentId = componentId;
            this.eventId = eventId;
            this.newStart = newStart;
            this.newEnd = newEnd;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_CALENDAR_EVENT_MOVED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("eventId=" + this.eventId) + ", " + ("newStart=" + this.newStart) + ", " + ("newEnd=" + this.newEnd);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="eventId")
        public int getEventId() {
            return this.eventId;
        }

        @JsonGetter(value="newStart")
        public long getNewStart() {
            return this.newStart;
        }

        @JsonGetter(value="newEnd")
        public long getNewEnd() {
            return this.newEnd;
        }
    }

    public static class EventClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int eventId;
        protected boolean isDoubleClick;

        @Deprecated
        public EventClickedEvent() {
        }

        public EventClickedEvent(String componentId, int eventId, boolean isDoubleClick) {
            this.componentId = componentId;
            this.eventId = eventId;
            this.isDoubleClick = isDoubleClick;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_CALENDAR_EVENT_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("eventId=" + this.eventId) + ", " + ("isDoubleClick=" + this.isDoubleClick);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="eventId")
        public int getEventId() {
            return this.eventId;
        }

        @JsonGetter(value="isDoubleClick")
        public boolean getIsDoubleClick() {
            return this.isDoubleClick;
        }
    }
}

