/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiFieldEditingMode;
import org.teamapps.dto.UiFieldMessage;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiTextInputHandlingField;
import org.teamapps.dto.UiToolbarVisibilityMode;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiRichTextEditor
extends UiField
implements UiTextInputHandlingField,
UiObject {
    protected String locale;
    protected String uploadUrl = "/upload";
    protected long maxImageFileSizeInBytes = 5000000L;
    protected UiToolbarVisibilityMode toolbarVisibilityMode = UiToolbarVisibilityMode.VISIBLE_IF_FOCUSED;
    protected int minHeight = 150;
    protected int maxHeight = 150;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_RICH_TEXT_EDITOR;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("editingMode=" + this.editingMode) + ", " + ("value=" + this.value) + ", " + ("locale=" + this.locale) + ", " + ("uploadUrl=" + this.uploadUrl) + ", " + ("maxImageFileSizeInBytes=" + this.maxImageFileSizeInBytes) + ", " + ("toolbarVisibilityMode=" + this.toolbarVisibilityMode) + ", " + ("minHeight=" + this.minHeight) + ", " + ("maxHeight=" + this.maxHeight) + ", " + (String)(this.fieldMessages != null ? "fieldMessages={" + this.fieldMessages.toString() + "}" : "");
    }

    @JsonGetter(value="locale")
    public String getLocale() {
        return this.locale;
    }

    @JsonGetter(value="uploadUrl")
    public String getUploadUrl() {
        return this.uploadUrl;
    }

    @JsonGetter(value="maxImageFileSizeInBytes")
    public long getMaxImageFileSizeInBytes() {
        return this.maxImageFileSizeInBytes;
    }

    @JsonGetter(value="toolbarVisibilityMode")
    public UiToolbarVisibilityMode getToolbarVisibilityMode() {
        return this.toolbarVisibilityMode;
    }

    @JsonGetter(value="minHeight")
    public int getMinHeight() {
        return this.minHeight;
    }

    @JsonGetter(value="maxHeight")
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    @JsonSetter(value="id")
    public UiRichTextEditor setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiRichTextEditor setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiRichTextEditor setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiRichTextEditor setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="editingMode")
    public UiRichTextEditor setEditingMode(UiFieldEditingMode editingMode) {
        this.editingMode = editingMode;
        return this;
    }

    @Override
    @JsonSetter(value="value")
    public UiRichTextEditor setValue(Object value) {
        this.value = value;
        return this;
    }

    @Override
    @JsonSetter(value="fieldMessages")
    public UiRichTextEditor setFieldMessages(List<UiFieldMessage> fieldMessages) {
        this.fieldMessages = fieldMessages;
        return this;
    }

    @JsonSetter(value="locale")
    public UiRichTextEditor setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    @JsonSetter(value="uploadUrl")
    public UiRichTextEditor setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
        return this;
    }

    @JsonSetter(value="maxImageFileSizeInBytes")
    public UiRichTextEditor setMaxImageFileSizeInBytes(long maxImageFileSizeInBytes) {
        this.maxImageFileSizeInBytes = maxImageFileSizeInBytes;
        return this;
    }

    @JsonSetter(value="toolbarVisibilityMode")
    public UiRichTextEditor setToolbarVisibilityMode(UiToolbarVisibilityMode toolbarVisibilityMode) {
        this.toolbarVisibilityMode = toolbarVisibilityMode;
        return this;
    }

    @JsonSetter(value="minHeight")
    public UiRichTextEditor setMinHeight(int minHeight) {
        this.minHeight = minHeight;
        return this;
    }

    @JsonSetter(value="maxHeight")
    public UiRichTextEditor setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public static class SetToolbarVisibilityModeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiToolbarVisibilityMode toolbarVisibilityMode;

        @Deprecated
        public SetToolbarVisibilityModeCommand() {
        }

        public SetToolbarVisibilityModeCommand(String componentId, UiToolbarVisibilityMode toolbarVisibilityMode) {
            this.componentId = componentId;
            this.toolbarVisibilityMode = toolbarVisibilityMode;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("toolbarVisibilityMode=" + this.toolbarVisibilityMode);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="toolbarVisibilityMode")
        public UiToolbarVisibilityMode getToolbarVisibilityMode() {
            return this.toolbarVisibilityMode;
        }
    }

    public static class SetUploadedImageUrlCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String fileUuid;
        protected String url;

        @Deprecated
        public SetUploadedImageUrlCommand() {
        }

        public SetUploadedImageUrlCommand(String componentId, String fileUuid, String url) {
            this.componentId = componentId;
            this.fileUuid = fileUuid;
            this.url = url;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileUuid=" + this.fileUuid) + ", " + ("url=" + this.url);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileUuid")
        public String getFileUuid() {
            return this.fileUuid;
        }

        @JsonGetter(value="url")
        public String getUrl() {
            return this.url;
        }
    }

    public static class SetMaxImageFileSizeInBytesCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected long maxImageFileSizeInBytes;

        @Deprecated
        public SetMaxImageFileSizeInBytesCommand() {
        }

        public SetMaxImageFileSizeInBytesCommand(String componentId, long maxImageFileSizeInBytes) {
            this.componentId = componentId;
            this.maxImageFileSizeInBytes = maxImageFileSizeInBytes;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("maxImageFileSizeInBytes=" + this.maxImageFileSizeInBytes);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="maxImageFileSizeInBytes")
        public long getMaxImageFileSizeInBytes() {
            return this.maxImageFileSizeInBytes;
        }
    }

    public static class SetUploadUrlCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String uploadUrl;

        @Deprecated
        public SetUploadUrlCommand() {
        }

        public SetUploadUrlCommand(String componentId, String uploadUrl) {
            this.componentId = componentId;
            this.uploadUrl = uploadUrl;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("uploadUrl=" + this.uploadUrl);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="uploadUrl")
        public String getUploadUrl() {
            return this.uploadUrl;
        }
    }

    public static class SetMaxHeightCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int maxHeight;

        @Deprecated
        public SetMaxHeightCommand() {
        }

        public SetMaxHeightCommand(String componentId, int maxHeight) {
            this.componentId = componentId;
            this.maxHeight = maxHeight;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("maxHeight=" + this.maxHeight);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="maxHeight")
        public int getMaxHeight() {
            return this.maxHeight;
        }
    }

    public static class SetMinHeightCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int minHeight;

        @Deprecated
        public SetMinHeightCommand() {
        }

        public SetMinHeightCommand(String componentId, int minHeight) {
            this.componentId = componentId;
            this.minHeight = minHeight;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("minHeight=" + this.minHeight);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="minHeight")
        public int getMinHeight() {
            return this.minHeight;
        }
    }

    public static class ImageUploadFailedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String name;
        protected String mimeType;
        protected long sizeInBytes;
        protected int incompleteUploadsCount;

        @Deprecated
        public ImageUploadFailedEvent() {
        }

        public ImageUploadFailedEvent(String componentId, String name, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
            this.componentId = componentId;
            this.name = name;
            this.mimeType = mimeType;
            this.sizeInBytes = sizeInBytes;
            this.incompleteUploadsCount = incompleteUploadsCount;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_RICH_TEXT_EDITOR_IMAGE_UPLOAD_FAILED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("name=" + this.name) + ", " + ("componentId=" + this.componentId) + ", " + ("mimeType=" + this.mimeType) + ", " + ("sizeInBytes=" + this.sizeInBytes) + ", " + ("incompleteUploadsCount=" + this.incompleteUploadsCount);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="name")
        public String getName() {
            return this.name;
        }

        @JsonGetter(value="mimeType")
        public String getMimeType() {
            return this.mimeType;
        }

        @JsonGetter(value="sizeInBytes")
        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        @JsonGetter(value="incompleteUploadsCount")
        public int getIncompleteUploadsCount() {
            return this.incompleteUploadsCount;
        }
    }

    public static class ImageUploadSuccessfulEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileUuid;
        protected String name;
        protected String mimeType;
        protected long sizeInBytes;
        protected int incompleteUploadsCount;

        @Deprecated
        public ImageUploadSuccessfulEvent() {
        }

        public ImageUploadSuccessfulEvent(String componentId, String fileUuid, String name, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
            this.componentId = componentId;
            this.fileUuid = fileUuid;
            this.name = name;
            this.mimeType = mimeType;
            this.sizeInBytes = sizeInBytes;
            this.incompleteUploadsCount = incompleteUploadsCount;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_RICH_TEXT_EDITOR_IMAGE_UPLOAD_SUCCESSFUL;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("name=" + this.name) + ", " + ("componentId=" + this.componentId) + ", " + ("fileUuid=" + this.fileUuid) + ", " + ("mimeType=" + this.mimeType) + ", " + ("sizeInBytes=" + this.sizeInBytes) + ", " + ("incompleteUploadsCount=" + this.incompleteUploadsCount);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileUuid")
        public String getFileUuid() {
            return this.fileUuid;
        }

        @JsonGetter(value="name")
        public String getName() {
            return this.name;
        }

        @JsonGetter(value="mimeType")
        public String getMimeType() {
            return this.mimeType;
        }

        @JsonGetter(value="sizeInBytes")
        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        @JsonGetter(value="incompleteUploadsCount")
        public int getIncompleteUploadsCount() {
            return this.incompleteUploadsCount;
        }
    }

    public static class ImageUploadStartedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileName;
        protected String mimeType;
        protected long sizeInBytes;
        protected int incompleteUploadsCount;

        @Deprecated
        public ImageUploadStartedEvent() {
        }

        public ImageUploadStartedEvent(String componentId, String fileName, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
            this.componentId = componentId;
            this.fileName = fileName;
            this.mimeType = mimeType;
            this.sizeInBytes = sizeInBytes;
            this.incompleteUploadsCount = incompleteUploadsCount;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_RICH_TEXT_EDITOR_IMAGE_UPLOAD_STARTED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileName=" + this.fileName) + ", " + ("mimeType=" + this.mimeType) + ", " + ("sizeInBytes=" + this.sizeInBytes) + ", " + ("incompleteUploadsCount=" + this.incompleteUploadsCount);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileName")
        public String getFileName() {
            return this.fileName;
        }

        @JsonGetter(value="mimeType")
        public String getMimeType() {
            return this.mimeType;
        }

        @JsonGetter(value="sizeInBytes")
        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        @JsonGetter(value="incompleteUploadsCount")
        public int getIncompleteUploadsCount() {
            return this.incompleteUploadsCount;
        }
    }

    public static class ImageUploadTooLargeEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileName;
        protected String mimeType;
        protected long sizeInBytes;

        @Deprecated
        public ImageUploadTooLargeEvent() {
        }

        public ImageUploadTooLargeEvent(String componentId, String fileName, String mimeType, long sizeInBytes) {
            this.componentId = componentId;
            this.fileName = fileName;
            this.mimeType = mimeType;
            this.sizeInBytes = sizeInBytes;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_RICH_TEXT_EDITOR_IMAGE_UPLOAD_TOO_LARGE;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileName=" + this.fileName) + ", " + ("mimeType=" + this.mimeType) + ", " + ("sizeInBytes=" + this.sizeInBytes);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileName")
        public String getFileName() {
            return this.fileName;
        }

        @JsonGetter(value="mimeType")
        public String getMimeType() {
            return this.mimeType;
        }

        @JsonGetter(value="sizeInBytes")
        public long getSizeInBytes() {
            return this.sizeInBytes;
        }
    }
}

