package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiFloatingComponent extends UiComponent implements UiObject {


	protected UiClientObjectReference containerComponent;
	protected UiClientObjectReference contentComponent;
	protected int width;
	protected int height;
	protected int marginX;
	protected int marginY;
	protected UiFloatingComponentPosition position;
	protected String backgroundColor;
	protected String expanderHandleColor;
	protected boolean collapsible = true;
	protected boolean expanded = true;

	public UiFloatingComponent() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_FLOATING_COMPONENT;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("width=" + width).append(", ")
				.append("height=" + height).append(", ")
				.append("marginX=" + marginX).append(", ")
				.append("marginY=" + marginY).append(", ")
				.append("position=" + position).append(", ")
				.append("backgroundColor=" + backgroundColor).append(", ")
				.append("expanderHandleColor=" + expanderHandleColor).append(", ")
				.append("collapsible=" + collapsible).append(", ")
				.append("expanded=" + expanded).append(", ")
				.append(containerComponent != null ? "containerComponent={" + containerComponent.toString() + "}" : "").append(", ")
				.append(contentComponent != null ? "contentComponent={" + contentComponent.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("containerComponent")
	public UiClientObjectReference getContainerComponent() {
		return containerComponent;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("contentComponent")
	public UiClientObjectReference getContentComponent() {
		return contentComponent;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("width")
	public int getWidth() {
		return width;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("height")
	public int getHeight() {
		return height;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("marginX")
	public int getMarginX() {
		return marginX;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("marginY")
	public int getMarginY() {
		return marginY;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("position")
	public UiFloatingComponentPosition getPosition() {
		return position;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
	public String getBackgroundColor() {
		return backgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("expanderHandleColor")
	public String getExpanderHandleColor() {
		return expanderHandleColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("collapsible")
	public boolean getCollapsible() {
		return collapsible;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("expanded")
	public boolean getExpanded() {
		return expanded;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiFloatingComponent setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiFloatingComponent setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiFloatingComponent setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiFloatingComponent setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiFloatingComponent setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("containerComponent")
	public UiFloatingComponent setContainerComponent(UiClientObjectReference containerComponent) {
		this.containerComponent = containerComponent;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("contentComponent")
	public UiFloatingComponent setContentComponent(UiClientObjectReference contentComponent) {
		this.contentComponent = contentComponent;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("width")
	public UiFloatingComponent setWidth(int width) {
		this.width = width;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("height")
	public UiFloatingComponent setHeight(int height) {
		this.height = height;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("marginX")
	public UiFloatingComponent setMarginX(int marginX) {
		this.marginX = marginX;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("marginY")
	public UiFloatingComponent setMarginY(int marginY) {
		this.marginY = marginY;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("position")
	public UiFloatingComponent setPosition(UiFloatingComponentPosition position) {
		this.position = position;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundColor")
	public UiFloatingComponent setBackgroundColor(String backgroundColor) {
		this.backgroundColor = backgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("expanderHandleColor")
	public UiFloatingComponent setExpanderHandleColor(String expanderHandleColor) {
		this.expanderHandleColor = expanderHandleColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("collapsible")
	public UiFloatingComponent setCollapsible(boolean collapsible) {
		this.collapsible = collapsible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("expanded")
	public UiFloatingComponent setExpanded(boolean expanded) {
		this.expanded = expanded;
		return this;
	}

	public static class ExpandedOrCollapsedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected boolean expanded;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ExpandedOrCollapsedEvent() {
			// default constructor for Jackson
		}

		public ExpandedOrCollapsedEvent(String componentId, boolean expanded) {
			this.componentId = componentId;
			this.expanded = expanded;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_FLOATING_COMPONENT_EXPANDED_OR_COLLAPSED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("expanded=" + expanded)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("expanded")
		public boolean getExpanded() {
			return expanded;
		}

	}

	public static class SetContentComponentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiClientObjectReference contentComponent;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetContentComponentCommand() {
			// default constructor for Jackson
		}

		public SetContentComponentCommand(String componentId, UiClientObjectReference contentComponent) {
			this.componentId = componentId;
			this.contentComponent = contentComponent;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(contentComponent != null ? "contentComponent={" + contentComponent.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("contentComponent")
		public UiClientObjectReference getContentComponent() {
			return contentComponent;
		}

	}

	public static class SetExpandedCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean expanded;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetExpandedCommand() {
			// default constructor for Jackson
		}

		public SetExpandedCommand(String componentId, boolean expanded) {
			this.componentId = componentId;
			this.expanded = expanded;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("expanded=" + expanded)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("expanded")
		public boolean getExpanded() {
			return expanded;
		}

	}

	public static class SetPositionCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiFloatingComponentPosition position;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetPositionCommand() {
			// default constructor for Jackson
		}

		public SetPositionCommand(String componentId, UiFloatingComponentPosition position) {
			this.componentId = componentId;
			this.position = position;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("position=" + position)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("position")
		public UiFloatingComponentPosition getPosition() {
			return position;
		}

	}

	public static class SetDimensionsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int width;
		protected int height;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetDimensionsCommand() {
			// default constructor for Jackson
		}

		public SetDimensionsCommand(String componentId, int width, int height) {
			this.componentId = componentId;
			this.width = width;
			this.height = height;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("width=" + width).append(", ")
					.append("height=" + height)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("width")
		public int getWidth() {
			return width;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("height")
		public int getHeight() {
			return height;
		}

	}

	public static class SetMarginsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int marginX;
		protected int marginY;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMarginsCommand() {
			// default constructor for Jackson
		}

		public SetMarginsCommand(String componentId, int marginX, int marginY) {
			this.componentId = componentId;
			this.marginX = marginX;
			this.marginY = marginY;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("marginX=" + marginX).append(", ")
					.append("marginY=" + marginY)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("marginX")
		public int getMarginX() {
			return marginX;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("marginY")
		public int getMarginY() {
			return marginY;
		}

	}

	public static class SetBackgroundColorCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String backgroundColor;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetBackgroundColorCommand() {
			// default constructor for Jackson
		}

		public SetBackgroundColorCommand(String componentId, String backgroundColor) {
			this.componentId = componentId;
			this.backgroundColor = backgroundColor;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("backgroundColor=" + backgroundColor)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
		public String getBackgroundColor() {
			return backgroundColor;
		}

	}

	public static class SetExpanderHandleColorCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String expanderHandleColor;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetExpanderHandleColorCommand() {
			// default constructor for Jackson
		}

		public SetExpanderHandleColorCommand(String componentId, String expanderHandleColor) {
			this.componentId = componentId;
			this.expanderHandleColor = expanderHandleColor;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("expanderHandleColor=" + expanderHandleColor)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("expanderHandleColor")
		public String getExpanderHandleColor() {
			return expanderHandleColor;
		}

	}




}