package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiImageDisplay extends UiComponent implements UiObject {


	protected int totalNumberOfRecords;
	protected List<UiCachedImage> cachedImages;
	protected UiPageDisplayMode displayMode = UiPageDisplayMode.FIT_WIDTH;
	protected float zoomFactor = 1f;
	protected String backgroundColor = "#444";
	protected int padding = 0;
	protected boolean loop = false;
	protected int cacheSize = 2;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiImageDisplay() {
		// default constructor for Jackson
	}

	public UiImageDisplay(int totalNumberOfRecords) {
		super();
		this.totalNumberOfRecords = totalNumberOfRecords;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_IMAGE_DISPLAY;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("totalNumberOfRecords=" + totalNumberOfRecords).append(", ")
				.append("displayMode=" + displayMode).append(", ")
				.append("zoomFactor=" + zoomFactor).append(", ")
				.append("backgroundColor=" + backgroundColor).append(", ")
				.append("padding=" + padding).append(", ")
				.append("loop=" + loop).append(", ")
				.append("cacheSize=" + cacheSize).append(", ")
				.append(cachedImages != null ? "cachedImages={" + cachedImages.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("totalNumberOfRecords")
	public int getTotalNumberOfRecords() {
		return totalNumberOfRecords;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("cachedImages")
	public List<UiCachedImage> getCachedImages() {
		return cachedImages;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("displayMode")
	public UiPageDisplayMode getDisplayMode() {
		return displayMode;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("zoomFactor")
	public float getZoomFactor() {
		return zoomFactor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
	public String getBackgroundColor() {
		return backgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("padding")
	public int getPadding() {
		return padding;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("loop")
	public boolean getLoop() {
		return loop;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("cacheSize")
	public int getCacheSize() {
		return cacheSize;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiImageDisplay setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiImageDisplay setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiImageDisplay setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiImageDisplay setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiImageDisplay setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("cachedImages")
	public UiImageDisplay setCachedImages(List<UiCachedImage> cachedImages) {
		this.cachedImages = cachedImages;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("displayMode")
	public UiImageDisplay setDisplayMode(UiPageDisplayMode displayMode) {
		this.displayMode = displayMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("zoomFactor")
	public UiImageDisplay setZoomFactor(float zoomFactor) {
		this.zoomFactor = zoomFactor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundColor")
	public UiImageDisplay setBackgroundColor(String backgroundColor) {
		this.backgroundColor = backgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("padding")
	public UiImageDisplay setPadding(int padding) {
		this.padding = padding;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("loop")
	public UiImageDisplay setLoop(boolean loop) {
		this.loop = loop;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("cacheSize")
	public UiImageDisplay setCacheSize(int cacheSize) {
		this.cacheSize = cacheSize;
		return this;
	}

	public static class ImagesRequestEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected int startIndex;
		protected int length;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ImagesRequestEvent() {
			// default constructor for Jackson
		}

		public ImagesRequestEvent(String componentId, int startIndex, int length) {
			this.componentId = componentId;
			this.startIndex = startIndex;
			this.length = length;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_IMAGE_DISPLAY_IMAGES_REQUEST;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("startIndex=" + startIndex).append(", ")
					.append("length=" + length)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("startIndex")
		public int getStartIndex() {
			return startIndex;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("length")
		public int getLength() {
			return length;
		}

	}

	public static class ImageDisplayedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String imageId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ImageDisplayedEvent() {
			// default constructor for Jackson
		}

		public ImageDisplayedEvent(String componentId, String imageId) {
			this.componentId = componentId;
			this.imageId = imageId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_IMAGE_DISPLAY_IMAGE_DISPLAYED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("imageId=" + imageId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("imageId")
		public String getImageId() {
			return imageId;
		}

	}

	public static class SetCachedImagesCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int startIndex;
		protected List<UiCachedImage> cachedImages;
		protected int totalNumberOfRecords;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetCachedImagesCommand() {
			// default constructor for Jackson
		}

		public SetCachedImagesCommand(String componentId, int startIndex, List<UiCachedImage> cachedImages, int totalNumberOfRecords) {
			this.componentId = componentId;
			this.startIndex = startIndex;
			this.cachedImages = cachedImages;
			this.totalNumberOfRecords = totalNumberOfRecords;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("startIndex=" + startIndex).append(", ")
					.append("totalNumberOfRecords=" + totalNumberOfRecords).append(", ")
					.append(cachedImages != null ? "cachedImages={" + cachedImages.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("startIndex")
		public int getStartIndex() {
			return startIndex;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("cachedImages")
		public List<UiCachedImage> getCachedImages() {
			return cachedImages;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("totalNumberOfRecords")
		public int getTotalNumberOfRecords() {
			return totalNumberOfRecords;
		}

	}

	public static class SetDisplayModeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiPageDisplayMode displayMode;
		protected float zoomFactor;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetDisplayModeCommand() {
			// default constructor for Jackson
		}

		public SetDisplayModeCommand(String componentId, UiPageDisplayMode displayMode, float zoomFactor) {
			this.componentId = componentId;
			this.displayMode = displayMode;
			this.zoomFactor = zoomFactor;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("displayMode=" + displayMode).append(", ")
					.append("zoomFactor=" + zoomFactor)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("displayMode")
		public UiPageDisplayMode getDisplayMode() {
			return displayMode;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("zoomFactor")
		public float getZoomFactor() {
			return zoomFactor;
		}

	}

	public static class SetZoomFactorCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected float zoomFactor;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetZoomFactorCommand() {
			// default constructor for Jackson
		}

		public SetZoomFactorCommand(String componentId, float zoomFactor) {
			this.componentId = componentId;
			this.zoomFactor = zoomFactor;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("zoomFactor=" + zoomFactor)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("zoomFactor")
		public float getZoomFactor() {
			return zoomFactor;
		}

	}

	public static class ShowImageCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String id;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ShowImageCommand() {
			// default constructor for Jackson
		}

		public ShowImageCommand(String componentId, String id) {
			this.componentId = componentId;
			this.id = id;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("id=" + id).append(", ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("id")
		public String getId() {
			return id;
		}

	}




}