package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiMediaSoupV3WebRtcClient extends UiComponent implements UiObject {


	protected Float displayAreaAspectRatio = 4/3f;
	protected boolean activityLineVisible;
	protected String activityInactiveColor;
	protected String activityActiveColor;
	protected List<String> icons;
	protected String caption;
	protected String noVideoImageUrl;
	protected WebRtcClientSpinnerPolicy spinnerPolicy;
	protected double playbackVolume = 1;
	protected boolean contextMenuEnabled = false;
	protected boolean bitrateDisplayEnabled = false;
	protected UiMediaSoupPublishingParameters publishingParameters;
	protected UiMediaSoupPlaybackParameters playbackParameters;

	public UiMediaSoupV3WebRtcClient() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("displayAreaAspectRatio=" + displayAreaAspectRatio).append(", ")
				.append("activityLineVisible=" + activityLineVisible).append(", ")
				.append("activityInactiveColor=" + activityInactiveColor).append(", ")
				.append("activityActiveColor=" + activityActiveColor).append(", ")
				.append("icons=" + icons).append(", ")
				.append("caption=" + caption).append(", ")
				.append("noVideoImageUrl=" + noVideoImageUrl).append(", ")
				.append("spinnerPolicy=" + spinnerPolicy).append(", ")
				.append("playbackVolume=" + playbackVolume).append(", ")
				.append("contextMenuEnabled=" + contextMenuEnabled).append(", ")
				.append("bitrateDisplayEnabled=" + bitrateDisplayEnabled).append(", ")
				.append(publishingParameters != null ? "publishingParameters={" + publishingParameters.toString() + "}" : "").append(", ")
				.append(playbackParameters != null ? "playbackParameters={" + playbackParameters.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("displayAreaAspectRatio")
	public Float getDisplayAreaAspectRatio() {
		return displayAreaAspectRatio;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("activityLineVisible")
	public boolean getActivityLineVisible() {
		return activityLineVisible;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("activityInactiveColor")
	public String getActivityInactiveColor() {
		return activityInactiveColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("activityActiveColor")
	public String getActivityActiveColor() {
		return activityActiveColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("icons")
	public List<String> getIcons() {
		return icons;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("caption")
	public String getCaption() {
		return caption;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("noVideoImageUrl")
	public String getNoVideoImageUrl() {
		return noVideoImageUrl;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("spinnerPolicy")
	public WebRtcClientSpinnerPolicy getSpinnerPolicy() {
		return spinnerPolicy;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("playbackVolume")
	public double getPlaybackVolume() {
		return playbackVolume;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("contextMenuEnabled")
	public boolean getContextMenuEnabled() {
		return contextMenuEnabled;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("bitrateDisplayEnabled")
	public boolean getBitrateDisplayEnabled() {
		return bitrateDisplayEnabled;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("publishingParameters")
	public UiMediaSoupPublishingParameters getPublishingParameters() {
		return publishingParameters;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("playbackParameters")
	public UiMediaSoupPlaybackParameters getPlaybackParameters() {
		return playbackParameters;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiMediaSoupV3WebRtcClient setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiMediaSoupV3WebRtcClient setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiMediaSoupV3WebRtcClient setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiMediaSoupV3WebRtcClient setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiMediaSoupV3WebRtcClient setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("displayAreaAspectRatio")
	public UiMediaSoupV3WebRtcClient setDisplayAreaAspectRatio(Float displayAreaAspectRatio) {
		this.displayAreaAspectRatio = displayAreaAspectRatio;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("activityLineVisible")
	public UiMediaSoupV3WebRtcClient setActivityLineVisible(boolean activityLineVisible) {
		this.activityLineVisible = activityLineVisible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("activityInactiveColor")
	public UiMediaSoupV3WebRtcClient setActivityInactiveColor(String activityInactiveColor) {
		this.activityInactiveColor = activityInactiveColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("activityActiveColor")
	public UiMediaSoupV3WebRtcClient setActivityActiveColor(String activityActiveColor) {
		this.activityActiveColor = activityActiveColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("icons")
	public UiMediaSoupV3WebRtcClient setIcons(List<String> icons) {
		this.icons = icons;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("caption")
	public UiMediaSoupV3WebRtcClient setCaption(String caption) {
		this.caption = caption;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("noVideoImageUrl")
	public UiMediaSoupV3WebRtcClient setNoVideoImageUrl(String noVideoImageUrl) {
		this.noVideoImageUrl = noVideoImageUrl;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("spinnerPolicy")
	public UiMediaSoupV3WebRtcClient setSpinnerPolicy(WebRtcClientSpinnerPolicy spinnerPolicy) {
		this.spinnerPolicy = spinnerPolicy;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("playbackVolume")
	public UiMediaSoupV3WebRtcClient setPlaybackVolume(double playbackVolume) {
		this.playbackVolume = playbackVolume;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("contextMenuEnabled")
	public UiMediaSoupV3WebRtcClient setContextMenuEnabled(boolean contextMenuEnabled) {
		this.contextMenuEnabled = contextMenuEnabled;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("bitrateDisplayEnabled")
	public UiMediaSoupV3WebRtcClient setBitrateDisplayEnabled(boolean bitrateDisplayEnabled) {
		this.bitrateDisplayEnabled = bitrateDisplayEnabled;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("publishingParameters")
	public UiMediaSoupV3WebRtcClient setPublishingParameters(UiMediaSoupPublishingParameters publishingParameters) {
		this.publishingParameters = publishingParameters;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("playbackParameters")
	public UiMediaSoupV3WebRtcClient setPlaybackParameters(UiMediaSoupPlaybackParameters playbackParameters) {
		this.playbackParameters = playbackParameters;
		return this;
	}

	public static class SourceMediaTrackRetrievalFailedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiMediaRetrievalFailureReason reason;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SourceMediaTrackRetrievalFailedEvent() {
			// default constructor for Jackson
		}

		public SourceMediaTrackRetrievalFailedEvent(String componentId, UiMediaRetrievalFailureReason reason) {
			this.componentId = componentId;
			this.reason = reason;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_SOURCE_MEDIA_TRACK_RETRIEVAL_FAILED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("reason=" + reason)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("reason")
		public UiMediaRetrievalFailureReason getReason() {
			return reason;
		}

	}

	public static class SourceMediaTrackEndedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiSourceMediaTrackType trackType;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SourceMediaTrackEndedEvent() {
			// default constructor for Jackson
		}

		public SourceMediaTrackEndedEvent(String componentId, UiSourceMediaTrackType trackType) {
			this.componentId = componentId;
			this.trackType = trackType;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_SOURCE_MEDIA_TRACK_ENDED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("trackType=" + trackType)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("trackType")
		public UiSourceMediaTrackType getTrackType() {
			return trackType;
		}

	}

	public static class TrackPublishingSuccessfulEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected boolean audio;
		protected boolean video;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public TrackPublishingSuccessfulEvent() {
			// default constructor for Jackson
		}

		public TrackPublishingSuccessfulEvent(String componentId, boolean audio, boolean video) {
			this.componentId = componentId;
			this.audio = audio;
			this.video = video;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_TRACK_PUBLISHING_SUCCESSFUL;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("audio=" + audio).append(", ")
					.append("video=" + video)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("audio")
		public boolean getAudio() {
			return audio;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("video")
		public boolean getVideo() {
			return video;
		}

	}

	public static class TrackPublishingFailedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected boolean audio;
		protected boolean video;
		protected String errorMessage;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public TrackPublishingFailedEvent() {
			// default constructor for Jackson
		}

		public TrackPublishingFailedEvent(String componentId, boolean audio, boolean video, String errorMessage) {
			this.componentId = componentId;
			this.audio = audio;
			this.video = video;
			this.errorMessage = errorMessage;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_TRACK_PUBLISHING_FAILED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("audio=" + audio).append(", ")
					.append("video=" + video).append(", ")
					.append("errorMessage=" + errorMessage)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("audio")
		public boolean getAudio() {
			return audio;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("video")
		public boolean getVideo() {
			return video;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("errorMessage")
		public String getErrorMessage() {
			return errorMessage;
		}

	}

	public static class ConnectionStateChangedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected boolean connected;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ConnectionStateChangedEvent() {
			// default constructor for Jackson
		}

		public ConnectionStateChangedEvent(String componentId, boolean connected) {
			this.componentId = componentId;
			this.connected = connected;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_CONNECTION_STATE_CHANGED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("connected=" + connected)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("connected")
		public boolean getConnected() {
			return connected;
		}

	}

	public static class SubscribingSuccessfulEvent implements UiEvent {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SubscribingSuccessfulEvent() {
			// default constructor for Jackson
		}

		public SubscribingSuccessfulEvent(String componentId) {
			this.componentId = componentId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_SUBSCRIBING_SUCCESSFUL;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class SubscribingFailedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String errorMessage;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SubscribingFailedEvent() {
			// default constructor for Jackson
		}

		public SubscribingFailedEvent(String componentId, String errorMessage) {
			this.componentId = componentId;
			this.errorMessage = errorMessage;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_SUBSCRIBING_FAILED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("errorMessage=" + errorMessage)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("errorMessage")
		public String getErrorMessage() {
			return errorMessage;
		}

	}

	public static class SubscriptionPlaybackFailedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String errorMessage;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SubscriptionPlaybackFailedEvent() {
			// default constructor for Jackson
		}

		public SubscriptionPlaybackFailedEvent(String componentId, String errorMessage) {
			this.componentId = componentId;
			this.errorMessage = errorMessage;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_SUBSCRIPTION_PLAYBACK_FAILED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("errorMessage=" + errorMessage)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("errorMessage")
		public String getErrorMessage() {
			return errorMessage;
		}

	}

	public static class VoiceActivityChangedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected boolean active;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public VoiceActivityChangedEvent() {
			// default constructor for Jackson
		}

		public VoiceActivityChangedEvent(String componentId, boolean active) {
			this.componentId = componentId;
			this.active = active;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_VOICE_ACTIVITY_CHANGED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("active=" + active)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("active")
		public boolean getActive() {
			return active;
		}

	}

	public static class ClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ClickedEvent() {
			// default constructor for Jackson
		}

		public ClickedEvent(String componentId) {
			this.componentId = componentId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class ContextMenuRequestedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected int requestId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ContextMenuRequestedEvent() {
			// default constructor for Jackson
		}

		public ContextMenuRequestedEvent(String componentId, int requestId) {
			this.componentId = componentId;
			this.requestId = requestId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V3_WEB_RTC_CLIENT_CONTEXT_MENU_REQUESTED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("requestId=" + requestId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("requestId")
		public int getRequestId() {
			return requestId;
		}

	}

	public static class UpdateCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiMediaSoupV3WebRtcClient config;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UpdateCommand() {
			// default constructor for Jackson
		}

		public UpdateCommand(String componentId, UiMediaSoupV3WebRtcClient config) {
			this.componentId = componentId;
			this.config = config;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(config != null ? "config={" + config.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("config")
		public UiMediaSoupV3WebRtcClient getConfig() {
			return config;
		}

	}

	public static class SetActiveCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean active;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetActiveCommand() {
			// default constructor for Jackson
		}

		public SetActiveCommand(String componentId, boolean active) {
			this.componentId = componentId;
			this.active = active;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("active=" + active)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("active")
		public boolean getActive() {
			return active;
		}

	}

	public static class SetContextMenuContentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int requestId;
		protected UiClientObjectReference component;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetContextMenuContentCommand() {
			// default constructor for Jackson
		}

		public SetContextMenuContentCommand(String componentId, int requestId, UiClientObjectReference component) {
			this.componentId = componentId;
			this.requestId = requestId;
			this.component = component;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("requestId=" + requestId).append(", ")
					.append(component != null ? "component={" + component.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("requestId")
		public int getRequestId() {
			return requestId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("component")
		public UiClientObjectReference getComponent() {
			return component;
		}

	}

	public static class CloseContextMenuCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int requestId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public CloseContextMenuCommand() {
			// default constructor for Jackson
		}

		public CloseContextMenuCommand(String componentId, int requestId) {
			this.componentId = componentId;
			this.requestId = requestId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("requestId=" + requestId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("requestId")
		public int getRequestId() {
			return requestId;
		}

	}

	public static class EnumerateDevicesCommand implements UiCommand<List<UiMediaDeviceInfo>> {


		public EnumerateDevicesCommand() {
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.toString();
		}


		public String getComponentId() {
			return null;
		}

	}




}