package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiMediaTrackGraph extends UiComponent implements UiObject {


	protected int trackCount;
	protected List<UiMediaTrackData> trackData;
	protected List<UiMediaTrackMarker> markers;

	public UiMediaTrackGraph() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_MEDIA_TRACK_GRAPH;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("trackCount=" + trackCount).append(", ")
				.append(trackData != null ? "trackData={" + trackData.toString() + "}" : "").append(", ")
				.append(markers != null ? "markers={" + markers.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("trackCount")
	public int getTrackCount() {
		return trackCount;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("trackData")
	public List<UiMediaTrackData> getTrackData() {
		return trackData;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("markers")
	public List<UiMediaTrackMarker> getMarkers() {
		return markers;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiMediaTrackGraph setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiMediaTrackGraph setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiMediaTrackGraph setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiMediaTrackGraph setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiMediaTrackGraph setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("trackCount")
	public UiMediaTrackGraph setTrackCount(int trackCount) {
		this.trackCount = trackCount;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("trackData")
	public UiMediaTrackGraph setTrackData(List<UiMediaTrackData> trackData) {
		this.trackData = trackData;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("markers")
	public UiMediaTrackGraph setMarkers(List<UiMediaTrackMarker> markers) {
		this.markers = markers;
		return this;
	}

	public static class HandleTimeSelectionEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected long start;
		protected long end;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public HandleTimeSelectionEvent() {
			// default constructor for Jackson
		}

		public HandleTimeSelectionEvent(String componentId, long start, long end) {
			this.componentId = componentId;
			this.start = start;
			this.end = end;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_TRACK_GRAPH_HANDLE_TIME_SELECTION;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("start=" + start).append(", ")
					.append("end=" + end)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("start")
		public long getStart() {
			return start;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("end")
		public long getEnd() {
			return end;
		}

	}

	public static class SetCursorPositionCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected long time;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetCursorPositionCommand() {
			// default constructor for Jackson
		}

		public SetCursorPositionCommand(String componentId, long time) {
			this.componentId = componentId;
			this.time = time;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("time=" + time)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("time")
		public long getTime() {
			return time;
		}

	}




}