package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiMultiProgressDisplay extends UiComponent implements UiObject {


	protected int runningCount;
	protected List<String> statusMessages;

	public UiMultiProgressDisplay() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_MULTI_PROGRESS_DISPLAY;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("runningCount=" + runningCount).append(", ")
				.append("statusMessages=" + statusMessages)
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("runningCount")
	public int getRunningCount() {
		return runningCount;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("statusMessages")
	public List<String> getStatusMessages() {
		return statusMessages;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiMultiProgressDisplay setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiMultiProgressDisplay setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiMultiProgressDisplay setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiMultiProgressDisplay setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiMultiProgressDisplay setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("runningCount")
	public UiMultiProgressDisplay setRunningCount(int runningCount) {
		this.runningCount = runningCount;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("statusMessages")
	public UiMultiProgressDisplay setStatusMessages(List<String> statusMessages) {
		this.statusMessages = statusMessages;
		return this;
	}

	public static class ClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ClickedEvent() {
			// default constructor for Jackson
		}

		public ClickedEvent(String componentId) {
			this.componentId = componentId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MULTI_PROGRESS_DISPLAY_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class UpdateCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiDefaultMultiProgressDisplay config;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UpdateCommand() {
			// default constructor for Jackson
		}

		public UpdateCommand(String componentId, UiDefaultMultiProgressDisplay config) {
			this.componentId = componentId;
			this.config = config;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(config != null ? "config={" + config.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("config")
		public UiDefaultMultiProgressDisplay getConfig() {
			return config;
		}

	}




}