package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiProgressDisplay extends UiComponent implements UiObject {


	protected String icon;
	protected String taskName;
	protected String statusMessage;
	protected double progress;
	protected UiProgressStatus status;
	protected boolean cancelable;

	public UiProgressDisplay() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_PROGRESS_DISPLAY;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("taskName=" + taskName).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("icon=" + icon).append(", ")
				.append("statusMessage=" + statusMessage).append(", ")
				.append("progress=" + progress).append(", ")
				.append("status=" + status).append(", ")
				.append("cancelable=" + cancelable)
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("icon")
	public String getIcon() {
		return icon;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("taskName")
	public String getTaskName() {
		return taskName;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("statusMessage")
	public String getStatusMessage() {
		return statusMessage;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("progress")
	public double getProgress() {
		return progress;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("status")
	public UiProgressStatus getStatus() {
		return status;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("cancelable")
	public boolean getCancelable() {
		return cancelable;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiProgressDisplay setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiProgressDisplay setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiProgressDisplay setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiProgressDisplay setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiProgressDisplay setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("icon")
	public UiProgressDisplay setIcon(String icon) {
		this.icon = icon;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("taskName")
	public UiProgressDisplay setTaskName(String taskName) {
		this.taskName = taskName;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("statusMessage")
	public UiProgressDisplay setStatusMessage(String statusMessage) {
		this.statusMessage = statusMessage;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("progress")
	public UiProgressDisplay setProgress(double progress) {
		this.progress = progress;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("status")
	public UiProgressDisplay setStatus(UiProgressStatus status) {
		this.status = status;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("cancelable")
	public UiProgressDisplay setCancelable(boolean cancelable) {
		this.cancelable = cancelable;
		return this;
	}

	public static class ClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ClickedEvent() {
			// default constructor for Jackson
		}

		public ClickedEvent(String componentId) {
			this.componentId = componentId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_PROGRESS_DISPLAY_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class CancelButtonClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public CancelButtonClickedEvent() {
			// default constructor for Jackson
		}

		public CancelButtonClickedEvent(String componentId) {
			this.componentId = componentId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_PROGRESS_DISPLAY_CANCEL_BUTTON_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class UpdateCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiProgressDisplay config;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UpdateCommand() {
			// default constructor for Jackson
		}

		public UpdateCommand(String componentId, UiProgressDisplay config) {
			this.componentId = componentId;
			this.config = config;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(config != null ? "config={" + config.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("config")
		public UiProgressDisplay getConfig() {
			return config;
		}

	}




}