package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiReactView extends UiComponent implements UiObject {


	protected String jsx;
	protected Map<String, UiClientObjectReference> componentByRefName;
	protected Map<String, String> propValueByPropName;

	public UiReactView() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_REACT_VIEW;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append(componentByRefName != null ? "componentByRefName={" + componentByRefName.toString() + "}" : "").append(", ")
				.append("propValueByPropName=" + propValueByPropName).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("jsx=" + jsx)
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("jsx")
	public String getJsx() {
		return jsx;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("componentByRefName")
	public Map<String, UiClientObjectReference> getComponentByRefName() {
		return componentByRefName;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("propValueByPropName")
	public Map<String, String> getPropValueByPropName() {
		return propValueByPropName;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiReactView setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiReactView setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiReactView setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiReactView setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiReactView setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("jsx")
	public UiReactView setJsx(String jsx) {
		this.jsx = jsx;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("componentByRefName")
	public UiReactView setComponentByRefName(Map<String, UiClientObjectReference> componentByRefName) {
		this.componentByRefName = componentByRefName;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("propValueByPropName")
	public UiReactView setPropValueByPropName(Map<String, String> propValueByPropName) {
		this.propValueByPropName = propValueByPropName;
		return this;
	}


	public static class AddComponentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String containerRefName;
		protected UiClientObjectReference component;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddComponentCommand() {
			// default constructor for Jackson
		}

		public AddComponentCommand(String componentId, String containerRefName, UiClientObjectReference component) {
			this.componentId = componentId;
			this.containerRefName = containerRefName;
			this.component = component;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("containerRefName=" + containerRefName).append(", ")
					.append(component != null ? "component={" + component.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("containerRefName")
		public String getContainerRefName() {
			return containerRefName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("component")
		public UiClientObjectReference getComponent() {
			return component;
		}

	}

	public static class RemoveComponentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiClientObjectReference component;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveComponentCommand() {
			// default constructor for Jackson
		}

		public RemoveComponentCommand(String componentId, UiClientObjectReference component) {
			this.componentId = componentId;
			this.component = component;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(component != null ? "component={" + component.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("component")
		public UiClientObjectReference getComponent() {
			return component;
		}

	}

	public static class SetPropCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String propName;
		protected String value;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetPropCommand() {
			// default constructor for Jackson
		}

		public SetPropCommand(String componentId, String propName, String value) {
			this.componentId = componentId;
			this.propName = propName;
			this.value = value;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("propName=" + propName).append(", ")
					.append("value=" + value)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("propName")
		public String getPropName() {
			return propName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("value")
		public String getValue() {
			return value;
		}

	}




}