package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiTemplateTestContainer extends UiComponent implements UiObject {


	protected UiGridTemplate template;

	@JsonSerialize(using = ObjectSerializer.class)
	@JsonDeserialize(using = ObjectDeserializer.class)
	protected Object data;
	protected int minContainerWidth = 0;
	protected int minContainerHeight = 0;
	protected int maxContainerWidth = 0;
	protected int maxContainerHeight = 0;
	protected String description;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiTemplateTestContainer() {
		// default constructor for Jackson
	}

	public UiTemplateTestContainer(UiGridTemplate template, Object data) {
		super();
		this.template = template;
		this.data = data;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_TEMPLATE_TEST_CONTAINER;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("data=" + data).append(", ")
				.append("minContainerWidth=" + minContainerWidth).append(", ")
				.append("minContainerHeight=" + minContainerHeight).append(", ")
				.append("maxContainerWidth=" + maxContainerWidth).append(", ")
				.append("maxContainerHeight=" + maxContainerHeight).append(", ")
				.append("description=" + description).append(", ")
				.append(template != null ? "template={" + template.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("template")
	public UiGridTemplate getTemplate() {
		return template;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("data")
	public Object getData() {
		return data;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("minContainerWidth")
	public int getMinContainerWidth() {
		return minContainerWidth;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("minContainerHeight")
	public int getMinContainerHeight() {
		return minContainerHeight;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("maxContainerWidth")
	public int getMaxContainerWidth() {
		return maxContainerWidth;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("maxContainerHeight")
	public int getMaxContainerHeight() {
		return maxContainerHeight;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("description")
	public String getDescription() {
		return description;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiTemplateTestContainer setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiTemplateTestContainer setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiTemplateTestContainer setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiTemplateTestContainer setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiTemplateTestContainer setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("minContainerWidth")
	public UiTemplateTestContainer setMinContainerWidth(int minContainerWidth) {
		this.minContainerWidth = minContainerWidth;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("minContainerHeight")
	public UiTemplateTestContainer setMinContainerHeight(int minContainerHeight) {
		this.minContainerHeight = minContainerHeight;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("maxContainerWidth")
	public UiTemplateTestContainer setMaxContainerWidth(int maxContainerWidth) {
		this.maxContainerWidth = maxContainerWidth;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("maxContainerHeight")
	public UiTemplateTestContainer setMaxContainerHeight(int maxContainerHeight) {
		this.maxContainerHeight = maxContainerHeight;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("description")
	public UiTemplateTestContainer setDescription(String description) {
		this.description = description;
		return this;
	}






}