package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiVideoPlayer extends UiComponent implements UiObject {

	public enum PosterImageSize {
		CONTAIN, COVER, ORIGINAL;

		@com.fasterxml.jackson.annotation.JsonValue
		public int jsonValue() {
			return ordinal();
		}
	}

	protected String url;
	protected boolean autoplay;
	protected boolean showControls;
	protected String posterImageUrl;
	protected PosterImageSize posterImageSize = PosterImageSize.CONTAIN;
	protected int sendPlayerProgressEventsEachXSeconds = 1;
	protected String backgroundColor = "rgb(68, 68, 68)";
	protected UiMediaPreloadMode preloadMode;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiVideoPlayer() {
		// default constructor for Jackson
	}

	public UiVideoPlayer(String url) {
		super();
		this.url = url;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_VIDEO_PLAYER;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("url=" + url).append(", ")
				.append("autoplay=" + autoplay).append(", ")
				.append("showControls=" + showControls).append(", ")
				.append("posterImageUrl=" + posterImageUrl).append(", ")
				.append("posterImageSize=" + posterImageSize).append(", ")
				.append("sendPlayerProgressEventsEachXSeconds=" + sendPlayerProgressEventsEachXSeconds).append(", ")
				.append("backgroundColor=" + backgroundColor).append(", ")
				.append("preloadMode=" + preloadMode)
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("url")
	public String getUrl() {
		return url;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("autoplay")
	public boolean getAutoplay() {
		return autoplay;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("showControls")
	public boolean getShowControls() {
		return showControls;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("posterImageUrl")
	public String getPosterImageUrl() {
		return posterImageUrl;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("posterImageSize")
	public PosterImageSize getPosterImageSize() {
		return posterImageSize;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("sendPlayerProgressEventsEachXSeconds")
	public int getSendPlayerProgressEventsEachXSeconds() {
		return sendPlayerProgressEventsEachXSeconds;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
	public String getBackgroundColor() {
		return backgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("preloadMode")
	public UiMediaPreloadMode getPreloadMode() {
		return preloadMode;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiVideoPlayer setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiVideoPlayer setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiVideoPlayer setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiVideoPlayer setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiVideoPlayer setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("autoplay")
	public UiVideoPlayer setAutoplay(boolean autoplay) {
		this.autoplay = autoplay;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("showControls")
	public UiVideoPlayer setShowControls(boolean showControls) {
		this.showControls = showControls;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("posterImageUrl")
	public UiVideoPlayer setPosterImageUrl(String posterImageUrl) {
		this.posterImageUrl = posterImageUrl;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("posterImageSize")
	public UiVideoPlayer setPosterImageSize(PosterImageSize posterImageSize) {
		this.posterImageSize = posterImageSize;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("sendPlayerProgressEventsEachXSeconds")
	public UiVideoPlayer setSendPlayerProgressEventsEachXSeconds(int sendPlayerProgressEventsEachXSeconds) {
		this.sendPlayerProgressEventsEachXSeconds = sendPlayerProgressEventsEachXSeconds;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundColor")
	public UiVideoPlayer setBackgroundColor(String backgroundColor) {
		this.backgroundColor = backgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("preloadMode")
	public UiVideoPlayer setPreloadMode(UiMediaPreloadMode preloadMode) {
		this.preloadMode = preloadMode;
		return this;
	}

	public static class ErrorLoadingEvent implements UiEvent {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ErrorLoadingEvent() {
			// default constructor for Jackson
		}

		public ErrorLoadingEvent(String componentId) {
			this.componentId = componentId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_VIDEO_PLAYER_ERROR_LOADING;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class PlayerProgressEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected int positionInSeconds;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public PlayerProgressEvent() {
			// default constructor for Jackson
		}

		public PlayerProgressEvent(String componentId, int positionInSeconds) {
			this.componentId = componentId;
			this.positionInSeconds = positionInSeconds;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_VIDEO_PLAYER_PLAYER_PROGRESS;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("positionInSeconds=" + positionInSeconds)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("positionInSeconds")
		public int getPositionInSeconds() {
			return positionInSeconds;
		}

	}

	public static class EndedEvent implements UiEvent {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public EndedEvent() {
			// default constructor for Jackson
		}

		public EndedEvent(String componentId) {
			this.componentId = componentId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_VIDEO_PLAYER_ENDED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class SetUrlCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String url;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetUrlCommand() {
			// default constructor for Jackson
		}

		public SetUrlCommand(String componentId, String url) {
			this.componentId = componentId;
			this.url = url;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("url=" + url)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("url")
		public String getUrl() {
			return url;
		}

	}

	public static class SetPreloadModeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiMediaPreloadMode preloadMode;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetPreloadModeCommand() {
			// default constructor for Jackson
		}

		public SetPreloadModeCommand(String componentId, UiMediaPreloadMode preloadMode) {
			this.componentId = componentId;
			this.preloadMode = preloadMode;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("preloadMode=" + preloadMode)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("preloadMode")
		public UiMediaPreloadMode getPreloadMode() {
			return preloadMode;
		}

	}

	public static class SetAutoplayCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean autoplay;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetAutoplayCommand() {
			// default constructor for Jackson
		}

		public SetAutoplayCommand(String componentId, boolean autoplay) {
			this.componentId = componentId;
			this.autoplay = autoplay;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("autoplay=" + autoplay)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("autoplay")
		public boolean getAutoplay() {
			return autoplay;
		}

	}

	public static class PlayCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public PlayCommand() {
			// default constructor for Jackson
		}

		public PlayCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class PauseCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public PauseCommand() {
			// default constructor for Jackson
		}

		public PauseCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class JumpToCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int timeInSeconds;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public JumpToCommand() {
			// default constructor for Jackson
		}

		public JumpToCommand(String componentId, int timeInSeconds) {
			this.componentId = componentId;
			this.timeInSeconds = timeInSeconds;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("timeInSeconds=" + timeInSeconds)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("timeInSeconds")
		public int getTimeInSeconds() {
			return timeInSeconds;
		}

	}




}