/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiAccordionPanel;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiAccordionLayout
extends UiComponent
implements UiObject {
    protected List<UiAccordionPanel> panels;
    protected boolean animate;
    protected boolean showAllPanels;

    @Deprecated
    public UiAccordionLayout() {
    }

    public UiAccordionLayout(List<UiAccordionPanel> panels) {
        this.panels = panels;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_ACCORDION_LAYOUT;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("animate=" + this.animate) + ", " + ("showAllPanels=" + this.showAllPanels) + ", " + (String)(this.panels != null ? "panels={" + this.panels.toString() + "}" : "");
    }

    @JsonGetter(value="panels")
    public List<UiAccordionPanel> getPanels() {
        return this.panels;
    }

    @JsonGetter(value="animate")
    public boolean getAnimate() {
        return this.animate;
    }

    @JsonGetter(value="showAllPanels")
    public boolean getShowAllPanels() {
        return this.showAllPanels;
    }

    @Override
    @JsonSetter(value="id")
    public UiAccordionLayout setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiAccordionLayout setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiAccordionLayout setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiAccordionLayout setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiAccordionLayout setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @JsonSetter(value="animate")
    public UiAccordionLayout setAnimate(boolean animate) {
        this.animate = animate;
        return this;
    }

    @JsonSetter(value="showAllPanels")
    public UiAccordionLayout setShowAllPanels(boolean showAllPanels) {
        this.showAllPanels = showAllPanels;
        return this;
    }

    public static class SetPanelOpenCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String panelId;
        protected boolean open;

        @Deprecated
        public SetPanelOpenCommand() {
        }

        public SetPanelOpenCommand(String componentId, String panelId, boolean open) {
            this.componentId = componentId;
            this.panelId = panelId;
            this.open = open;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("panelId=" + this.panelId) + ", " + ("open=" + this.open);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="panelId")
        public String getPanelId() {
            return this.panelId;
        }

        @JsonGetter(value="open")
        public boolean getOpen() {
            return this.open;
        }
    }

    public static class SelectPanelCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String panelId;

        @Deprecated
        public SelectPanelCommand() {
        }

        public SelectPanelCommand(String componentId, String panelId) {
            this.componentId = componentId;
            this.panelId = panelId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("panelId=" + this.panelId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="panelId")
        public String getPanelId() {
            return this.panelId;
        }
    }

    public static class RemoveAllPanelsCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public RemoveAllPanelsCommand() {
        }

        public RemoveAllPanelsCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class RemoveAccordionPanelCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String panelId;

        @Deprecated
        public RemoveAccordionPanelCommand() {
        }

        public RemoveAccordionPanelCommand(String componentId, String panelId) {
            this.componentId = componentId;
            this.panelId = panelId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("panelId=" + this.panelId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="panelId")
        public String getPanelId() {
            return this.panelId;
        }
    }

    public static class AddAccordionPanelContentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String panelId;
        protected UiClientObjectReference content;

        @Deprecated
        public AddAccordionPanelContentCommand() {
        }

        public AddAccordionPanelContentCommand(String componentId, String panelId, UiClientObjectReference content) {
            this.componentId = componentId;
            this.panelId = panelId;
            this.content = content;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("panelId=" + this.panelId) + ", " + (String)(this.content != null ? "content={" + this.content.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="panelId")
        public String getPanelId() {
            return this.panelId;
        }

        @JsonGetter(value="content")
        public UiClientObjectReference getContent() {
            return this.content;
        }
    }

    public static class AddAccordionPanelCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiAccordionPanel panel;
        protected String neighborPanelId;
        protected boolean beforeNeighbor;

        @Deprecated
        public AddAccordionPanelCommand() {
        }

        public AddAccordionPanelCommand(String componentId, UiAccordionPanel panel, String neighborPanelId, boolean beforeNeighbor) {
            this.componentId = componentId;
            this.panel = panel;
            this.neighborPanelId = neighborPanelId;
            this.beforeNeighbor = beforeNeighbor;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("neighborPanelId=" + this.neighborPanelId) + ", " + ("beforeNeighbor=" + this.beforeNeighbor) + ", " + (String)(this.panel != null ? "panel={" + this.panel.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="panel")
        public UiAccordionPanel getPanel() {
            return this.panel;
        }

        @JsonGetter(value="neighborPanelId")
        public String getNeighborPanelId() {
            return this.neighborPanelId;
        }

        @JsonGetter(value="beforeNeighbor")
        public boolean getBeforeNeighbor() {
            return this.beforeNeighbor;
        }
    }
}

