/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.ObjectDeserializer;
import org.teamapps.dto.ObjectSerializer;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiFieldEditingMode;
import org.teamapps.dto.UiFieldMessage;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiTemplate;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiButton
extends UiField
implements UiObject {
    protected UiTemplate template;
    @JsonSerialize(using=ObjectSerializer.class)
    @JsonDeserialize(using=ObjectDeserializer.class)
    protected Object templateRecord;
    protected int minDropDownWidth = 450;
    protected int minDropDownHeight = 200;
    protected boolean openDropDownIfNotSet = false;
    protected UiClientObjectReference dropDownComponent;
    protected String onClickJavaScript;

    @Deprecated
    public UiButton() {
    }

    public UiButton(UiTemplate template, Object templateRecord) {
        this.template = template;
        this.templateRecord = templateRecord;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_BUTTON;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("editingMode=" + this.editingMode) + ", " + ("value=" + this.value) + ", " + (String)(this.template != null ? "template={" + this.template.toString() + "}" : "") + ", " + ("templateRecord=" + this.templateRecord) + ", " + ("minDropDownWidth=" + this.minDropDownWidth) + ", " + ("minDropDownHeight=" + this.minDropDownHeight) + ", " + ("openDropDownIfNotSet=" + this.openDropDownIfNotSet) + ", " + ("onClickJavaScript=" + this.onClickJavaScript) + ", " + (String)(this.fieldMessages != null ? "fieldMessages={" + this.fieldMessages.toString() + "}" : "") + ", " + (String)(this.dropDownComponent != null ? "dropDownComponent={" + this.dropDownComponent.toString() + "}" : "");
    }

    @JsonGetter(value="template")
    public UiTemplate getTemplate() {
        return this.template;
    }

    @JsonGetter(value="templateRecord")
    public Object getTemplateRecord() {
        return this.templateRecord;
    }

    @JsonGetter(value="minDropDownWidth")
    public int getMinDropDownWidth() {
        return this.minDropDownWidth;
    }

    @JsonGetter(value="minDropDownHeight")
    public int getMinDropDownHeight() {
        return this.minDropDownHeight;
    }

    @JsonGetter(value="openDropDownIfNotSet")
    public boolean getOpenDropDownIfNotSet() {
        return this.openDropDownIfNotSet;
    }

    @JsonGetter(value="dropDownComponent")
    public UiClientObjectReference getDropDownComponent() {
        return this.dropDownComponent;
    }

    @JsonGetter(value="onClickJavaScript")
    public String getOnClickJavaScript() {
        return this.onClickJavaScript;
    }

    @Override
    @JsonSetter(value="id")
    public UiButton setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiButton setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiButton setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiButton setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiButton setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="editingMode")
    public UiButton setEditingMode(UiFieldEditingMode editingMode) {
        this.editingMode = editingMode;
        return this;
    }

    @Override
    @JsonSetter(value="value")
    public UiButton setValue(Object value) {
        this.value = value;
        return this;
    }

    @Override
    @JsonSetter(value="fieldMessages")
    public UiButton setFieldMessages(List<UiFieldMessage> fieldMessages) {
        this.fieldMessages = fieldMessages;
        return this;
    }

    @JsonSetter(value="minDropDownWidth")
    public UiButton setMinDropDownWidth(int minDropDownWidth) {
        this.minDropDownWidth = minDropDownWidth;
        return this;
    }

    @JsonSetter(value="minDropDownHeight")
    public UiButton setMinDropDownHeight(int minDropDownHeight) {
        this.minDropDownHeight = minDropDownHeight;
        return this;
    }

    @JsonSetter(value="openDropDownIfNotSet")
    public UiButton setOpenDropDownIfNotSet(boolean openDropDownIfNotSet) {
        this.openDropDownIfNotSet = openDropDownIfNotSet;
        return this;
    }

    @JsonSetter(value="dropDownComponent")
    public UiButton setDropDownComponent(UiClientObjectReference dropDownComponent) {
        this.dropDownComponent = dropDownComponent;
        return this;
    }

    @JsonSetter(value="onClickJavaScript")
    public UiButton setOnClickJavaScript(String onClickJavaScript) {
        this.onClickJavaScript = onClickJavaScript;
        return this;
    }

    public static class SetOnClickJavaScriptCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String onClickJavaScript;

        @Deprecated
        public SetOnClickJavaScriptCommand() {
        }

        public SetOnClickJavaScriptCommand(String componentId, String onClickJavaScript) {
            this.componentId = componentId;
            this.onClickJavaScript = onClickJavaScript;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("onClickJavaScript=" + this.onClickJavaScript);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="onClickJavaScript")
        public String getOnClickJavaScript() {
            return this.onClickJavaScript;
        }
    }

    public static class SetDropDownComponentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiClientObjectReference dropDownComponent;

        @Deprecated
        public SetDropDownComponentCommand() {
        }

        public SetDropDownComponentCommand(String componentId, UiClientObjectReference dropDownComponent) {
            this.componentId = componentId;
            this.dropDownComponent = dropDownComponent;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.dropDownComponent != null ? "dropDownComponent={" + this.dropDownComponent.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="dropDownComponent")
        public UiClientObjectReference getDropDownComponent() {
            return this.dropDownComponent;
        }
    }

    public static class SetOpenDropDownIfNotSetCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected boolean openDropDownIfNotSet;

        @Deprecated
        public SetOpenDropDownIfNotSetCommand() {
        }

        public SetOpenDropDownIfNotSetCommand(String componentId, boolean openDropDownIfNotSet) {
            this.componentId = componentId;
            this.openDropDownIfNotSet = openDropDownIfNotSet;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("openDropDownIfNotSet=" + this.openDropDownIfNotSet);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="openDropDownIfNotSet")
        public boolean getOpenDropDownIfNotSet() {
            return this.openDropDownIfNotSet;
        }
    }

    public static class SetDropDownSizeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int minDropDownWidth;
        protected int minDropDownHeight;

        @Deprecated
        public SetDropDownSizeCommand() {
        }

        public SetDropDownSizeCommand(String componentId, int minDropDownWidth, int minDropDownHeight) {
            this.componentId = componentId;
            this.minDropDownWidth = minDropDownWidth;
            this.minDropDownHeight = minDropDownHeight;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("minDropDownWidth=" + this.minDropDownWidth) + ", " + ("minDropDownHeight=" + this.minDropDownHeight);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="minDropDownWidth")
        public int getMinDropDownWidth() {
            return this.minDropDownWidth;
        }

        @JsonGetter(value="minDropDownHeight")
        public int getMinDropDownHeight() {
            return this.minDropDownHeight;
        }
    }

    public static class SetTemplateRecordCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        @JsonSerialize(using=ObjectSerializer.class)
        @JsonDeserialize(using=ObjectDeserializer.class)
        protected Object templateRecord;

        @Deprecated
        public SetTemplateRecordCommand() {
        }

        public SetTemplateRecordCommand(String componentId, Object templateRecord) {
            this.componentId = componentId;
            this.templateRecord = templateRecord;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("templateRecord=" + this.templateRecord);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="templateRecord")
        public Object getTemplateRecord() {
            return this.templateRecord;
        }
    }

    public static class SetTemplateCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiTemplate template;
        @JsonSerialize(using=ObjectSerializer.class)
        @JsonDeserialize(using=ObjectDeserializer.class)
        protected Object templateRecord;

        @Deprecated
        public SetTemplateCommand() {
        }

        public SetTemplateCommand(String componentId, UiTemplate template, Object templateRecord) {
            this.componentId = componentId;
            this.template = template;
            this.templateRecord = templateRecord;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.template != null ? "template={" + this.template.toString() + "}" : "") + ", " + ("templateRecord=" + this.templateRecord);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="template")
        public UiTemplate getTemplate() {
            return this.template;
        }

        @JsonGetter(value="templateRecord")
        public Object getTemplateRecord() {
            return this.templateRecord;
        }
    }

    public static class DropDownOpenedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public DropDownOpenedEvent() {
        }

        public DropDownOpenedEvent(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_BUTTON_DROP_DOWN_OPENED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class ClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public ClickedEvent() {
        }

        public ClickedEvent(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_BUTTON_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }
}

