/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiClientObject;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiComponent
extends UiClientObject
implements UiObject {
    protected String debuggingId;
    protected boolean visible = true;
    protected Map<String, Map<String, String>> stylesBySelector;
    protected Map<String, Map<String, Boolean>> classNamesBySelector;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_COMPONENT;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector);
    }

    @JsonGetter(value="debuggingId")
    public String getDebuggingId() {
        return this.debuggingId;
    }

    @JsonGetter(value="visible")
    public boolean getVisible() {
        return this.visible;
    }

    @JsonGetter(value="stylesBySelector")
    public Map<String, Map<String, String>> getStylesBySelector() {
        return this.stylesBySelector;
    }

    @JsonGetter(value="classNamesBySelector")
    public Map<String, Map<String, Boolean>> getClassNamesBySelector() {
        return this.classNamesBySelector;
    }

    @Override
    @JsonSetter(value="id")
    public UiComponent setId(String id) {
        this.id = id;
        return this;
    }

    @JsonSetter(value="debuggingId")
    public UiComponent setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @JsonSetter(value="visible")
    public UiComponent setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @JsonSetter(value="stylesBySelector")
    public UiComponent setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="classNamesBySelector")
    public UiComponent setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    public static class SetClassNamesCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String selector;
        protected Map<String, Boolean> classNames;

        @Deprecated
        public SetClassNamesCommand() {
        }

        public SetClassNamesCommand(String componentId, String selector, Map<String, Boolean> classNames) {
            this.componentId = componentId;
            this.selector = selector;
            this.classNames = classNames;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("classNames=" + this.classNames) + ", " + ("selector=" + this.selector);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="selector")
        public String getSelector() {
            return this.selector;
        }

        @JsonGetter(value="classNames")
        public Map<String, Boolean> getClassNames() {
            return this.classNames;
        }
    }

    public static class SetStyleCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String selector;
        protected Map<String, String> styles;

        @Deprecated
        public SetStyleCommand() {
        }

        public SetStyleCommand(String componentId, String selector, Map<String, String> styles) {
            this.componentId = componentId;
            this.selector = selector;
            this.styles = styles;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("selector=" + this.selector) + ", " + ("styles=" + this.styles);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="selector")
        public String getSelector() {
            return this.selector;
        }

        @JsonGetter(value="styles")
        public Map<String, String> getStyles() {
            return this.styles;
        }
    }

    public static class SetVisibleCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected boolean visible;

        @Deprecated
        public SetVisibleCommand() {
        }

        public SetVisibleCommand(String componentId, boolean visible) {
            this.componentId = componentId;
            this.visible = visible;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("visible=" + this.visible);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="visible")
        public boolean getVisible() {
            return this.visible;
        }
    }
}

