/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiWebRtcPublishingErrorReason;
import org.teamapps.dto.UiWebRtcPublishingSettings;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiWebRtcPublisher
extends UiComponent
implements UiObject {
    protected UiWebRtcPublishingSettings publishingSettings;
    protected boolean microphoneMuted = false;
    protected String backgroundImageUrl;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_WEB_RTC_PUBLISHER;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("microphoneMuted=" + this.microphoneMuted) + ", " + ("backgroundImageUrl=" + this.backgroundImageUrl) + ", " + (String)(this.publishingSettings != null ? "publishingSettings={" + this.publishingSettings.toString() + "}" : "");
    }

    @JsonGetter(value="publishingSettings")
    public UiWebRtcPublishingSettings getPublishingSettings() {
        return this.publishingSettings;
    }

    @JsonGetter(value="microphoneMuted")
    public boolean getMicrophoneMuted() {
        return this.microphoneMuted;
    }

    @JsonGetter(value="backgroundImageUrl")
    public String getBackgroundImageUrl() {
        return this.backgroundImageUrl;
    }

    @Override
    @JsonSetter(value="id")
    public UiWebRtcPublisher setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiWebRtcPublisher setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiWebRtcPublisher setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiWebRtcPublisher setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiWebRtcPublisher setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @JsonSetter(value="publishingSettings")
    public UiWebRtcPublisher setPublishingSettings(UiWebRtcPublishingSettings publishingSettings) {
        this.publishingSettings = publishingSettings;
        return this;
    }

    @JsonSetter(value="microphoneMuted")
    public UiWebRtcPublisher setMicrophoneMuted(boolean microphoneMuted) {
        this.microphoneMuted = microphoneMuted;
        return this;
    }

    @JsonSetter(value="backgroundImageUrl")
    public UiWebRtcPublisher setBackgroundImageUrl(String backgroundImageUrl) {
        this.backgroundImageUrl = backgroundImageUrl;
        return this;
    }

    public static class IsChromeExtensionInstalledCommand
    implements UiCommand<Boolean> {
        public String toString() {
            return this.getClass().getSimpleName() + ": ";
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class SetBackgroundImageUrlCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String backgroundImageUrl;

        @Deprecated
        public SetBackgroundImageUrlCommand() {
        }

        public SetBackgroundImageUrlCommand(String componentId, String backgroundImageUrl) {
            this.componentId = componentId;
            this.backgroundImageUrl = backgroundImageUrl;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("backgroundImageUrl=" + this.backgroundImageUrl);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="backgroundImageUrl")
        public String getBackgroundImageUrl() {
            return this.backgroundImageUrl;
        }
    }

    public static class SetMicrophoneMutedCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected boolean microphoneMuted;

        @Deprecated
        public SetMicrophoneMutedCommand() {
        }

        public SetMicrophoneMutedCommand(String componentId, boolean microphoneMuted) {
            this.componentId = componentId;
            this.microphoneMuted = microphoneMuted;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("microphoneMuted=" + this.microphoneMuted);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="microphoneMuted")
        public boolean getMicrophoneMuted() {
            return this.microphoneMuted;
        }
    }

    public static class UnPublishCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public UnPublishCommand() {
        }

        public UnPublishCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class PublishCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiWebRtcPublishingSettings settings;

        @Deprecated
        public PublishCommand() {
        }

        public PublishCommand(String componentId, UiWebRtcPublishingSettings settings) {
            this.componentId = componentId;
            this.settings = settings;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.settings != null ? "settings={" + this.settings.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="settings")
        public UiWebRtcPublishingSettings getSettings() {
            return this.settings;
        }
    }

    public static class PublishingFailedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected UiWebRtcPublishingErrorReason reason;

        @Deprecated
        public PublishingFailedEvent() {
        }

        public PublishingFailedEvent(String componentId, UiWebRtcPublishingErrorReason reason) {
            this.componentId = componentId;
            this.reason = reason;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_WEB_RTC_PUBLISHER_PUBLISHING_FAILED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("reason=" + this.reason);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="reason")
        public UiWebRtcPublishingErrorReason getReason() {
            return this.reason;
        }
    }
}

