/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiRelativeWorkSpaceViewPosition;
import org.teamapps.dto.UiSplitSizePolicy;
import org.teamapps.dto.UiViewGroupPanelState;
import org.teamapps.dto.UiWorkSpaceLayoutItem;
import org.teamapps.dto.UiWorkSpaceLayoutView;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiWorkSpaceLayout
extends UiComponent
implements UiObject {
    protected List<UiWorkSpaceLayoutView> views;
    protected UiWorkSpaceLayoutItem initialLayout;
    protected String childWindowPageTitle;
    protected UiClientObjectReference toolbar;
    protected String newWindowBackgroundImage;
    protected String newWindowBlurredBackgroundImage;
    protected UiClientObjectReference multiProgressDisplay;

    @Deprecated
    public UiWorkSpaceLayout() {
    }

    public UiWorkSpaceLayout(List<UiWorkSpaceLayoutView> views, UiWorkSpaceLayoutItem initialLayout, String childWindowPageTitle) {
        this.views = views;
        this.initialLayout = initialLayout;
        this.childWindowPageTitle = childWindowPageTitle;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_WORK_SPACE_LAYOUT;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("childWindowPageTitle=" + this.childWindowPageTitle) + ", " + ("newWindowBackgroundImage=" + this.newWindowBackgroundImage) + ", " + ("newWindowBlurredBackgroundImage=" + this.newWindowBlurredBackgroundImage) + ", " + (String)(this.views != null ? "views={" + this.views.toString() + "}" : "") + ", " + (String)(this.initialLayout != null ? "initialLayout={" + this.initialLayout.toString() + "}" : "") + ", " + (String)(this.toolbar != null ? "toolbar={" + this.toolbar.toString() + "}" : "") + ", " + (String)(this.multiProgressDisplay != null ? "multiProgressDisplay={" + this.multiProgressDisplay.toString() + "}" : "");
    }

    @JsonGetter(value="views")
    public List<UiWorkSpaceLayoutView> getViews() {
        return this.views;
    }

    @JsonGetter(value="initialLayout")
    public UiWorkSpaceLayoutItem getInitialLayout() {
        return this.initialLayout;
    }

    @JsonGetter(value="childWindowPageTitle")
    public String getChildWindowPageTitle() {
        return this.childWindowPageTitle;
    }

    @JsonGetter(value="toolbar")
    public UiClientObjectReference getToolbar() {
        return this.toolbar;
    }

    @JsonGetter(value="newWindowBackgroundImage")
    public String getNewWindowBackgroundImage() {
        return this.newWindowBackgroundImage;
    }

    @JsonGetter(value="newWindowBlurredBackgroundImage")
    public String getNewWindowBlurredBackgroundImage() {
        return this.newWindowBlurredBackgroundImage;
    }

    @JsonGetter(value="multiProgressDisplay")
    public UiClientObjectReference getMultiProgressDisplay() {
        return this.multiProgressDisplay;
    }

    @Override
    @JsonSetter(value="id")
    public UiWorkSpaceLayout setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiWorkSpaceLayout setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiWorkSpaceLayout setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiWorkSpaceLayout setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiWorkSpaceLayout setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @JsonSetter(value="toolbar")
    public UiWorkSpaceLayout setToolbar(UiClientObjectReference toolbar) {
        this.toolbar = toolbar;
        return this;
    }

    @JsonSetter(value="newWindowBackgroundImage")
    public UiWorkSpaceLayout setNewWindowBackgroundImage(String newWindowBackgroundImage) {
        this.newWindowBackgroundImage = newWindowBackgroundImage;
        return this;
    }

    @JsonSetter(value="newWindowBlurredBackgroundImage")
    public UiWorkSpaceLayout setNewWindowBlurredBackgroundImage(String newWindowBlurredBackgroundImage) {
        this.newWindowBlurredBackgroundImage = newWindowBlurredBackgroundImage;
        return this;
    }

    @JsonSetter(value="multiProgressDisplay")
    public UiWorkSpaceLayout setMultiProgressDisplay(UiClientObjectReference multiProgressDisplay) {
        this.multiProgressDisplay = multiProgressDisplay;
        return this;
    }

    public static class SetMultiProgressDisplayCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiClientObjectReference multiProgressDisplay;

        @Deprecated
        public SetMultiProgressDisplayCommand() {
        }

        public SetMultiProgressDisplayCommand(String componentId, UiClientObjectReference multiProgressDisplay) {
            this.componentId = componentId;
            this.multiProgressDisplay = multiProgressDisplay;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.multiProgressDisplay != null ? "multiProgressDisplay={" + this.multiProgressDisplay.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="multiProgressDisplay")
        public UiClientObjectReference getMultiProgressDisplay() {
            return this.multiProgressDisplay;
        }
    }

    public static class SetViewGroupPanelStateCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String viewGroupId;
        protected UiViewGroupPanelState panelState;

        @Deprecated
        public SetViewGroupPanelStateCommand() {
        }

        public SetViewGroupPanelStateCommand(String componentId, String viewGroupId, UiViewGroupPanelState panelState) {
            this.componentId = componentId;
            this.viewGroupId = viewGroupId;
            this.panelState = panelState;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("viewGroupId=" + this.viewGroupId) + ", " + ("panelState=" + this.panelState);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="viewGroupId")
        public String getViewGroupId() {
            return this.viewGroupId;
        }

        @JsonGetter(value="panelState")
        public UiViewGroupPanelState getPanelState() {
            return this.panelState;
        }
    }

    public static class SelectViewCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String viewName;

        @Deprecated
        public SelectViewCommand() {
        }

        public SelectViewCommand(String componentId, String viewName) {
            this.componentId = componentId;
            this.viewName = viewName;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("viewName=" + this.viewName);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="viewName")
        public String getViewName() {
            return this.viewName;
        }
    }

    public static class RefreshViewComponentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String viewName;
        protected UiClientObjectReference component;

        @Deprecated
        public RefreshViewComponentCommand() {
        }

        public RefreshViewComponentCommand(String componentId, String viewName, UiClientObjectReference component) {
            this.componentId = componentId;
            this.viewName = viewName;
            this.component = component;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("viewName=" + this.viewName) + ", " + (String)(this.component != null ? "component={" + this.component.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="viewName")
        public String getViewName() {
            return this.viewName;
        }

        @JsonGetter(value="component")
        public UiClientObjectReference getComponent() {
            return this.component;
        }
    }

    public static class RefreshViewAttributesCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String viewName;
        protected String tabIcon;
        protected String tabCaption;
        protected boolean tabCloseable;
        protected boolean visible;

        @Deprecated
        public RefreshViewAttributesCommand() {
        }

        public RefreshViewAttributesCommand(String componentId, String viewName, String tabIcon, String tabCaption, boolean tabCloseable, boolean visible) {
            this.componentId = componentId;
            this.viewName = viewName;
            this.tabIcon = tabIcon;
            this.tabCaption = tabCaption;
            this.tabCloseable = tabCloseable;
            this.visible = visible;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("viewName=" + this.viewName) + ", " + ("tabIcon=" + this.tabIcon) + ", " + ("tabCaption=" + this.tabCaption) + ", " + ("tabCloseable=" + this.tabCloseable) + ", " + ("visible=" + this.visible);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="viewName")
        public String getViewName() {
            return this.viewName;
        }

        @JsonGetter(value="tabIcon")
        public String getTabIcon() {
            return this.tabIcon;
        }

        @JsonGetter(value="tabCaption")
        public String getTabCaption() {
            return this.tabCaption;
        }

        @JsonGetter(value="tabCloseable")
        public boolean getTabCloseable() {
            return this.tabCloseable;
        }

        @JsonGetter(value="visible")
        public boolean getVisible() {
            return this.visible;
        }
    }

    public static class RemoveViewCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String viewName;

        @Deprecated
        public RemoveViewCommand() {
        }

        public RemoveViewCommand(String componentId, String viewName) {
            this.componentId = componentId;
            this.viewName = viewName;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("viewName=" + this.viewName);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="viewName")
        public String getViewName() {
            return this.viewName;
        }
    }

    public static class RedefineLayoutCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected Map<String, UiWorkSpaceLayoutItem> layoutsByWindowId;
        protected List<UiWorkSpaceLayoutView> addedViews;

        @Deprecated
        public RedefineLayoutCommand() {
        }

        public RedefineLayoutCommand(String componentId, Map<String, UiWorkSpaceLayoutItem> layoutsByWindowId, List<UiWorkSpaceLayoutView> addedViews) {
            this.componentId = componentId;
            this.layoutsByWindowId = layoutsByWindowId;
            this.addedViews = addedViews;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.layoutsByWindowId != null ? "layoutsByWindowId={" + this.layoutsByWindowId.toString() + "}" : "") + ", " + (String)(this.addedViews != null ? "addedViews={" + this.addedViews.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="layoutsByWindowId")
        public Map<String, UiWorkSpaceLayoutItem> getLayoutsByWindowId() {
            return this.layoutsByWindowId;
        }

        @JsonGetter(value="addedViews")
        public List<UiWorkSpaceLayoutView> getAddedViews() {
            return this.addedViews;
        }
    }

    public static class MoveViewToTopLevelCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String viewName;
        protected String windowId;
        protected UiRelativeWorkSpaceViewPosition relativePosition;
        protected UiSplitSizePolicy sizePolicy;
        protected float referenceChildSize;

        @Deprecated
        public MoveViewToTopLevelCommand() {
        }

        public MoveViewToTopLevelCommand(String componentId, String viewName, String windowId, UiRelativeWorkSpaceViewPosition relativePosition, UiSplitSizePolicy sizePolicy, float referenceChildSize) {
            this.componentId = componentId;
            this.viewName = viewName;
            this.windowId = windowId;
            this.relativePosition = relativePosition;
            this.sizePolicy = sizePolicy;
            this.referenceChildSize = referenceChildSize;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("windowId=" + this.windowId) + ", " + ("viewName=" + this.viewName) + ", " + ("relativePosition=" + this.relativePosition) + ", " + ("sizePolicy=" + this.sizePolicy) + ", " + ("referenceChildSize=" + this.referenceChildSize);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="viewName")
        public String getViewName() {
            return this.viewName;
        }

        @JsonGetter(value="windowId")
        public String getWindowId() {
            return this.windowId;
        }

        @JsonGetter(value="relativePosition")
        public UiRelativeWorkSpaceViewPosition getRelativePosition() {
            return this.relativePosition;
        }

        @JsonGetter(value="sizePolicy")
        public UiSplitSizePolicy getSizePolicy() {
            return this.sizePolicy;
        }

        @JsonGetter(value="referenceChildSize")
        public float getReferenceChildSize() {
            return this.referenceChildSize;
        }
    }

    public static class MoveViewRelativeToOtherViewCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String viewName;
        protected String existingViewName;
        protected UiRelativeWorkSpaceViewPosition relativePosition;
        protected UiSplitSizePolicy sizePolicy;
        protected float referenceChildSize;

        @Deprecated
        public MoveViewRelativeToOtherViewCommand() {
        }

        public MoveViewRelativeToOtherViewCommand(String componentId, String viewName, String existingViewName, UiRelativeWorkSpaceViewPosition relativePosition, UiSplitSizePolicy sizePolicy, float referenceChildSize) {
            this.componentId = componentId;
            this.viewName = viewName;
            this.existingViewName = existingViewName;
            this.relativePosition = relativePosition;
            this.sizePolicy = sizePolicy;
            this.referenceChildSize = referenceChildSize;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("viewName=" + this.viewName) + ", " + ("existingViewName=" + this.existingViewName) + ", " + ("relativePosition=" + this.relativePosition) + ", " + ("sizePolicy=" + this.sizePolicy) + ", " + ("referenceChildSize=" + this.referenceChildSize);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="viewName")
        public String getViewName() {
            return this.viewName;
        }

        @JsonGetter(value="existingViewName")
        public String getExistingViewName() {
            return this.existingViewName;
        }

        @JsonGetter(value="relativePosition")
        public UiRelativeWorkSpaceViewPosition getRelativePosition() {
            return this.relativePosition;
        }

        @JsonGetter(value="sizePolicy")
        public UiSplitSizePolicy getSizePolicy() {
            return this.sizePolicy;
        }

        @JsonGetter(value="referenceChildSize")
        public float getReferenceChildSize() {
            return this.referenceChildSize;
        }
    }

    public static class MoveViewToNeighbourTabCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String viewName;
        protected String existingViewName;
        protected boolean select;

        @Deprecated
        public MoveViewToNeighbourTabCommand() {
        }

        public MoveViewToNeighbourTabCommand(String componentId, String viewName, String existingViewName, boolean select) {
            this.componentId = componentId;
            this.viewName = viewName;
            this.existingViewName = existingViewName;
            this.select = select;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("viewName=" + this.viewName) + ", " + ("existingViewName=" + this.existingViewName) + ", " + ("select=" + this.select);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="viewName")
        public String getViewName() {
            return this.viewName;
        }

        @JsonGetter(value="existingViewName")
        public String getExistingViewName() {
            return this.existingViewName;
        }

        @JsonGetter(value="select")
        public boolean getSelect() {
            return this.select;
        }
    }

    public static class AddViewToTopLevelCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiWorkSpaceLayoutView newView;
        protected String windowId;
        protected UiRelativeWorkSpaceViewPosition relativePosition;
        protected UiSplitSizePolicy sizePolicy;
        protected float referenceChildSize;

        @Deprecated
        public AddViewToTopLevelCommand() {
        }

        public AddViewToTopLevelCommand(String componentId, UiWorkSpaceLayoutView newView, String windowId, UiRelativeWorkSpaceViewPosition relativePosition, UiSplitSizePolicy sizePolicy, float referenceChildSize) {
            this.componentId = componentId;
            this.newView = newView;
            this.windowId = windowId;
            this.relativePosition = relativePosition;
            this.sizePolicy = sizePolicy;
            this.referenceChildSize = referenceChildSize;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("windowId=" + this.windowId) + ", " + ("relativePosition=" + this.relativePosition) + ", " + ("sizePolicy=" + this.sizePolicy) + ", " + ("referenceChildSize=" + this.referenceChildSize) + ", " + (String)(this.newView != null ? "newView={" + this.newView.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="newView")
        public UiWorkSpaceLayoutView getNewView() {
            return this.newView;
        }

        @JsonGetter(value="windowId")
        public String getWindowId() {
            return this.windowId;
        }

        @JsonGetter(value="relativePosition")
        public UiRelativeWorkSpaceViewPosition getRelativePosition() {
            return this.relativePosition;
        }

        @JsonGetter(value="sizePolicy")
        public UiSplitSizePolicy getSizePolicy() {
            return this.sizePolicy;
        }

        @JsonGetter(value="referenceChildSize")
        public float getReferenceChildSize() {
            return this.referenceChildSize;
        }
    }

    public static class AddViewRelativeToOtherViewCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiWorkSpaceLayoutView newView;
        protected String existingViewName;
        protected UiRelativeWorkSpaceViewPosition relativePosition;
        protected UiSplitSizePolicy sizePolicy;
        protected float referenceChildSize;

        @Deprecated
        public AddViewRelativeToOtherViewCommand() {
        }

        public AddViewRelativeToOtherViewCommand(String componentId, UiWorkSpaceLayoutView newView, String existingViewName, UiRelativeWorkSpaceViewPosition relativePosition, UiSplitSizePolicy sizePolicy, float referenceChildSize) {
            this.componentId = componentId;
            this.newView = newView;
            this.existingViewName = existingViewName;
            this.relativePosition = relativePosition;
            this.sizePolicy = sizePolicy;
            this.referenceChildSize = referenceChildSize;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("existingViewName=" + this.existingViewName) + ", " + ("relativePosition=" + this.relativePosition) + ", " + ("sizePolicy=" + this.sizePolicy) + ", " + ("referenceChildSize=" + this.referenceChildSize) + ", " + (String)(this.newView != null ? "newView={" + this.newView.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="newView")
        public UiWorkSpaceLayoutView getNewView() {
            return this.newView;
        }

        @JsonGetter(value="existingViewName")
        public String getExistingViewName() {
            return this.existingViewName;
        }

        @JsonGetter(value="relativePosition")
        public UiRelativeWorkSpaceViewPosition getRelativePosition() {
            return this.relativePosition;
        }

        @JsonGetter(value="sizePolicy")
        public UiSplitSizePolicy getSizePolicy() {
            return this.sizePolicy;
        }

        @JsonGetter(value="referenceChildSize")
        public float getReferenceChildSize() {
            return this.referenceChildSize;
        }
    }

    public static class AddViewAsNeighbourTabCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiWorkSpaceLayoutView newView;
        protected String existingViewName;
        protected boolean select;

        @Deprecated
        public AddViewAsNeighbourTabCommand() {
        }

        public AddViewAsNeighbourTabCommand(String componentId, UiWorkSpaceLayoutView newView, String existingViewName, boolean select) {
            this.componentId = componentId;
            this.newView = newView;
            this.existingViewName = existingViewName;
            this.select = select;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("existingViewName=" + this.existingViewName) + ", " + ("select=" + this.select) + ", " + (String)(this.newView != null ? "newView={" + this.newView.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="newView")
        public UiWorkSpaceLayoutView getNewView() {
            return this.newView;
        }

        @JsonGetter(value="existingViewName")
        public String getExistingViewName() {
            return this.existingViewName;
        }

        @JsonGetter(value="select")
        public boolean getSelect() {
            return this.select;
        }
    }

    public static class AddViewAsTabCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiWorkSpaceLayoutView newView;
        protected String viewGroupId;
        protected boolean select;

        @Deprecated
        public AddViewAsTabCommand() {
        }

        public AddViewAsTabCommand(String componentId, UiWorkSpaceLayoutView newView, String viewGroupId, boolean select) {
            this.componentId = componentId;
            this.newView = newView;
            this.viewGroupId = viewGroupId;
            this.select = select;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("viewGroupId=" + this.viewGroupId) + ", " + ("select=" + this.select) + ", " + (String)(this.newView != null ? "newView={" + this.newView.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="newView")
        public UiWorkSpaceLayoutView getNewView() {
            return this.newView;
        }

        @JsonGetter(value="viewGroupId")
        public String getViewGroupId() {
            return this.viewGroupId;
        }

        @JsonGetter(value="select")
        public boolean getSelect() {
            return this.select;
        }
    }

    public static class SetToolbarCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiClientObjectReference toolbar;

        @Deprecated
        public SetToolbarCommand() {
        }

        public SetToolbarCommand(String componentId, UiClientObjectReference toolbar) {
            this.componentId = componentId;
            this.toolbar = toolbar;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.toolbar != null ? "toolbar={" + this.toolbar.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="toolbar")
        public UiClientObjectReference getToolbar() {
            return this.toolbar;
        }
    }

    public static class ViewGroupPanelStateChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String viewGroupId;
        protected UiViewGroupPanelState panelState;

        @Deprecated
        public ViewGroupPanelStateChangedEvent() {
        }

        public ViewGroupPanelStateChangedEvent(String componentId, String viewGroupId, UiViewGroupPanelState panelState) {
            this.componentId = componentId;
            this.viewGroupId = viewGroupId;
            this.panelState = panelState;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_WORK_SPACE_LAYOUT_VIEW_GROUP_PANEL_STATE_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("viewGroupId=" + this.viewGroupId) + ", " + ("panelState=" + this.panelState);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="viewGroupId")
        public String getViewGroupId() {
            return this.viewGroupId;
        }

        @JsonGetter(value="panelState")
        public UiViewGroupPanelState getPanelState() {
            return this.panelState;
        }
    }

    public static class ViewClosedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String viewName;

        @Deprecated
        public ViewClosedEvent() {
        }

        public ViewClosedEvent(String componentId, String viewName) {
            this.componentId = componentId;
            this.viewName = viewName;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_WORK_SPACE_LAYOUT_VIEW_CLOSED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("viewName=" + this.viewName);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="viewName")
        public String getViewName() {
            return this.viewName;
        }
    }

    public static class ViewSelectedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String viewGroupId;
        protected String viewName;
        protected List<String> siblingViewNames;

        @Deprecated
        public ViewSelectedEvent() {
        }

        public ViewSelectedEvent(String componentId, String viewGroupId, String viewName, List<String> siblingViewNames) {
            this.componentId = componentId;
            this.viewGroupId = viewGroupId;
            this.viewName = viewName;
            this.siblingViewNames = siblingViewNames;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_WORK_SPACE_LAYOUT_VIEW_SELECTED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("viewGroupId=" + this.viewGroupId) + ", " + ("viewName=" + this.viewName) + ", " + ("siblingViewNames=" + this.siblingViewNames);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="viewGroupId")
        public String getViewGroupId() {
            return this.viewGroupId;
        }

        @JsonGetter(value="viewName")
        public String getViewName() {
            return this.viewName;
        }

        @JsonGetter(value="siblingViewNames")
        public List<String> getSiblingViewNames() {
            return this.siblingViewNames;
        }
    }

    public static class ChildWindowClosedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String windowId;

        @Deprecated
        public ChildWindowClosedEvent() {
        }

        public ChildWindowClosedEvent(String componentId, String windowId) {
            this.componentId = componentId;
            this.windowId = windowId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_WORK_SPACE_LAYOUT_CHILD_WINDOW_CLOSED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("windowId=" + this.windowId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="windowId")
        public String getWindowId() {
            return this.windowId;
        }
    }

    public static class ChildWindowCreationFailedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String viewName;

        @Deprecated
        public ChildWindowCreationFailedEvent() {
        }

        public ChildWindowCreationFailedEvent(String componentId, String viewName) {
            this.componentId = componentId;
            this.viewName = viewName;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_WORK_SPACE_LAYOUT_CHILD_WINDOW_CREATION_FAILED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("viewName=" + this.viewName);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="viewName")
        public String getViewName() {
            return this.viewName;
        }
    }

    public static class ViewNeedsRefreshEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String viewName;

        @Deprecated
        public ViewNeedsRefreshEvent() {
        }

        public ViewNeedsRefreshEvent(String componentId, String viewName) {
            this.componentId = componentId;
            this.viewName = viewName;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_WORK_SPACE_LAYOUT_VIEW_NEEDS_REFRESH;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("viewName=" + this.viewName);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="viewName")
        public String getViewName() {
            return this.viewName;
        }
    }

    public static class ViewDraggedToNewWindowEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String windowId;
        protected String viewName;
        protected Map<String, UiWorkSpaceLayoutItem> layoutsByWindowId;

        @Deprecated
        public ViewDraggedToNewWindowEvent() {
        }

        public ViewDraggedToNewWindowEvent(String componentId, String windowId, String viewName, Map<String, UiWorkSpaceLayoutItem> layoutsByWindowId) {
            this.componentId = componentId;
            this.windowId = windowId;
            this.viewName = viewName;
            this.layoutsByWindowId = layoutsByWindowId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_WORK_SPACE_LAYOUT_VIEW_DRAGGED_TO_NEW_WINDOW;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("windowId=" + this.windowId) + ", " + (String)(this.layoutsByWindowId != null ? "layoutsByWindowId={" + this.layoutsByWindowId.toString() + "}" : "") + ", " + ("viewName=" + this.viewName);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="windowId")
        public String getWindowId() {
            return this.windowId;
        }

        @JsonGetter(value="viewName")
        public String getViewName() {
            return this.viewName;
        }

        @JsonGetter(value="layoutsByWindowId")
        public Map<String, UiWorkSpaceLayoutItem> getLayoutsByWindowId() {
            return this.layoutsByWindowId;
        }
    }

    public static class LayoutChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected Map<String, UiWorkSpaceLayoutItem> layoutsByWindowId;

        @Deprecated
        public LayoutChangedEvent() {
        }

        public LayoutChangedEvent(String componentId, Map<String, UiWorkSpaceLayoutItem> layoutsByWindowId) {
            this.componentId = componentId;
            this.layoutsByWindowId = layoutsByWindowId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_WORK_SPACE_LAYOUT_LAYOUT_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.layoutsByWindowId != null ? "layoutsByWindowId={" + this.layoutsByWindowId.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="layoutsByWindowId")
        public Map<String, UiWorkSpaceLayoutItem> getLayoutsByWindowId() {
            return this.layoutsByWindowId;
        }
    }
}

