package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public abstract class UiField extends UiComponent implements UiObject {


	protected UiFieldEditingMode editingMode = UiFieldEditingMode.EDITABLE;

	@JsonSerialize(using = ObjectSerializer.class)
	@JsonDeserialize(using = ObjectDeserializer.class)
	protected Object value;
	protected List<UiFieldMessage> fieldMessages;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiField() {
		// default constructor for Jackson
	}

	public UiField(String id) {
		super(id);
	}


	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("editingMode=" + editingMode).append(", ")
				.append("value=" + value).append(", ")
				.append(fieldMessages != null ? "fieldMessages={" + fieldMessages.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("editingMode")
	public UiFieldEditingMode getEditingMode() {
		return editingMode;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("value")
	public Object getValue() {
		return value;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("fieldMessages")
	public List<UiFieldMessage> getFieldMessages() {
		return fieldMessages;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiField setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiField setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("editingMode")
	public UiField setEditingMode(UiFieldEditingMode editingMode) {
		this.editingMode = editingMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("value")
	public UiField setValue(Object value) {
		this.value = value;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("fieldMessages")
	public UiField setFieldMessages(List<UiFieldMessage> fieldMessages) {
		this.fieldMessages = fieldMessages;
		return this;
	}

	public static class ValueChangedEvent implements UiEvent {

		@UiComponentId protected String componentId;

		@JsonSerialize(using = ObjectSerializer.class)
		@JsonDeserialize(using = ObjectDeserializer.class)
		protected Object value;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ValueChangedEvent() {
			// default constructor for Jackson
		}

		public ValueChangedEvent(String componentId, Object value) {
			this.componentId = componentId;
			this.value = value;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_FIELD_VALUE_CHANGED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("value=" + value)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("value")
		public Object getValue() {
			return value;
		}

	}

	public static class SetEditingModeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiFieldEditingMode editingMode;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetEditingModeCommand() {
			// default constructor for Jackson
		}

		public SetEditingModeCommand(String componentId, UiFieldEditingMode editingMode) {
			this.componentId = componentId;
			this.editingMode = editingMode;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("editingMode=" + editingMode)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("editingMode")
		public UiFieldEditingMode getEditingMode() {
			return editingMode;
		}

	}

	public static class SetValueCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		@JsonSerialize(using = ObjectSerializer.class)
		@JsonDeserialize(using = ObjectDeserializer.class)
		protected Object value;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetValueCommand() {
			// default constructor for Jackson
		}

		public SetValueCommand(String componentId, Object value) {
			this.componentId = componentId;
			this.value = value;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("value=" + value)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("value")
		public Object getValue() {
			return value;
		}

	}

	public static class FocusCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public FocusCommand() {
			// default constructor for Jackson
		}

		public FocusCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class SetFieldMessagesCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<UiFieldMessage> fieldMessages;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetFieldMessagesCommand() {
			// default constructor for Jackson
		}

		public SetFieldMessagesCommand(String componentId, List<UiFieldMessage> fieldMessages) {
			this.componentId = componentId;
			this.fieldMessages = fieldMessages;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(fieldMessages != null ? "fieldMessages={" + fieldMessages.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fieldMessages")
		public List<UiFieldMessage> getFieldMessages() {
			return fieldMessages;
		}

	}




}