/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiBorder;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiPageDisplayMode;
import org.teamapps.dto.UiShadow;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiDocumentViewer
extends UiComponent
implements UiObject {
    protected List<String> pageUrls;
    protected UiPageDisplayMode displayMode = UiPageDisplayMode.FIT_WIDTH;
    protected float zoomFactor = 1.0f;
    protected UiBorder pageBorder;
    protected UiShadow pageShadow;
    protected int padding = 0;
    protected int pageSpacing = 5;

    @Deprecated
    public UiDocumentViewer() {
    }

    public UiDocumentViewer(String id) {
        super(id);
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_DOCUMENT_VIEWER;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("pageUrls=" + this.pageUrls) + ", " + ("displayMode=" + this.displayMode) + ", " + ("zoomFactor=" + this.zoomFactor) + ", " + ("padding=" + this.padding) + ", " + ("pageSpacing=" + this.pageSpacing) + ", " + (String)(this.pageBorder != null ? "pageBorder={" + this.pageBorder.toString() + "}" : "") + ", " + (String)(this.pageShadow != null ? "pageShadow={" + this.pageShadow.toString() + "}" : "");
    }

    @JsonGetter(value="pageUrls")
    public List<String> getPageUrls() {
        return this.pageUrls;
    }

    @JsonGetter(value="displayMode")
    public UiPageDisplayMode getDisplayMode() {
        return this.displayMode;
    }

    @JsonGetter(value="zoomFactor")
    public float getZoomFactor() {
        return this.zoomFactor;
    }

    @JsonGetter(value="pageBorder")
    public UiBorder getPageBorder() {
        return this.pageBorder;
    }

    @JsonGetter(value="pageShadow")
    public UiShadow getPageShadow() {
        return this.pageShadow;
    }

    @JsonGetter(value="padding")
    public int getPadding() {
        return this.padding;
    }

    @JsonGetter(value="pageSpacing")
    public int getPageSpacing() {
        return this.pageSpacing;
    }

    @Override
    @JsonSetter(value="visible")
    public UiDocumentViewer setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiDocumentViewer setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="pageUrls")
    public UiDocumentViewer setPageUrls(List<String> pageUrls) {
        this.pageUrls = pageUrls;
        return this;
    }

    @JsonSetter(value="displayMode")
    public UiDocumentViewer setDisplayMode(UiPageDisplayMode displayMode) {
        this.displayMode = displayMode;
        return this;
    }

    @JsonSetter(value="zoomFactor")
    public UiDocumentViewer setZoomFactor(float zoomFactor) {
        this.zoomFactor = zoomFactor;
        return this;
    }

    @JsonSetter(value="pageBorder")
    public UiDocumentViewer setPageBorder(UiBorder pageBorder) {
        this.pageBorder = pageBorder;
        return this;
    }

    @JsonSetter(value="pageShadow")
    public UiDocumentViewer setPageShadow(UiShadow pageShadow) {
        this.pageShadow = pageShadow;
        return this;
    }

    @JsonSetter(value="padding")
    public UiDocumentViewer setPadding(int padding) {
        this.padding = padding;
        return this;
    }

    @JsonSetter(value="pageSpacing")
    public UiDocumentViewer setPageSpacing(int pageSpacing) {
        this.pageSpacing = pageSpacing;
        return this;
    }

    public static class SetPageSpacingCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int pageSpacing;

        @Deprecated
        public SetPageSpacingCommand() {
        }

        public SetPageSpacingCommand(String componentId, int pageSpacing) {
            this.componentId = componentId;
            this.pageSpacing = pageSpacing;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("pageSpacing=" + this.pageSpacing);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="pageSpacing")
        public int getPageSpacing() {
            return this.pageSpacing;
        }
    }

    public static class SetPadddingCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int padding;

        @Deprecated
        public SetPadddingCommand() {
        }

        public SetPadddingCommand(String componentId, int padding) {
            this.componentId = componentId;
            this.padding = padding;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("padding=" + this.padding);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="padding")
        public int getPadding() {
            return this.padding;
        }
    }

    public static class SetPageShadowCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiShadow pageShadow;

        @Deprecated
        public SetPageShadowCommand() {
        }

        public SetPageShadowCommand(String componentId, UiShadow pageShadow) {
            this.componentId = componentId;
            this.pageShadow = pageShadow;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.pageShadow != null ? "pageShadow={" + this.pageShadow.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="pageShadow")
        public UiShadow getPageShadow() {
            return this.pageShadow;
        }
    }

    public static class SetPageBorderCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiBorder pageBorder;

        @Deprecated
        public SetPageBorderCommand() {
        }

        public SetPageBorderCommand(String componentId, UiBorder pageBorder) {
            this.componentId = componentId;
            this.pageBorder = pageBorder;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.pageBorder != null ? "pageBorder={" + this.pageBorder.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="pageBorder")
        public UiBorder getPageBorder() {
            return this.pageBorder;
        }
    }

    public static class SetZoomFactorCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected float zoomFactor;

        @Deprecated
        public SetZoomFactorCommand() {
        }

        public SetZoomFactorCommand(String componentId, float zoomFactor) {
            this.componentId = componentId;
            this.zoomFactor = zoomFactor;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("zoomFactor=" + this.zoomFactor);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="zoomFactor")
        public float getZoomFactor() {
            return this.zoomFactor;
        }
    }

    public static class SetDisplayModeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiPageDisplayMode displayMode;
        protected float zoomFactor;

        @Deprecated
        public SetDisplayModeCommand() {
        }

        public SetDisplayModeCommand(String componentId, UiPageDisplayMode displayMode, float zoomFactor) {
            this.componentId = componentId;
            this.displayMode = displayMode;
            this.zoomFactor = zoomFactor;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("displayMode=" + this.displayMode) + ", " + ("zoomFactor=" + this.zoomFactor);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="displayMode")
        public UiPageDisplayMode getDisplayMode() {
            return this.displayMode;
        }

        @JsonGetter(value="zoomFactor")
        public float getZoomFactor() {
            return this.zoomFactor;
        }
    }

    public static class SetPageUrlsCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<String> pageUrls;

        @Deprecated
        public SetPageUrlsCommand() {
        }

        public SetPageUrlsCommand(String componentId, List<String> pageUrls) {
            this.componentId = componentId;
            this.pageUrls = pageUrls;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("pageUrls=" + this.pageUrls);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="pageUrls")
        public List<String> getPageUrls() {
            return this.pageUrls;
        }
    }
}

