/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiFieldEditingMode;
import org.teamapps.dto.UiFieldMessage;
import org.teamapps.dto.UiNumberFieldSliderMode;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiTextInputHandlingField;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiNumberField
extends UiField
implements UiTextInputHandlingField,
UiObject {
    protected int precision = -1;
    protected String emptyText;
    protected boolean showClearButton;
    protected double minValue = Double.MIN_VALUE;
    protected double maxValue = Double.MAX_VALUE;
    protected UiNumberFieldSliderMode sliderMode = UiNumberFieldSliderMode.DISABLED;
    protected double sliderStep = 1.0;
    protected boolean commitOnSliderChange = true;

    @Deprecated
    public UiNumberField() {
    }

    public UiNumberField(String id) {
        super(id);
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_NUMBER_FIELD;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("editingMode=" + this.editingMode) + ", " + ("value=" + this.value) + ", " + ("precision=" + this.precision) + ", " + ("emptyText=" + this.emptyText) + ", " + ("showClearButton=" + this.showClearButton) + ", " + ("minValue=" + this.minValue) + ", " + ("maxValue=" + this.maxValue) + ", " + ("sliderMode=" + this.sliderMode) + ", " + ("sliderStep=" + this.sliderStep) + ", " + ("commitOnSliderChange=" + this.commitOnSliderChange) + ", " + (String)(this.fieldMessages != null ? "fieldMessages={" + this.fieldMessages.toString() + "}" : "");
    }

    @JsonGetter(value="precision")
    public int getPrecision() {
        return this.precision;
    }

    @JsonGetter(value="emptyText")
    public String getEmptyText() {
        return this.emptyText;
    }

    @JsonGetter(value="showClearButton")
    public boolean getShowClearButton() {
        return this.showClearButton;
    }

    @JsonGetter(value="minValue")
    public double getMinValue() {
        return this.minValue;
    }

    @JsonGetter(value="maxValue")
    public double getMaxValue() {
        return this.maxValue;
    }

    @JsonGetter(value="sliderMode")
    public UiNumberFieldSliderMode getSliderMode() {
        return this.sliderMode;
    }

    @JsonGetter(value="sliderStep")
    public double getSliderStep() {
        return this.sliderStep;
    }

    @JsonGetter(value="commitOnSliderChange")
    public boolean getCommitOnSliderChange() {
        return this.commitOnSliderChange;
    }

    @Override
    @JsonSetter(value="visible")
    public UiNumberField setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiNumberField setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="editingMode")
    public UiNumberField setEditingMode(UiFieldEditingMode editingMode) {
        this.editingMode = editingMode;
        return this;
    }

    @Override
    @JsonSetter(value="value")
    public UiNumberField setValue(Object value) {
        this.value = value;
        return this;
    }

    @Override
    @JsonSetter(value="fieldMessages")
    public UiNumberField setFieldMessages(List<UiFieldMessage> fieldMessages) {
        this.fieldMessages = fieldMessages;
        return this;
    }

    @JsonSetter(value="precision")
    public UiNumberField setPrecision(int precision) {
        this.precision = precision;
        return this;
    }

    @JsonSetter(value="emptyText")
    public UiNumberField setEmptyText(String emptyText) {
        this.emptyText = emptyText;
        return this;
    }

    @JsonSetter(value="showClearButton")
    public UiNumberField setShowClearButton(boolean showClearButton) {
        this.showClearButton = showClearButton;
        return this;
    }

    @JsonSetter(value="minValue")
    public UiNumberField setMinValue(double minValue) {
        this.minValue = minValue;
        return this;
    }

    @JsonSetter(value="maxValue")
    public UiNumberField setMaxValue(double maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    @JsonSetter(value="sliderMode")
    public UiNumberField setSliderMode(UiNumberFieldSliderMode sliderMode) {
        this.sliderMode = sliderMode;
        return this;
    }

    @JsonSetter(value="sliderStep")
    public UiNumberField setSliderStep(double sliderStep) {
        this.sliderStep = sliderStep;
        return this;
    }

    @JsonSetter(value="commitOnSliderChange")
    public UiNumberField setCommitOnSliderChange(boolean commitOnSliderChange) {
        this.commitOnSliderChange = commitOnSliderChange;
        return this;
    }

    public static class SetShowClearButtonCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected boolean showClearButton;

        @Deprecated
        public SetShowClearButtonCommand() {
        }

        public SetShowClearButtonCommand(String componentId, boolean showClearButton) {
            this.componentId = componentId;
            this.showClearButton = showClearButton;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("showClearButton=" + this.showClearButton);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="showClearButton")
        public boolean getShowClearButton() {
            return this.showClearButton;
        }
    }

    public static class SetEmptyTextCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String emptyText;

        @Deprecated
        public SetEmptyTextCommand() {
        }

        public SetEmptyTextCommand(String componentId, String emptyText) {
            this.componentId = componentId;
            this.emptyText = emptyText;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("emptyText=" + this.emptyText);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="emptyText")
        public String getEmptyText() {
            return this.emptyText;
        }
    }

    public static class SetPrecisionCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int displayPrecision;

        @Deprecated
        public SetPrecisionCommand() {
        }

        public SetPrecisionCommand(String componentId, int displayPrecision) {
            this.componentId = componentId;
            this.displayPrecision = displayPrecision;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("displayPrecision=" + this.displayPrecision);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="displayPrecision")
        public int getDisplayPrecision() {
            return this.displayPrecision;
        }
    }

    public static class SetCommitOnSliderChangeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected boolean commitOnSliderChange;

        @Deprecated
        public SetCommitOnSliderChangeCommand() {
        }

        public SetCommitOnSliderChangeCommand(String componentId, boolean commitOnSliderChange) {
            this.componentId = componentId;
            this.commitOnSliderChange = commitOnSliderChange;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("commitOnSliderChange=" + this.commitOnSliderChange);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="commitOnSliderChange")
        public boolean getCommitOnSliderChange() {
            return this.commitOnSliderChange;
        }
    }

    public static class SetSliderStepCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected double step;

        @Deprecated
        public SetSliderStepCommand() {
        }

        public SetSliderStepCommand(String componentId, double step) {
            this.componentId = componentId;
            this.step = step;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("step=" + this.step);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="step")
        public double getStep() {
            return this.step;
        }
    }

    public static class SetSliderModeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiNumberFieldSliderMode sliderMode;

        @Deprecated
        public SetSliderModeCommand() {
        }

        public SetSliderModeCommand(String componentId, UiNumberFieldSliderMode sliderMode) {
            this.componentId = componentId;
            this.sliderMode = sliderMode;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("sliderMode=" + this.sliderMode);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="sliderMode")
        public UiNumberFieldSliderMode getSliderMode() {
            return this.sliderMode;
        }
    }

    public static class SetMaxValueCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected double max;

        @Deprecated
        public SetMaxValueCommand() {
        }

        public SetMaxValueCommand(String componentId, double max) {
            this.componentId = componentId;
            this.max = max;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("max=" + this.max);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="max")
        public double getMax() {
            return this.max;
        }
    }

    public static class SetMinValueCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected double min;

        @Deprecated
        public SetMinValueCommand() {
        }

        public SetMinValueCommand(String componentId, double min) {
            this.componentId = componentId;
            this.min = min;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("min=" + this.min);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="min")
        public double getMin() {
            return this.min;
        }
    }
}

