/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiIconPosition;
import org.teamapps.dto.UiImageTemplate;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiTemplate;
import org.teamapps.dto.UiTextCellTemplateElement;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiTextCellTemplate
implements UiTemplate,
UiObject {
    protected UiImageTemplate imageTemplate;
    protected String imagePropertyName;
    protected UiIconPosition iconPosition = UiIconPosition.LEFT_MIDDLE;
    protected int imageSpacing = 0;
    protected int horizontalPadding = 2;
    protected int verticalPadding = 2;
    protected List<UiTextCellTemplateElement> textElements;
    protected int minHeight;
    protected int maxHeight;
    protected JustifyLines justifyLines = JustifyLines.JUSTIFY_CENTER_OVERFLOW_BOTTOM;

    @Deprecated
    public UiTextCellTemplate() {
    }

    public UiTextCellTemplate(List<UiTextCellTemplateElement> textElements) {
        this.textElements = textElements;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_TEXT_CELL_TEMPLATE;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("imagePropertyName=" + this.imagePropertyName) + ", " + ("iconPosition=" + this.iconPosition) + ", " + ("imageSpacing=" + this.imageSpacing) + ", " + ("horizontalPadding=" + this.horizontalPadding) + ", " + ("verticalPadding=" + this.verticalPadding) + ", " + ("minHeight=" + this.minHeight) + ", " + ("maxHeight=" + this.maxHeight) + ", " + ("justifyLines=" + this.justifyLines) + ", " + (String)(this.imageTemplate != null ? "imageTemplate={" + this.imageTemplate.toString() + "}" : "") + ", " + (String)(this.textElements != null ? "textElements={" + this.textElements.toString() + "}" : "");
    }

    @JsonGetter(value="imageTemplate")
    public UiImageTemplate getImageTemplate() {
        return this.imageTemplate;
    }

    @JsonGetter(value="imagePropertyName")
    public String getImagePropertyName() {
        return this.imagePropertyName;
    }

    @JsonGetter(value="iconPosition")
    public UiIconPosition getIconPosition() {
        return this.iconPosition;
    }

    @JsonGetter(value="imageSpacing")
    public int getImageSpacing() {
        return this.imageSpacing;
    }

    @JsonGetter(value="horizontalPadding")
    public int getHorizontalPadding() {
        return this.horizontalPadding;
    }

    @JsonGetter(value="verticalPadding")
    public int getVerticalPadding() {
        return this.verticalPadding;
    }

    @JsonGetter(value="textElements")
    public List<UiTextCellTemplateElement> getTextElements() {
        return this.textElements;
    }

    @JsonGetter(value="minHeight")
    public int getMinHeight() {
        return this.minHeight;
    }

    @JsonGetter(value="maxHeight")
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @JsonGetter(value="justifyLines")
    public JustifyLines getJustifyLines() {
        return this.justifyLines;
    }

    @JsonSetter(value="imageTemplate")
    public UiTextCellTemplate setImageTemplate(UiImageTemplate imageTemplate) {
        this.imageTemplate = imageTemplate;
        return this;
    }

    @JsonSetter(value="imagePropertyName")
    public UiTextCellTemplate setImagePropertyName(String imagePropertyName) {
        this.imagePropertyName = imagePropertyName;
        return this;
    }

    @JsonSetter(value="iconPosition")
    public UiTextCellTemplate setIconPosition(UiIconPosition iconPosition) {
        this.iconPosition = iconPosition;
        return this;
    }

    @JsonSetter(value="imageSpacing")
    public UiTextCellTemplate setImageSpacing(int imageSpacing) {
        this.imageSpacing = imageSpacing;
        return this;
    }

    @JsonSetter(value="horizontalPadding")
    public UiTextCellTemplate setHorizontalPadding(int horizontalPadding) {
        this.horizontalPadding = horizontalPadding;
        return this;
    }

    @JsonSetter(value="verticalPadding")
    public UiTextCellTemplate setVerticalPadding(int verticalPadding) {
        this.verticalPadding = verticalPadding;
        return this;
    }

    @JsonSetter(value="minHeight")
    public UiTextCellTemplate setMinHeight(int minHeight) {
        this.minHeight = minHeight;
        return this;
    }

    @JsonSetter(value="maxHeight")
    public UiTextCellTemplate setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    @JsonSetter(value="justifyLines")
    public UiTextCellTemplate setJustifyLines(JustifyLines justifyLines) {
        this.justifyLines = justifyLines;
        return this;
    }

    public static enum JustifyLines {
        JUSTIFY_TOP,
        JUSTIFY_CENTER,
        JUSTIFY_CENTER_OVERFLOW_BOTTOM;


        @JsonValue
        public int jsonValue() {
            return this.ordinal();
        }
    }
}

