/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiTreeGraphNode;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiTreeGraph
extends UiComponent
implements UiObject {
    protected List<UiTreeGraphNode> nodes;

    @Deprecated
    public UiTreeGraph() {
    }

    public UiTreeGraph(String id, List<UiTreeGraphNode> nodes) {
        super(id);
        this.nodes = nodes;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_TREE_GRAPH;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + (String)(this.nodes != null ? "nodes={" + this.nodes.toString() + "}" : "");
    }

    @JsonGetter(value="nodes")
    public List<UiTreeGraphNode> getNodes() {
        return this.nodes;
    }

    @Override
    @JsonSetter(value="visible")
    public UiTreeGraph setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiTreeGraph setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    public static class SetExpandedCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String nodeId;
        protected boolean expanded;

        @Deprecated
        public SetExpandedCommand() {
        }

        public SetExpandedCommand(String componentId, String nodeId, boolean expanded) {
            this.componentId = componentId;
            this.nodeId = nodeId;
            this.expanded = expanded;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("nodeId=" + this.nodeId) + ", " + ("expanded=" + this.expanded);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="nodeId")
        public String getNodeId() {
            return this.nodeId;
        }

        @JsonGetter(value="expanded")
        public boolean getExpanded() {
            return this.expanded;
        }
    }

    public static class RemoveNodeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String nodeId;

        @Deprecated
        public RemoveNodeCommand() {
        }

        public RemoveNodeCommand(String componentId, String nodeId) {
            this.componentId = componentId;
            this.nodeId = nodeId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("nodeId=" + this.nodeId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="nodeId")
        public String getNodeId() {
            return this.nodeId;
        }
    }

    public static class AddNodeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiTreeGraphNode node;

        @Deprecated
        public AddNodeCommand() {
        }

        public AddNodeCommand(String componentId, UiTreeGraphNode node) {
            this.componentId = componentId;
            this.node = node;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.node != null ? "node={" + this.node.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="node")
        public UiTreeGraphNode getNode() {
            return this.node;
        }
    }

    public static class SetZoomFactorCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected float zoomFactor;

        @Deprecated
        public SetZoomFactorCommand() {
        }

        public SetZoomFactorCommand(String componentId, float zoomFactor) {
            this.componentId = componentId;
            this.zoomFactor = zoomFactor;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("zoomFactor=" + this.zoomFactor);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="zoomFactor")
        public float getZoomFactor() {
            return this.zoomFactor;
        }
    }

    public static class HandleNodeClickEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String nodeId;

        @Deprecated
        public HandleNodeClickEvent() {
        }

        public HandleNodeClickEvent(String componentId, String nodeId) {
            this.componentId = componentId;
            this.nodeId = nodeId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TREE_GRAPH_HANDLE_NODE_CLICK;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("nodeId=" + this.nodeId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="nodeId")
        public String getNodeId() {
            return this.nodeId;
        }
    }
}

