package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiTextElement extends AbstractUiTemplateElement implements UiObject {


	protected UiFontStyle fontStyle;
	protected float lineHeight = 1.2f;
	protected boolean wrapLines;
	protected UiSpacing padding;
	protected UiTextAlignment textAlignment = UiTextAlignment.LEFT;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiTextElement() {
		// default constructor for Jackson
	}

	public UiTextElement(String dataKey, int row, int column) {
		super(dataKey, row, column);
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_TEXT_ELEMENT;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("dataKey=" + dataKey).append(", ")
				.append("row=" + row).append(", ")
				.append("column=" + column).append(", ")
				.append("rowSpan=" + rowSpan).append(", ")
				.append("colSpan=" + colSpan).append(", ")
				.append("horizontalAlignment=" + horizontalAlignment).append(", ")
				.append("verticalAlignment=" + verticalAlignment).append(", ")
				.append("backgroundColor=" + backgroundColor).append(", ")
				.append("lineHeight=" + lineHeight).append(", ")
				.append("wrapLines=" + wrapLines).append(", ")
				.append("textAlignment=" + textAlignment).append(", ")
				.append(margin != null ? "margin={" + margin.toString() + "}" : "").append(", ")
				.append(fontStyle != null ? "fontStyle={" + fontStyle.toString() + "}" : "").append(", ")
				.append(padding != null ? "padding={" + padding.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("fontStyle")
	public UiFontStyle getFontStyle() {
		return fontStyle;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("lineHeight")
	public float getLineHeight() {
		return lineHeight;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("wrapLines")
	public boolean getWrapLines() {
		return wrapLines;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("padding")
	public UiSpacing getPadding() {
		return padding;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("textAlignment")
	public UiTextAlignment getTextAlignment() {
		return textAlignment;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("rowSpan")
	public UiTextElement setRowSpan(int rowSpan) {
		this.rowSpan = rowSpan;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("colSpan")
	public UiTextElement setColSpan(int colSpan) {
		this.colSpan = colSpan;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("horizontalAlignment")
	public UiTextElement setHorizontalAlignment(UiHorizontalElementAlignment horizontalAlignment) {
		this.horizontalAlignment = horizontalAlignment;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("verticalAlignment")
	public UiTextElement setVerticalAlignment(UiVerticalElementAlignment verticalAlignment) {
		this.verticalAlignment = verticalAlignment;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("margin")
	public UiTextElement setMargin(UiSpacing margin) {
		this.margin = margin;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundColor")
	public UiTextElement setBackgroundColor(String backgroundColor) {
		this.backgroundColor = backgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("fontStyle")
	public UiTextElement setFontStyle(UiFontStyle fontStyle) {
		this.fontStyle = fontStyle;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("lineHeight")
	public UiTextElement setLineHeight(float lineHeight) {
		this.lineHeight = lineHeight;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("wrapLines")
	public UiTextElement setWrapLines(boolean wrapLines) {
		this.wrapLines = wrapLines;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("padding")
	public UiTextElement setPadding(UiSpacing padding) {
		this.padding = padding;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("textAlignment")
	public UiTextElement setTextAlignment(UiTextAlignment textAlignment) {
		this.textAlignment = textAlignment;
		return this;
	}






}