/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiNavigationBarButton;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiTemplate;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiNavigationBar
extends UiComponent
implements UiObject {
    protected UiTemplate buttonTemplate;
    protected List<UiNavigationBarButton> buttons;
    protected String backgroundColor = "rgba(255, 255, 255, 0.84)";
    protected String borderColor;
    protected List<UiClientObjectReference> fanOutComponents;
    protected UiClientObjectReference multiProgressDisplay;

    @Deprecated
    public UiNavigationBar() {
    }

    public UiNavigationBar(UiTemplate buttonTemplate) {
        this.buttonTemplate = buttonTemplate;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_NAVIGATION_BAR;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + (String)(this.buttonTemplate != null ? "buttonTemplate={" + this.buttonTemplate.toString() + "}" : "") + ", " + ("backgroundColor=" + this.backgroundColor) + ", " + ("borderColor=" + this.borderColor) + ", " + (String)(this.buttons != null ? "buttons={" + this.buttons.toString() + "}" : "") + ", " + (String)(this.fanOutComponents != null ? "fanOutComponents={" + this.fanOutComponents.toString() + "}" : "") + ", " + (String)(this.multiProgressDisplay != null ? "multiProgressDisplay={" + this.multiProgressDisplay.toString() + "}" : "");
    }

    @JsonGetter(value="buttonTemplate")
    public UiTemplate getButtonTemplate() {
        return this.buttonTemplate;
    }

    @JsonGetter(value="buttons")
    public List<UiNavigationBarButton> getButtons() {
        return this.buttons;
    }

    @JsonGetter(value="backgroundColor")
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @JsonGetter(value="borderColor")
    public String getBorderColor() {
        return this.borderColor;
    }

    @JsonGetter(value="fanOutComponents")
    public List<UiClientObjectReference> getFanOutComponents() {
        return this.fanOutComponents;
    }

    @JsonGetter(value="multiProgressDisplay")
    public UiClientObjectReference getMultiProgressDisplay() {
        return this.multiProgressDisplay;
    }

    @Override
    @JsonSetter(value="id")
    public UiNavigationBar setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiNavigationBar setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiNavigationBar setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiNavigationBar setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiNavigationBar setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiNavigationBar setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="buttons")
    public UiNavigationBar setButtons(List<UiNavigationBarButton> buttons) {
        this.buttons = buttons;
        return this;
    }

    @JsonSetter(value="backgroundColor")
    public UiNavigationBar setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @JsonSetter(value="borderColor")
    public UiNavigationBar setBorderColor(String borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    @JsonSetter(value="fanOutComponents")
    public UiNavigationBar setFanOutComponents(List<UiClientObjectReference> fanOutComponents) {
        this.fanOutComponents = fanOutComponents;
        return this;
    }

    @JsonSetter(value="multiProgressDisplay")
    public UiNavigationBar setMultiProgressDisplay(UiClientObjectReference multiProgressDisplay) {
        this.multiProgressDisplay = multiProgressDisplay;
        return this;
    }

    public static class SetMultiProgressDisplayCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiClientObjectReference multiProgressDisplay;

        @Deprecated
        public SetMultiProgressDisplayCommand() {
        }

        public SetMultiProgressDisplayCommand(String componentId, UiClientObjectReference multiProgressDisplay) {
            this.componentId = componentId;
            this.multiProgressDisplay = multiProgressDisplay;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.multiProgressDisplay != null ? "multiProgressDisplay={" + this.multiProgressDisplay.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="multiProgressDisplay")
        public UiClientObjectReference getMultiProgressDisplay() {
            return this.multiProgressDisplay;
        }
    }

    public static class HideFanOutComponentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public HideFanOutComponentCommand() {
        }

        public HideFanOutComponentCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class ShowFanOutComponentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiClientObjectReference fanOutComponent;

        @Deprecated
        public ShowFanOutComponentCommand() {
        }

        public ShowFanOutComponentCommand(String componentId, UiClientObjectReference fanOutComponent) {
            this.componentId = componentId;
            this.fanOutComponent = fanOutComponent;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.fanOutComponent != null ? "fanOutComponent={" + this.fanOutComponent.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fanOutComponent")
        public UiClientObjectReference getFanOutComponent() {
            return this.fanOutComponent;
        }
    }

    public static class RemoveFanOutComponentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiClientObjectReference fanOutComponent;

        @Deprecated
        public RemoveFanOutComponentCommand() {
        }

        public RemoveFanOutComponentCommand(String componentId, UiClientObjectReference fanOutComponent) {
            this.componentId = componentId;
            this.fanOutComponent = fanOutComponent;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.fanOutComponent != null ? "fanOutComponent={" + this.fanOutComponent.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fanOutComponent")
        public UiClientObjectReference getFanOutComponent() {
            return this.fanOutComponent;
        }
    }

    public static class AddFanOutComponentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiClientObjectReference fanOutComponent;

        @Deprecated
        public AddFanOutComponentCommand() {
        }

        public AddFanOutComponentCommand(String componentId, UiClientObjectReference fanOutComponent) {
            this.componentId = componentId;
            this.fanOutComponent = fanOutComponent;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.fanOutComponent != null ? "fanOutComponent={" + this.fanOutComponent.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fanOutComponent")
        public UiClientObjectReference getFanOutComponent() {
            return this.fanOutComponent;
        }
    }

    public static class SetBorderColorCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String borderColor;

        @Deprecated
        public SetBorderColorCommand() {
        }

        public SetBorderColorCommand(String componentId, String borderColor) {
            this.componentId = componentId;
            this.borderColor = borderColor;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("borderColor=" + this.borderColor);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="borderColor")
        public String getBorderColor() {
            return this.borderColor;
        }
    }

    public static class SetBackgroundColorCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String backgroundColor;

        @Deprecated
        public SetBackgroundColorCommand() {
        }

        public SetBackgroundColorCommand(String componentId, String backgroundColor) {
            this.componentId = componentId;
            this.backgroundColor = backgroundColor;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("backgroundColor=" + this.backgroundColor);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="backgroundColor")
        public String getBackgroundColor() {
            return this.backgroundColor;
        }
    }

    public static class SetButtonVisibleCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String buttonId;
        protected boolean visible;

        @Deprecated
        public SetButtonVisibleCommand() {
        }

        public SetButtonVisibleCommand(String componentId, String buttonId, boolean visible) {
            this.componentId = componentId;
            this.buttonId = buttonId;
            this.visible = visible;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("buttonId=" + this.buttonId) + ", " + ("visible=" + this.visible);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="buttonId")
        public String getButtonId() {
            return this.buttonId;
        }

        @JsonGetter(value="visible")
        public boolean getVisible() {
            return this.visible;
        }
    }

    public static class SetButtonsCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<UiNavigationBarButton> buttons;

        @Deprecated
        public SetButtonsCommand() {
        }

        public SetButtonsCommand(String componentId, List<UiNavigationBarButton> buttons) {
            this.componentId = componentId;
            this.buttons = buttons;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.buttons != null ? "buttons={" + this.buttons.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="buttons")
        public List<UiNavigationBarButton> getButtons() {
            return this.buttons;
        }
    }

    public static class FanoutClosedDueToClickOutsideFanoutEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public FanoutClosedDueToClickOutsideFanoutEvent() {
        }

        public FanoutClosedDueToClickOutsideFanoutEvent(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_NAVIGATION_BAR_FANOUT_CLOSED_DUE_TO_CLICK_OUTSIDE_FANOUT;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class ButtonClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String buttonId;
        protected String visibleFanOutComponentId;

        @Deprecated
        public ButtonClickedEvent() {
        }

        public ButtonClickedEvent(String componentId, String buttonId, String visibleFanOutComponentId) {
            this.componentId = componentId;
            this.buttonId = buttonId;
            this.visibleFanOutComponentId = visibleFanOutComponentId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_NAVIGATION_BAR_BUTTON_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("buttonId=" + this.buttonId) + ", " + ("visibleFanOutComponentId=" + this.visibleFanOutComponentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="buttonId")
        public String getButtonId() {
            return this.buttonId;
        }

        @JsonGetter(value="visibleFanOutComponentId")
        public String getVisibleFanOutComponentId() {
            return this.visibleFanOutComponentId;
        }
    }
}

