package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiWebRtcPublisher extends UiComponent implements UiObject {


	protected UiWebRtcPublishingSettings publishingSettings;
	protected boolean microphoneMuted = false;
	protected String backgroundImageUrl;

	public UiWebRtcPublisher() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_WEB_RTC_PUBLISHER;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("attributesBySelector=" + attributesBySelector).append(", ")
				.append("microphoneMuted=" + microphoneMuted).append(", ")
				.append("backgroundImageUrl=" + backgroundImageUrl).append(", ")
				.append(publishingSettings != null ? "publishingSettings={" + publishingSettings.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("publishingSettings")
	public UiWebRtcPublishingSettings getPublishingSettings() {
		return publishingSettings;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("microphoneMuted")
	public boolean getMicrophoneMuted() {
		return microphoneMuted;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundImageUrl")
	public String getBackgroundImageUrl() {
		return backgroundImageUrl;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiWebRtcPublisher setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiWebRtcPublisher setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiWebRtcPublisher setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiWebRtcPublisher setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiWebRtcPublisher setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("attributesBySelector")
	public UiWebRtcPublisher setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
		this.attributesBySelector = attributesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("publishingSettings")
	public UiWebRtcPublisher setPublishingSettings(UiWebRtcPublishingSettings publishingSettings) {
		this.publishingSettings = publishingSettings;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("microphoneMuted")
	public UiWebRtcPublisher setMicrophoneMuted(boolean microphoneMuted) {
		this.microphoneMuted = microphoneMuted;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundImageUrl")
	public UiWebRtcPublisher setBackgroundImageUrl(String backgroundImageUrl) {
		this.backgroundImageUrl = backgroundImageUrl;
		return this;
	}

	public static class PublishingFailedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiWebRtcPublishingErrorReason reason;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public PublishingFailedEvent() {
			// default constructor for Jackson
		}

		public PublishingFailedEvent(String componentId, UiWebRtcPublishingErrorReason reason) {
			this.componentId = componentId;
			this.reason = reason;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_WEB_RTC_PUBLISHER_PUBLISHING_FAILED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("reason=" + reason)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("reason")
		public UiWebRtcPublishingErrorReason getReason() {
			return reason;
		}

	}

	public static class PublishCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiWebRtcPublishingSettings settings;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public PublishCommand() {
			// default constructor for Jackson
		}

		public PublishCommand(String componentId, UiWebRtcPublishingSettings settings) {
			this.componentId = componentId;
			this.settings = settings;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(settings != null ? "settings={" + settings.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("settings")
		public UiWebRtcPublishingSettings getSettings() {
			return settings;
		}

	}

	public static class UnPublishCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UnPublishCommand() {
			// default constructor for Jackson
		}

		public UnPublishCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class SetMicrophoneMutedCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean microphoneMuted;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMicrophoneMutedCommand() {
			// default constructor for Jackson
		}

		public SetMicrophoneMutedCommand(String componentId, boolean microphoneMuted) {
			this.componentId = componentId;
			this.microphoneMuted = microphoneMuted;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("microphoneMuted=" + microphoneMuted)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("microphoneMuted")
		public boolean getMicrophoneMuted() {
			return microphoneMuted;
		}

	}

	public static class SetBackgroundImageUrlCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String backgroundImageUrl;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetBackgroundImageUrlCommand() {
			// default constructor for Jackson
		}

		public SetBackgroundImageUrlCommand(String componentId, String backgroundImageUrl) {
			this.componentId = componentId;
			this.backgroundImageUrl = backgroundImageUrl;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("backgroundImageUrl=" + backgroundImageUrl)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("backgroundImageUrl")
		public String getBackgroundImageUrl() {
			return backgroundImageUrl;
		}

	}

	public static class IsChromeExtensionInstalledCommand implements UiCommand<Boolean> {


		public IsChromeExtensionInstalledCommand() {
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.toString();
		}


		public String getComponentId() {
			return null;
		}

	}




}