package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiImageField extends UiField implements UiObject {


	protected String width;
	protected String height;
	protected UiBorder border;
	protected UiShadow shadow;
	protected UiImageSizing imageSizing = UiImageSizing.CONTAIN;
	protected String backgroundColor = "transparent";

	public UiImageField() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_IMAGE_FIELD;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("attributesBySelector=" + attributesBySelector).append(", ")
				.append("editingMode=" + editingMode).append(", ")
				.append("value=" + value).append(", ")
				.append("width=" + width).append(", ")
				.append("height=" + height).append(", ")
				.append("imageSizing=" + imageSizing).append(", ")
				.append("backgroundColor=" + backgroundColor).append(", ")
				.append(fieldMessages != null ? "fieldMessages={" + fieldMessages.toString() + "}" : "").append(", ")
				.append(border != null ? "border={" + border.toString() + "}" : "").append(", ")
				.append(shadow != null ? "shadow={" + shadow.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("width")
	public String getWidth() {
		return width;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("height")
	public String getHeight() {
		return height;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("border")
	public UiBorder getBorder() {
		return border;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("shadow")
	public UiShadow getShadow() {
		return shadow;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("imageSizing")
	public UiImageSizing getImageSizing() {
		return imageSizing;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
	public String getBackgroundColor() {
		return backgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiImageField setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiImageField setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiImageField setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiImageField setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiImageField setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("attributesBySelector")
	public UiImageField setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
		this.attributesBySelector = attributesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("editingMode")
	public UiImageField setEditingMode(UiFieldEditingMode editingMode) {
		this.editingMode = editingMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("value")
	public UiImageField setValue(Object value) {
		this.value = value;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("fieldMessages")
	public UiImageField setFieldMessages(List<UiFieldMessage> fieldMessages) {
		this.fieldMessages = fieldMessages;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("width")
	public UiImageField setWidth(String width) {
		this.width = width;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("height")
	public UiImageField setHeight(String height) {
		this.height = height;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("border")
	public UiImageField setBorder(UiBorder border) {
		this.border = border;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("shadow")
	public UiImageField setShadow(UiShadow shadow) {
		this.shadow = shadow;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("imageSizing")
	public UiImageField setImageSizing(UiImageSizing imageSizing) {
		this.imageSizing = imageSizing;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundColor")
	public UiImageField setBackgroundColor(String backgroundColor) {
		this.backgroundColor = backgroundColor;
		return this;
	}


	public static class UpdateCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiImageField config;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UpdateCommand() {
			// default constructor for Jackson
		}

		public UpdateCommand(String componentId, UiImageField config) {
			this.componentId = componentId;
			this.config = config;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(config != null ? "config={" + config.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("config")
		public UiImageField getConfig() {
			return config;
		}

	}




}