package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiPictureChooser extends UiField implements UiObject {


	protected String uploadUrl = "/upload";
	protected long maxFileSize = 5000000;
	protected String fileTooLargeMessage = "File too large!";
	protected String uploadErrorMessage = "Error while transmitting file...";
	protected String browseButtonIcon;
	protected String deleteButtonIcon;
	protected int imageDisplayWidth;
	protected int imageDisplayHeight;
	protected UiFileItem fileItem;

	public UiPictureChooser() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_PICTURE_CHOOSER;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("attributesBySelector=" + attributesBySelector).append(", ")
				.append("editingMode=" + editingMode).append(", ")
				.append("value=" + value).append(", ")
				.append("uploadUrl=" + uploadUrl).append(", ")
				.append("maxFileSize=" + maxFileSize).append(", ")
				.append("fileTooLargeMessage=" + fileTooLargeMessage).append(", ")
				.append("uploadErrorMessage=" + uploadErrorMessage).append(", ")
				.append("browseButtonIcon=" + browseButtonIcon).append(", ")
				.append("deleteButtonIcon=" + deleteButtonIcon).append(", ")
				.append("imageDisplayWidth=" + imageDisplayWidth).append(", ")
				.append("imageDisplayHeight=" + imageDisplayHeight).append(", ")
				.append(fieldMessages != null ? "fieldMessages={" + fieldMessages.toString() + "}" : "").append(", ")
				.append(fileItem != null ? "fileItem={" + fileItem.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("uploadUrl")
	public String getUploadUrl() {
		return uploadUrl;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("maxFileSize")
	public long getMaxFileSize() {
		return maxFileSize;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("fileTooLargeMessage")
	public String getFileTooLargeMessage() {
		return fileTooLargeMessage;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("uploadErrorMessage")
	public String getUploadErrorMessage() {
		return uploadErrorMessage;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("browseButtonIcon")
	public String getBrowseButtonIcon() {
		return browseButtonIcon;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("deleteButtonIcon")
	public String getDeleteButtonIcon() {
		return deleteButtonIcon;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("imageDisplayWidth")
	public int getImageDisplayWidth() {
		return imageDisplayWidth;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("imageDisplayHeight")
	public int getImageDisplayHeight() {
		return imageDisplayHeight;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("fileItem")
	public UiFileItem getFileItem() {
		return fileItem;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiPictureChooser setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiPictureChooser setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiPictureChooser setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiPictureChooser setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiPictureChooser setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("attributesBySelector")
	public UiPictureChooser setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
		this.attributesBySelector = attributesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("editingMode")
	public UiPictureChooser setEditingMode(UiFieldEditingMode editingMode) {
		this.editingMode = editingMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("value")
	public UiPictureChooser setValue(Object value) {
		this.value = value;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("fieldMessages")
	public UiPictureChooser setFieldMessages(List<UiFieldMessage> fieldMessages) {
		this.fieldMessages = fieldMessages;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("uploadUrl")
	public UiPictureChooser setUploadUrl(String uploadUrl) {
		this.uploadUrl = uploadUrl;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("maxFileSize")
	public UiPictureChooser setMaxFileSize(long maxFileSize) {
		this.maxFileSize = maxFileSize;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("fileTooLargeMessage")
	public UiPictureChooser setFileTooLargeMessage(String fileTooLargeMessage) {
		this.fileTooLargeMessage = fileTooLargeMessage;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("uploadErrorMessage")
	public UiPictureChooser setUploadErrorMessage(String uploadErrorMessage) {
		this.uploadErrorMessage = uploadErrorMessage;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("browseButtonIcon")
	public UiPictureChooser setBrowseButtonIcon(String browseButtonIcon) {
		this.browseButtonIcon = browseButtonIcon;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("deleteButtonIcon")
	public UiPictureChooser setDeleteButtonIcon(String deleteButtonIcon) {
		this.deleteButtonIcon = deleteButtonIcon;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("imageDisplayWidth")
	public UiPictureChooser setImageDisplayWidth(int imageDisplayWidth) {
		this.imageDisplayWidth = imageDisplayWidth;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("imageDisplayHeight")
	public UiPictureChooser setImageDisplayHeight(int imageDisplayHeight) {
		this.imageDisplayHeight = imageDisplayHeight;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("fileItem")
	public UiPictureChooser setFileItem(UiFileItem fileItem) {
		this.fileItem = fileItem;
		return this;
	}

	public static class UploadInitiatedByUserEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileName;
		protected String mimeType;
		protected long sizeInBytes;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadInitiatedByUserEvent() {
			// default constructor for Jackson
		}

		public UploadInitiatedByUserEvent(String componentId, String fileName, String mimeType, long sizeInBytes) {
			this.componentId = componentId;
			this.fileName = fileName;
			this.mimeType = mimeType;
			this.sizeInBytes = sizeInBytes;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_PICTURE_CHOOSER_UPLOAD_INITIATED_BY_USER;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileName=" + fileName).append(", ")
					.append("mimeType=" + mimeType).append(", ")
					.append("sizeInBytes=" + sizeInBytes)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileName")
		public String getFileName() {
			return fileName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mimeType")
		public String getMimeType() {
			return mimeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizeInBytes")
		public long getSizeInBytes() {
			return sizeInBytes;
		}

	}

	public static class UploadTooLargeEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileName;
		protected String mimeType;
		protected long sizeInBytes;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadTooLargeEvent() {
			// default constructor for Jackson
		}

		public UploadTooLargeEvent(String componentId, String fileName, String mimeType, long sizeInBytes) {
			this.componentId = componentId;
			this.fileName = fileName;
			this.mimeType = mimeType;
			this.sizeInBytes = sizeInBytes;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_PICTURE_CHOOSER_UPLOAD_TOO_LARGE;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileName=" + fileName).append(", ")
					.append("mimeType=" + mimeType).append(", ")
					.append("sizeInBytes=" + sizeInBytes)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileName")
		public String getFileName() {
			return fileName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mimeType")
		public String getMimeType() {
			return mimeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizeInBytes")
		public long getSizeInBytes() {
			return sizeInBytes;
		}

	}

	public static class UploadStartedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileName;
		protected String mimeType;
		protected long sizeInBytes;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadStartedEvent() {
			// default constructor for Jackson
		}

		public UploadStartedEvent(String componentId, String fileName, String mimeType, long sizeInBytes) {
			this.componentId = componentId;
			this.fileName = fileName;
			this.mimeType = mimeType;
			this.sizeInBytes = sizeInBytes;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_PICTURE_CHOOSER_UPLOAD_STARTED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileName=" + fileName).append(", ")
					.append("mimeType=" + mimeType).append(", ")
					.append("sizeInBytes=" + sizeInBytes)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileName")
		public String getFileName() {
			return fileName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mimeType")
		public String getMimeType() {
			return mimeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizeInBytes")
		public long getSizeInBytes() {
			return sizeInBytes;
		}

	}

	public static class UploadCanceledEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileName;
		protected String mimeType;
		protected long sizeInBytes;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadCanceledEvent() {
			// default constructor for Jackson
		}

		public UploadCanceledEvent(String componentId, String fileName, String mimeType, long sizeInBytes) {
			this.componentId = componentId;
			this.fileName = fileName;
			this.mimeType = mimeType;
			this.sizeInBytes = sizeInBytes;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_PICTURE_CHOOSER_UPLOAD_CANCELED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileName=" + fileName).append(", ")
					.append("mimeType=" + mimeType).append(", ")
					.append("sizeInBytes=" + sizeInBytes)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileName")
		public String getFileName() {
			return fileName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mimeType")
		public String getMimeType() {
			return mimeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizeInBytes")
		public long getSizeInBytes() {
			return sizeInBytes;
		}

	}

	public static class UploadFailedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileName;
		protected String mimeType;
		protected long sizeInBytes;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadFailedEvent() {
			// default constructor for Jackson
		}

		public UploadFailedEvent(String componentId, String fileName, String mimeType, long sizeInBytes) {
			this.componentId = componentId;
			this.fileName = fileName;
			this.mimeType = mimeType;
			this.sizeInBytes = sizeInBytes;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_PICTURE_CHOOSER_UPLOAD_FAILED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileName=" + fileName).append(", ")
					.append("mimeType=" + mimeType).append(", ")
					.append("sizeInBytes=" + sizeInBytes)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileName")
		public String getFileName() {
			return fileName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mimeType")
		public String getMimeType() {
			return mimeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizeInBytes")
		public long getSizeInBytes() {
			return sizeInBytes;
		}

	}

	public static class UploadSuccessfulEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileName;
		protected String mimeType;
		protected long sizeInBytes;
		protected String uploadedFileUuid;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadSuccessfulEvent() {
			// default constructor for Jackson
		}

		public UploadSuccessfulEvent(String componentId, String fileName, String mimeType, long sizeInBytes, String uploadedFileUuid) {
			this.componentId = componentId;
			this.fileName = fileName;
			this.mimeType = mimeType;
			this.sizeInBytes = sizeInBytes;
			this.uploadedFileUuid = uploadedFileUuid;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_PICTURE_CHOOSER_UPLOAD_SUCCESSFUL;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileName=" + fileName).append(", ")
					.append("mimeType=" + mimeType).append(", ")
					.append("sizeInBytes=" + sizeInBytes).append(", ")
					.append("uploadedFileUuid=" + uploadedFileUuid)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileName")
		public String getFileName() {
			return fileName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mimeType")
		public String getMimeType() {
			return mimeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizeInBytes")
		public long getSizeInBytes() {
			return sizeInBytes;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("uploadedFileUuid")
		public String getUploadedFileUuid() {
			return uploadedFileUuid;
		}

	}

	public static class SetBrowseButtonIconCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String browseButtonIcon;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetBrowseButtonIconCommand() {
			// default constructor for Jackson
		}

		public SetBrowseButtonIconCommand(String componentId, String browseButtonIcon) {
			this.componentId = componentId;
			this.browseButtonIcon = browseButtonIcon;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("browseButtonIcon=" + browseButtonIcon)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("browseButtonIcon")
		public String getBrowseButtonIcon() {
			return browseButtonIcon;
		}

	}

	public static class SetUploadUrlCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String uploadUrl;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetUploadUrlCommand() {
			// default constructor for Jackson
		}

		public SetUploadUrlCommand(String componentId, String uploadUrl) {
			this.componentId = componentId;
			this.uploadUrl = uploadUrl;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("uploadUrl=" + uploadUrl)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("uploadUrl")
		public String getUploadUrl() {
			return uploadUrl;
		}

	}

	public static class SetMaxFileSizeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected long maxFileSize;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMaxFileSizeCommand() {
			// default constructor for Jackson
		}

		public SetMaxFileSizeCommand(String componentId, long maxFileSize) {
			this.componentId = componentId;
			this.maxFileSize = maxFileSize;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("maxFileSize=" + maxFileSize)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("maxFileSize")
		public long getMaxFileSize() {
			return maxFileSize;
		}

	}

	public static class SetFileTooLargeMessageCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String fileTooLargeMessage;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetFileTooLargeMessageCommand() {
			// default constructor for Jackson
		}

		public SetFileTooLargeMessageCommand(String componentId, String fileTooLargeMessage) {
			this.componentId = componentId;
			this.fileTooLargeMessage = fileTooLargeMessage;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileTooLargeMessage=" + fileTooLargeMessage)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileTooLargeMessage")
		public String getFileTooLargeMessage() {
			return fileTooLargeMessage;
		}

	}

	public static class SetUploadErrorMessageCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String uploadErrorMessage;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetUploadErrorMessageCommand() {
			// default constructor for Jackson
		}

		public SetUploadErrorMessageCommand(String componentId, String uploadErrorMessage) {
			this.componentId = componentId;
			this.uploadErrorMessage = uploadErrorMessage;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("uploadErrorMessage=" + uploadErrorMessage)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("uploadErrorMessage")
		public String getUploadErrorMessage() {
			return uploadErrorMessage;
		}

	}




}