package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiTreeGraph extends UiComponent implements UiObject {


	protected List<UiTreeGraphNode> nodes;
	protected String backgroundColor = "rgba(0, 0, 0, 0)";
	protected float zoomFactor = 1;
	protected boolean compact;
	protected int verticalLayerGap;
	protected int sideListIndent;
	protected int sideListVerticalGap;
	protected int horizontalSiblingGap;
	protected int horizontalNonSignlingGap;

	public UiTreeGraph() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_TREE_GRAPH;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("attributesBySelector=" + attributesBySelector).append(", ")
				.append("backgroundColor=" + backgroundColor).append(", ")
				.append("zoomFactor=" + zoomFactor).append(", ")
				.append("compact=" + compact).append(", ")
				.append("verticalLayerGap=" + verticalLayerGap).append(", ")
				.append("sideListIndent=" + sideListIndent).append(", ")
				.append("sideListVerticalGap=" + sideListVerticalGap).append(", ")
				.append("horizontalSiblingGap=" + horizontalSiblingGap).append(", ")
				.append("horizontalNonSignlingGap=" + horizontalNonSignlingGap).append(", ")
				.append(nodes != null ? "nodes={" + nodes.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("nodes")
	public List<UiTreeGraphNode> getNodes() {
		return nodes;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
	public String getBackgroundColor() {
		return backgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("zoomFactor")
	public float getZoomFactor() {
		return zoomFactor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("compact")
	public boolean getCompact() {
		return compact;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("verticalLayerGap")
	public int getVerticalLayerGap() {
		return verticalLayerGap;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("sideListIndent")
	public int getSideListIndent() {
		return sideListIndent;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("sideListVerticalGap")
	public int getSideListVerticalGap() {
		return sideListVerticalGap;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("horizontalSiblingGap")
	public int getHorizontalSiblingGap() {
		return horizontalSiblingGap;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("horizontalNonSignlingGap")
	public int getHorizontalNonSignlingGap() {
		return horizontalNonSignlingGap;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiTreeGraph setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiTreeGraph setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiTreeGraph setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiTreeGraph setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiTreeGraph setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("attributesBySelector")
	public UiTreeGraph setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
		this.attributesBySelector = attributesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("nodes")
	public UiTreeGraph setNodes(List<UiTreeGraphNode> nodes) {
		this.nodes = nodes;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundColor")
	public UiTreeGraph setBackgroundColor(String backgroundColor) {
		this.backgroundColor = backgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("zoomFactor")
	public UiTreeGraph setZoomFactor(float zoomFactor) {
		this.zoomFactor = zoomFactor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("compact")
	public UiTreeGraph setCompact(boolean compact) {
		this.compact = compact;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("verticalLayerGap")
	public UiTreeGraph setVerticalLayerGap(int verticalLayerGap) {
		this.verticalLayerGap = verticalLayerGap;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("sideListIndent")
	public UiTreeGraph setSideListIndent(int sideListIndent) {
		this.sideListIndent = sideListIndent;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("sideListVerticalGap")
	public UiTreeGraph setSideListVerticalGap(int sideListVerticalGap) {
		this.sideListVerticalGap = sideListVerticalGap;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("horizontalSiblingGap")
	public UiTreeGraph setHorizontalSiblingGap(int horizontalSiblingGap) {
		this.horizontalSiblingGap = horizontalSiblingGap;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("horizontalNonSignlingGap")
	public UiTreeGraph setHorizontalNonSignlingGap(int horizontalNonSignlingGap) {
		this.horizontalNonSignlingGap = horizontalNonSignlingGap;
		return this;
	}

	public static class NodeClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String nodeId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public NodeClickedEvent() {
			// default constructor for Jackson
		}

		public NodeClickedEvent(String componentId, String nodeId) {
			this.componentId = componentId;
			this.nodeId = nodeId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TREE_GRAPH_NODE_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("nodeId=" + nodeId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("nodeId")
		public String getNodeId() {
			return nodeId;
		}

	}

	public static class NodeExpandedOrCollapsedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String nodeId;
		protected boolean expanded;
		protected boolean lazyLoad;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public NodeExpandedOrCollapsedEvent() {
			// default constructor for Jackson
		}

		public NodeExpandedOrCollapsedEvent(String componentId, String nodeId, boolean expanded, boolean lazyLoad) {
			this.componentId = componentId;
			this.nodeId = nodeId;
			this.expanded = expanded;
			this.lazyLoad = lazyLoad;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TREE_GRAPH_NODE_EXPANDED_OR_COLLAPSED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("nodeId=" + nodeId).append(", ")
					.append("expanded=" + expanded).append(", ")
					.append("lazyLoad=" + lazyLoad)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("nodeId")
		public String getNodeId() {
			return nodeId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("expanded")
		public boolean getExpanded() {
			return expanded;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("lazyLoad")
		public boolean getLazyLoad() {
			return lazyLoad;
		}

	}

	public static class ParentExpandedOrCollapsedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String nodeId;
		protected boolean expanded;
		protected boolean lazyLoad;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ParentExpandedOrCollapsedEvent() {
			// default constructor for Jackson
		}

		public ParentExpandedOrCollapsedEvent(String componentId, String nodeId, boolean expanded, boolean lazyLoad) {
			this.componentId = componentId;
			this.nodeId = nodeId;
			this.expanded = expanded;
			this.lazyLoad = lazyLoad;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TREE_GRAPH_PARENT_EXPANDED_OR_COLLAPSED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("nodeId=" + nodeId).append(", ")
					.append("expanded=" + expanded).append(", ")
					.append("lazyLoad=" + lazyLoad)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("nodeId")
		public String getNodeId() {
			return nodeId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("expanded")
		public boolean getExpanded() {
			return expanded;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("lazyLoad")
		public boolean getLazyLoad() {
			return lazyLoad;
		}

	}

	public static class SideListExpandedOrCollapsedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String nodeId;
		protected boolean expanded;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SideListExpandedOrCollapsedEvent() {
			// default constructor for Jackson
		}

		public SideListExpandedOrCollapsedEvent(String componentId, String nodeId, boolean expanded) {
			this.componentId = componentId;
			this.nodeId = nodeId;
			this.expanded = expanded;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TREE_GRAPH_SIDE_LIST_EXPANDED_OR_COLLAPSED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("nodeId=" + nodeId).append(", ")
					.append("expanded=" + expanded)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("nodeId")
		public String getNodeId() {
			return nodeId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("expanded")
		public boolean getExpanded() {
			return expanded;
		}

	}

	public static class UpdateCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiTreeGraph config;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UpdateCommand() {
			// default constructor for Jackson
		}

		public UpdateCommand(String componentId, UiTreeGraph config) {
			this.componentId = componentId;
			this.config = config;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(config != null ? "config={" + config.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("config")
		public UiTreeGraph getConfig() {
			return config;
		}

	}

	public static class SetZoomFactorCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected float zoomFactor;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetZoomFactorCommand() {
			// default constructor for Jackson
		}

		public SetZoomFactorCommand(String componentId, float zoomFactor) {
			this.componentId = componentId;
			this.zoomFactor = zoomFactor;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("zoomFactor=" + zoomFactor)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("zoomFactor")
		public float getZoomFactor() {
			return zoomFactor;
		}

	}

	public static class SetNodesCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<UiTreeGraphNode> nodes;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetNodesCommand() {
			// default constructor for Jackson
		}

		public SetNodesCommand(String componentId, List<UiTreeGraphNode> nodes) {
			this.componentId = componentId;
			this.nodes = nodes;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(nodes != null ? "nodes={" + nodes.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("nodes")
		public List<UiTreeGraphNode> getNodes() {
			return nodes;
		}

	}

	public static class AddNodeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiTreeGraphNode node;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddNodeCommand() {
			// default constructor for Jackson
		}

		public AddNodeCommand(String componentId, UiTreeGraphNode node) {
			this.componentId = componentId;
			this.node = node;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(node != null ? "node={" + node.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("node")
		public UiTreeGraphNode getNode() {
			return node;
		}

	}

	public static class RemoveNodeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String nodeId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveNodeCommand() {
			// default constructor for Jackson
		}

		public RemoveNodeCommand(String componentId, String nodeId) {
			this.componentId = componentId;
			this.nodeId = nodeId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("nodeId=" + nodeId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("nodeId")
		public String getNodeId() {
			return nodeId;
		}

	}

	public static class SetNodeExpandedCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String nodeId;
		protected boolean expanded;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetNodeExpandedCommand() {
			// default constructor for Jackson
		}

		public SetNodeExpandedCommand(String componentId, String nodeId, boolean expanded) {
			this.componentId = componentId;
			this.nodeId = nodeId;
			this.expanded = expanded;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("nodeId=" + nodeId).append(", ")
					.append("expanded=" + expanded)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("nodeId")
		public String getNodeId() {
			return nodeId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("expanded")
		public boolean getExpanded() {
			return expanded;
		}

	}

	public static class UpdateNodeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiTreeGraphNode node;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UpdateNodeCommand() {
			// default constructor for Jackson
		}

		public UpdateNodeCommand(String componentId, UiTreeGraphNode node) {
			this.componentId = componentId;
			this.node = node;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(node != null ? "node={" + node.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("node")
		public UiTreeGraphNode getNode() {
			return node;
		}

	}

	public static class MoveToRootNodeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public MoveToRootNodeCommand() {
			// default constructor for Jackson
		}

		public MoveToRootNodeCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class MoveToNodeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String nodeId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public MoveToNodeCommand() {
			// default constructor for Jackson
		}

		public MoveToNodeCommand(String componentId, String nodeId) {
			this.componentId = componentId;
			this.nodeId = nodeId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("nodeId=" + nodeId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("nodeId")
		public String getNodeId() {
			return nodeId;
		}

	}




}