package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiWindow extends UiPanel implements UiObject {


	protected boolean modal = true;
	protected int width = 0;
	protected int height = 0;
	protected String headerBackgroundColor = "rgba(190, 190, 190, .72)";
	protected String modalBackgroundDimmingColor = "rgba(0, 0, 0, .2)";
	protected boolean closeable;
	protected boolean closeOnEscape;
	protected boolean closeOnClickOutside;

	public UiWindow() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_WINDOW;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("attributesBySelector=" + attributesBySelector).append(", ")
				.append("icon=" + icon).append(", ")
				.append("title=" + title).append(", ")
				.append("headerComponentMinimizationPolicy=" + headerComponentMinimizationPolicy).append(", ")
				.append("alwaysShowHeaderFieldIcons=" + alwaysShowHeaderFieldIcons).append(", ")
				.append("hideTitleBar=" + hideTitleBar).append(", ")
				.append("stretchContent=" + stretchContent).append(", ")
				.append("padding=" + padding).append(", ")
				.append("windowButtons=" + windowButtons).append(", ")
				.append("modal=" + modal).append(", ")
				.append("width=" + width).append(", ")
				.append("height=" + height).append(", ")
				.append("headerBackgroundColor=" + headerBackgroundColor).append(", ")
				.append("modalBackgroundDimmingColor=" + modalBackgroundDimmingColor).append(", ")
				.append("closeable=" + closeable).append(", ")
				.append("closeOnEscape=" + closeOnEscape).append(", ")
				.append("closeOnClickOutside=" + closeOnClickOutside).append(", ")
				.append(leftHeaderField != null ? "leftHeaderField={" + leftHeaderField.toString() + "}" : "").append(", ")
				.append(rightHeaderField != null ? "rightHeaderField={" + rightHeaderField.toString() + "}" : "").append(", ")
				.append(toolbar != null ? "toolbar={" + toolbar.toString() + "}" : "").append(", ")
				.append(content != null ? "content={" + content.toString() + "}" : "").append(", ")
				.append(toolButtons != null ? "toolButtons={" + toolButtons.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("modal")
	public boolean getModal() {
		return modal;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("width")
	public int getWidth() {
		return width;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("height")
	public int getHeight() {
		return height;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("headerBackgroundColor")
	public String getHeaderBackgroundColor() {
		return headerBackgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("modalBackgroundDimmingColor")
	public String getModalBackgroundDimmingColor() {
		return modalBackgroundDimmingColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("closeable")
	public boolean getCloseable() {
		return closeable;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("closeOnEscape")
	public boolean getCloseOnEscape() {
		return closeOnEscape;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("closeOnClickOutside")
	public boolean getCloseOnClickOutside() {
		return closeOnClickOutside;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiWindow setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiWindow setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiWindow setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiWindow setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiWindow setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("attributesBySelector")
	public UiWindow setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
		this.attributesBySelector = attributesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("icon")
	public UiWindow setIcon(String icon) {
		this.icon = icon;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("title")
	public UiWindow setTitle(String title) {
		this.title = title;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("leftHeaderField")
	public UiWindow setLeftHeaderField(UiPanelHeaderField leftHeaderField) {
		this.leftHeaderField = leftHeaderField;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("rightHeaderField")
	public UiWindow setRightHeaderField(UiPanelHeaderField rightHeaderField) {
		this.rightHeaderField = rightHeaderField;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("headerComponentMinimizationPolicy")
	public UiWindow setHeaderComponentMinimizationPolicy(HeaderComponentMinimizationPolicy headerComponentMinimizationPolicy) {
		this.headerComponentMinimizationPolicy = headerComponentMinimizationPolicy;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("alwaysShowHeaderFieldIcons")
	public UiWindow setAlwaysShowHeaderFieldIcons(boolean alwaysShowHeaderFieldIcons) {
		this.alwaysShowHeaderFieldIcons = alwaysShowHeaderFieldIcons;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("hideTitleBar")
	public UiWindow setHideTitleBar(boolean hideTitleBar) {
		this.hideTitleBar = hideTitleBar;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("toolbar")
	public UiWindow setToolbar(UiClientObjectReference toolbar) {
		this.toolbar = toolbar;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("content")
	public UiWindow setContent(UiClientObjectReference content) {
		this.content = content;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stretchContent")
	public UiWindow setStretchContent(boolean stretchContent) {
		this.stretchContent = stretchContent;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("padding")
	public UiWindow setPadding(int padding) {
		this.padding = padding;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("windowButtons")
	public UiWindow setWindowButtons(List<UiWindowButtonType> windowButtons) {
		this.windowButtons = windowButtons;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("toolButtons")
	public UiWindow setToolButtons(List<UiClientObjectReference> toolButtons) {
		this.toolButtons = toolButtons;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("modal")
	public UiWindow setModal(boolean modal) {
		this.modal = modal;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("width")
	public UiWindow setWidth(int width) {
		this.width = width;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("height")
	public UiWindow setHeight(int height) {
		this.height = height;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("headerBackgroundColor")
	public UiWindow setHeaderBackgroundColor(String headerBackgroundColor) {
		this.headerBackgroundColor = headerBackgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("modalBackgroundDimmingColor")
	public UiWindow setModalBackgroundDimmingColor(String modalBackgroundDimmingColor) {
		this.modalBackgroundDimmingColor = modalBackgroundDimmingColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("closeable")
	public UiWindow setCloseable(boolean closeable) {
		this.closeable = closeable;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("closeOnEscape")
	public UiWindow setCloseOnEscape(boolean closeOnEscape) {
		this.closeOnEscape = closeOnEscape;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("closeOnClickOutside")
	public UiWindow setCloseOnClickOutside(boolean closeOnClickOutside) {
		this.closeOnClickOutside = closeOnClickOutside;
		return this;
	}


	public static class ShowCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int animationDuration;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ShowCommand() {
			// default constructor for Jackson
		}

		public ShowCommand(String componentId, int animationDuration) {
			this.componentId = componentId;
			this.animationDuration = animationDuration;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("animationDuration=" + animationDuration)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("animationDuration")
		public int getAnimationDuration() {
			return animationDuration;
		}

	}

	public static class CloseCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int animationDuration;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public CloseCommand() {
			// default constructor for Jackson
		}

		public CloseCommand(String componentId, int animationDuration) {
			this.componentId = componentId;
			this.animationDuration = animationDuration;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("animationDuration=" + animationDuration)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("animationDuration")
		public int getAnimationDuration() {
			return animationDuration;
		}

	}

	public static class SetCloseableCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean closeable;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetCloseableCommand() {
			// default constructor for Jackson
		}

		public SetCloseableCommand(String componentId, boolean closeable) {
			this.componentId = componentId;
			this.closeable = closeable;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("closeable=" + closeable)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("closeable")
		public boolean getCloseable() {
			return closeable;
		}

	}

	public static class SetCloseOnEscapeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean closeOnEscape;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetCloseOnEscapeCommand() {
			// default constructor for Jackson
		}

		public SetCloseOnEscapeCommand(String componentId, boolean closeOnEscape) {
			this.componentId = componentId;
			this.closeOnEscape = closeOnEscape;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("closeOnEscape=" + closeOnEscape)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("closeOnEscape")
		public boolean getCloseOnEscape() {
			return closeOnEscape;
		}

	}

	public static class SetCloseOnClickOutsideCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean closeOnClickOutside;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetCloseOnClickOutsideCommand() {
			// default constructor for Jackson
		}

		public SetCloseOnClickOutsideCommand(String componentId, boolean closeOnClickOutside) {
			this.componentId = componentId;
			this.closeOnClickOutside = closeOnClickOutside;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("closeOnClickOutside=" + closeOnClickOutside)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("closeOnClickOutside")
		public boolean getCloseOnClickOutside() {
			return closeOnClickOutside;
		}

	}

	public static class SetModalCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean modal;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetModalCommand() {
			// default constructor for Jackson
		}

		public SetModalCommand(String componentId, boolean modal) {
			this.componentId = componentId;
			this.modal = modal;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("modal=" + modal)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("modal")
		public boolean getModal() {
			return modal;
		}

	}

	public static class SetModalBackgroundDimmingColorCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String modalBackgroundDimmingColor;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetModalBackgroundDimmingColorCommand() {
			// default constructor for Jackson
		}

		public SetModalBackgroundDimmingColorCommand(String componentId, String modalBackgroundDimmingColor) {
			this.componentId = componentId;
			this.modalBackgroundDimmingColor = modalBackgroundDimmingColor;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("modalBackgroundDimmingColor=" + modalBackgroundDimmingColor)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("modalBackgroundDimmingColor")
		public String getModalBackgroundDimmingColor() {
			return modalBackgroundDimmingColor;
		}

	}

	public static class SetSizeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int width;
		protected int height;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetSizeCommand() {
			// default constructor for Jackson
		}

		public SetSizeCommand(String componentId, int width, int height) {
			this.componentId = componentId;
			this.width = width;
			this.height = height;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("width=" + width).append(", ")
					.append("height=" + height)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("width")
		public int getWidth() {
			return width;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("height")
		public int getHeight() {
			return height;
		}

	}




}