/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiMediaPreloadMode;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiVideoPlayer
extends UiComponent
implements UiObject {
    protected String url;
    protected boolean autoplay;
    protected boolean showControls;
    protected String posterImageUrl;
    protected PosterImageSize posterImageSize = PosterImageSize.CONTAIN;
    protected int sendPlayerProgressEventsEachXSeconds = 1;
    protected String backgroundColor = "rgb(68, 68, 68)";
    protected UiMediaPreloadMode preloadMode;

    @Deprecated
    public UiVideoPlayer() {
    }

    public UiVideoPlayer(String url) {
        this.url = url;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_VIDEO_PLAYER;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + ("url=" + this.url) + ", " + ("autoplay=" + this.autoplay) + ", " + ("showControls=" + this.showControls) + ", " + ("posterImageUrl=" + this.posterImageUrl) + ", " + ("posterImageSize=" + this.posterImageSize) + ", " + ("sendPlayerProgressEventsEachXSeconds=" + this.sendPlayerProgressEventsEachXSeconds) + ", " + ("backgroundColor=" + this.backgroundColor) + ", " + ("preloadMode=" + this.preloadMode);
    }

    @JsonGetter(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonGetter(value="autoplay")
    public boolean getAutoplay() {
        return this.autoplay;
    }

    @JsonGetter(value="showControls")
    public boolean getShowControls() {
        return this.showControls;
    }

    @JsonGetter(value="posterImageUrl")
    public String getPosterImageUrl() {
        return this.posterImageUrl;
    }

    @JsonGetter(value="posterImageSize")
    public PosterImageSize getPosterImageSize() {
        return this.posterImageSize;
    }

    @JsonGetter(value="sendPlayerProgressEventsEachXSeconds")
    public int getSendPlayerProgressEventsEachXSeconds() {
        return this.sendPlayerProgressEventsEachXSeconds;
    }

    @JsonGetter(value="backgroundColor")
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @JsonGetter(value="preloadMode")
    public UiMediaPreloadMode getPreloadMode() {
        return this.preloadMode;
    }

    @Override
    @JsonSetter(value="id")
    public UiVideoPlayer setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiVideoPlayer setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiVideoPlayer setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiVideoPlayer setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiVideoPlayer setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiVideoPlayer setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="autoplay")
    public UiVideoPlayer setAutoplay(boolean autoplay) {
        this.autoplay = autoplay;
        return this;
    }

    @JsonSetter(value="showControls")
    public UiVideoPlayer setShowControls(boolean showControls) {
        this.showControls = showControls;
        return this;
    }

    @JsonSetter(value="posterImageUrl")
    public UiVideoPlayer setPosterImageUrl(String posterImageUrl) {
        this.posterImageUrl = posterImageUrl;
        return this;
    }

    @JsonSetter(value="posterImageSize")
    public UiVideoPlayer setPosterImageSize(PosterImageSize posterImageSize) {
        this.posterImageSize = posterImageSize;
        return this;
    }

    @JsonSetter(value="sendPlayerProgressEventsEachXSeconds")
    public UiVideoPlayer setSendPlayerProgressEventsEachXSeconds(int sendPlayerProgressEventsEachXSeconds) {
        this.sendPlayerProgressEventsEachXSeconds = sendPlayerProgressEventsEachXSeconds;
        return this;
    }

    @JsonSetter(value="backgroundColor")
    public UiVideoPlayer setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @JsonSetter(value="preloadMode")
    public UiVideoPlayer setPreloadMode(UiMediaPreloadMode preloadMode) {
        this.preloadMode = preloadMode;
        return this;
    }

    public static enum PosterImageSize {
        CONTAIN,
        COVER,
        ORIGINAL;


        @JsonValue
        public int jsonValue() {
            return this.ordinal();
        }
    }

    public static class JumpToCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int timeInSeconds;

        @Deprecated
        public JumpToCommand() {
        }

        public JumpToCommand(String componentId, int timeInSeconds) {
            this.componentId = componentId;
            this.timeInSeconds = timeInSeconds;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("timeInSeconds=" + this.timeInSeconds);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="timeInSeconds")
        public int getTimeInSeconds() {
            return this.timeInSeconds;
        }
    }

    public static class PauseCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public PauseCommand() {
        }

        public PauseCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class PlayCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public PlayCommand() {
        }

        public PlayCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class SetAutoplayCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected boolean autoplay;

        @Deprecated
        public SetAutoplayCommand() {
        }

        public SetAutoplayCommand(String componentId, boolean autoplay) {
            this.componentId = componentId;
            this.autoplay = autoplay;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("autoplay=" + this.autoplay);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="autoplay")
        public boolean getAutoplay() {
            return this.autoplay;
        }
    }

    public static class SetPreloadModeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiMediaPreloadMode preloadMode;

        @Deprecated
        public SetPreloadModeCommand() {
        }

        public SetPreloadModeCommand(String componentId, UiMediaPreloadMode preloadMode) {
            this.componentId = componentId;
            this.preloadMode = preloadMode;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("preloadMode=" + this.preloadMode);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="preloadMode")
        public UiMediaPreloadMode getPreloadMode() {
            return this.preloadMode;
        }
    }

    public static class SetUrlCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String url;

        @Deprecated
        public SetUrlCommand() {
        }

        public SetUrlCommand(String componentId, String url) {
            this.componentId = componentId;
            this.url = url;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("url=" + this.url);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="url")
        public String getUrl() {
            return this.url;
        }
    }

    public static class EndedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public EndedEvent() {
        }

        public EndedEvent(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_VIDEO_PLAYER_ENDED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class PlayerProgressEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int positionInSeconds;

        @Deprecated
        public PlayerProgressEvent() {
        }

        public PlayerProgressEvent(String componentId, int positionInSeconds) {
            this.componentId = componentId;
            this.positionInSeconds = positionInSeconds;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_VIDEO_PLAYER_PLAYER_PROGRESS;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("positionInSeconds=" + this.positionInSeconds);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="positionInSeconds")
        public int getPositionInSeconds() {
            return this.positionInSeconds;
        }
    }

    public static class ErrorLoadingEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public ErrorLoadingEvent() {
        }

        public ErrorLoadingEvent(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_VIDEO_PLAYER_ERROR_LOADING;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }
}

