package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiSimpleFileField extends UiField implements UiObject {


	protected String browseButtonIcon;
	protected String browseButtonCaption = "Select";
	protected String uploadUrl = "/upload";
	protected long maxBytesPerFile = 5000000;
	protected String fileTooLargeMessage = "File too large!";
	protected String uploadErrorMessage = "Error while transmitting file...";
	protected int maxFiles = 0;
	protected UiFileFieldDisplayType displayMode = UiFileFieldDisplayType.LIST;
	protected List<UiFileItem> fileItems;

	public UiSimpleFileField() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_SIMPLE_FILE_FIELD;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("classNamesBySelector=" + classNamesBySelector).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("attributesBySelector=" + attributesBySelector).append(", ")
				.append("editingMode=" + editingMode).append(", ")
				.append("value=" + value).append(", ")
				.append("browseButtonIcon=" + browseButtonIcon).append(", ")
				.append("browseButtonCaption=" + browseButtonCaption).append(", ")
				.append("uploadUrl=" + uploadUrl).append(", ")
				.append("maxBytesPerFile=" + maxBytesPerFile).append(", ")
				.append("fileTooLargeMessage=" + fileTooLargeMessage).append(", ")
				.append("uploadErrorMessage=" + uploadErrorMessage).append(", ")
				.append("maxFiles=" + maxFiles).append(", ")
				.append("displayMode=" + displayMode).append(", ")
				.append(fieldMessages != null ? "fieldMessages={" + fieldMessages.toString() + "}" : "").append(", ")
				.append(fileItems != null ? "fileItems={" + fileItems.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("browseButtonIcon")
	public String getBrowseButtonIcon() {
		return browseButtonIcon;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("browseButtonCaption")
	public String getBrowseButtonCaption() {
		return browseButtonCaption;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("uploadUrl")
	public String getUploadUrl() {
		return uploadUrl;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("maxBytesPerFile")
	public long getMaxBytesPerFile() {
		return maxBytesPerFile;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("fileTooLargeMessage")
	public String getFileTooLargeMessage() {
		return fileTooLargeMessage;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("uploadErrorMessage")
	public String getUploadErrorMessage() {
		return uploadErrorMessage;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("maxFiles")
	public int getMaxFiles() {
		return maxFiles;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("displayMode")
	public UiFileFieldDisplayType getDisplayMode() {
		return displayMode;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("fileItems")
	public List<UiFileItem> getFileItems() {
		return fileItems;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiSimpleFileField setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiSimpleFileField setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiSimpleFileField setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiSimpleFileField setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("classNamesBySelector")
	public UiSimpleFileField setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
		this.classNamesBySelector = classNamesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("attributesBySelector")
	public UiSimpleFileField setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
		this.attributesBySelector = attributesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("editingMode")
	public UiSimpleFileField setEditingMode(UiFieldEditingMode editingMode) {
		this.editingMode = editingMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("value")
	public UiSimpleFileField setValue(Object value) {
		this.value = value;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("fieldMessages")
	public UiSimpleFileField setFieldMessages(List<UiFieldMessage> fieldMessages) {
		this.fieldMessages = fieldMessages;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("browseButtonIcon")
	public UiSimpleFileField setBrowseButtonIcon(String browseButtonIcon) {
		this.browseButtonIcon = browseButtonIcon;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("browseButtonCaption")
	public UiSimpleFileField setBrowseButtonCaption(String browseButtonCaption) {
		this.browseButtonCaption = browseButtonCaption;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("uploadUrl")
	public UiSimpleFileField setUploadUrl(String uploadUrl) {
		this.uploadUrl = uploadUrl;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("maxBytesPerFile")
	public UiSimpleFileField setMaxBytesPerFile(long maxBytesPerFile) {
		this.maxBytesPerFile = maxBytesPerFile;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("fileTooLargeMessage")
	public UiSimpleFileField setFileTooLargeMessage(String fileTooLargeMessage) {
		this.fileTooLargeMessage = fileTooLargeMessage;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("uploadErrorMessage")
	public UiSimpleFileField setUploadErrorMessage(String uploadErrorMessage) {
		this.uploadErrorMessage = uploadErrorMessage;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("maxFiles")
	public UiSimpleFileField setMaxFiles(int maxFiles) {
		this.maxFiles = maxFiles;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("displayMode")
	public UiSimpleFileField setDisplayMode(UiFileFieldDisplayType displayMode) {
		this.displayMode = displayMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("fileItems")
	public UiSimpleFileField setFileItems(List<UiFileItem> fileItems) {
		this.fileItems = fileItems;
		return this;
	}

	public static class UploadInitiatedByUserEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String uuid;
		protected String fileName;
		protected String mimeType;
		protected long sizeInBytes;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadInitiatedByUserEvent() {
			// default constructor for Jackson
		}

		public UploadInitiatedByUserEvent(String componentId, String uuid, String fileName, String mimeType, long sizeInBytes) {
			this.componentId = componentId;
			this.uuid = uuid;
			this.fileName = fileName;
			this.mimeType = mimeType;
			this.sizeInBytes = sizeInBytes;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_SIMPLE_FILE_FIELD_UPLOAD_INITIATED_BY_USER;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileName=" + fileName).append(", ")
					.append("uuid=" + uuid).append(", ")
					.append("mimeType=" + mimeType).append(", ")
					.append("sizeInBytes=" + sizeInBytes)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("uuid")
		public String getUuid() {
			return uuid;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileName")
		public String getFileName() {
			return fileName;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mimeType")
		public String getMimeType() {
			return mimeType;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sizeInBytes")
		public long getSizeInBytes() {
			return sizeInBytes;
		}

	}

	public static class UploadTooLargeEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileItemUuid;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadTooLargeEvent() {
			// default constructor for Jackson
		}

		public UploadTooLargeEvent(String componentId, String fileItemUuid) {
			this.componentId = componentId;
			this.fileItemUuid = fileItemUuid;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_SIMPLE_FILE_FIELD_UPLOAD_TOO_LARGE;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileItemUuid=" + fileItemUuid)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileItemUuid")
		public String getFileItemUuid() {
			return fileItemUuid;
		}

	}

	public static class UploadStartedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileItemUuid;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadStartedEvent() {
			// default constructor for Jackson
		}

		public UploadStartedEvent(String componentId, String fileItemUuid) {
			this.componentId = componentId;
			this.fileItemUuid = fileItemUuid;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_SIMPLE_FILE_FIELD_UPLOAD_STARTED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileItemUuid=" + fileItemUuid)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileItemUuid")
		public String getFileItemUuid() {
			return fileItemUuid;
		}

	}

	public static class UploadCanceledEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileItemUuid;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadCanceledEvent() {
			// default constructor for Jackson
		}

		public UploadCanceledEvent(String componentId, String fileItemUuid) {
			this.componentId = componentId;
			this.fileItemUuid = fileItemUuid;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_SIMPLE_FILE_FIELD_UPLOAD_CANCELED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileItemUuid=" + fileItemUuid)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileItemUuid")
		public String getFileItemUuid() {
			return fileItemUuid;
		}

	}

	public static class UploadFailedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileItemUuid;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadFailedEvent() {
			// default constructor for Jackson
		}

		public UploadFailedEvent(String componentId, String fileItemUuid) {
			this.componentId = componentId;
			this.fileItemUuid = fileItemUuid;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_SIMPLE_FILE_FIELD_UPLOAD_FAILED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileItemUuid=" + fileItemUuid)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileItemUuid")
		public String getFileItemUuid() {
			return fileItemUuid;
		}

	}

	public static class UploadSuccessfulEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileItemUuid;
		protected String uploadedFileUuid;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UploadSuccessfulEvent() {
			// default constructor for Jackson
		}

		public UploadSuccessfulEvent(String componentId, String fileItemUuid, String uploadedFileUuid) {
			this.componentId = componentId;
			this.fileItemUuid = fileItemUuid;
			this.uploadedFileUuid = uploadedFileUuid;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_SIMPLE_FILE_FIELD_UPLOAD_SUCCESSFUL;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileItemUuid=" + fileItemUuid).append(", ")
					.append("uploadedFileUuid=" + uploadedFileUuid)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileItemUuid")
		public String getFileItemUuid() {
			return fileItemUuid;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("uploadedFileUuid")
		public String getUploadedFileUuid() {
			return uploadedFileUuid;
		}

	}

	public static class FileItemClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileItemUuid;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public FileItemClickedEvent() {
			// default constructor for Jackson
		}

		public FileItemClickedEvent(String componentId, String fileItemUuid) {
			this.componentId = componentId;
			this.fileItemUuid = fileItemUuid;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_SIMPLE_FILE_FIELD_FILE_ITEM_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileItemUuid=" + fileItemUuid)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileItemUuid")
		public String getFileItemUuid() {
			return fileItemUuid;
		}

	}

	public static class FileItemRemovedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String fileItemUuid;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public FileItemRemovedEvent() {
			// default constructor for Jackson
		}

		public FileItemRemovedEvent(String componentId, String fileItemUuid) {
			this.componentId = componentId;
			this.fileItemUuid = fileItemUuid;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_SIMPLE_FILE_FIELD_FILE_ITEM_REMOVED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileItemUuid=" + fileItemUuid)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileItemUuid")
		public String getFileItemUuid() {
			return fileItemUuid;
		}

	}


	public static class AddFileItemCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiFileItem item;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddFileItemCommand() {
			// default constructor for Jackson
		}

		public AddFileItemCommand(String componentId, UiFileItem item) {
			this.componentId = componentId;
			this.item = item;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(item != null ? "item={" + item.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("item")
		public UiFileItem getItem() {
			return item;
		}

	}

	public static class UpdateFileItemCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiFileItem item;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UpdateFileItemCommand() {
			// default constructor for Jackson
		}

		public UpdateFileItemCommand(String componentId, UiFileItem item) {
			this.componentId = componentId;
			this.item = item;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(item != null ? "item={" + item.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("item")
		public UiFileItem getItem() {
			return item;
		}

	}

	public static class RemoveFileItemCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String itemUuid;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveFileItemCommand() {
			// default constructor for Jackson
		}

		public RemoveFileItemCommand(String componentId, String itemUuid) {
			this.componentId = componentId;
			this.itemUuid = itemUuid;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("itemUuid=" + itemUuid)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("itemUuid")
		public String getItemUuid() {
			return itemUuid;
		}

	}

	public static class SetBrowseButtonIconCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String browseButtonIcon;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetBrowseButtonIconCommand() {
			// default constructor for Jackson
		}

		public SetBrowseButtonIconCommand(String componentId, String browseButtonIcon) {
			this.componentId = componentId;
			this.browseButtonIcon = browseButtonIcon;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("browseButtonIcon=" + browseButtonIcon)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("browseButtonIcon")
		public String getBrowseButtonIcon() {
			return browseButtonIcon;
		}

	}

	public static class SetBrowseButtonCaptionCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String browseButtonCaption;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetBrowseButtonCaptionCommand() {
			// default constructor for Jackson
		}

		public SetBrowseButtonCaptionCommand(String componentId, String browseButtonCaption) {
			this.componentId = componentId;
			this.browseButtonCaption = browseButtonCaption;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("browseButtonCaption=" + browseButtonCaption)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("browseButtonCaption")
		public String getBrowseButtonCaption() {
			return browseButtonCaption;
		}

	}

	public static class SetUploadUrlCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String uploadUrl;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetUploadUrlCommand() {
			// default constructor for Jackson
		}

		public SetUploadUrlCommand(String componentId, String uploadUrl) {
			this.componentId = componentId;
			this.uploadUrl = uploadUrl;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("uploadUrl=" + uploadUrl)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("uploadUrl")
		public String getUploadUrl() {
			return uploadUrl;
		}

	}

	public static class SetMaxBytesPerFileCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected long maxBytesPerFile;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMaxBytesPerFileCommand() {
			// default constructor for Jackson
		}

		public SetMaxBytesPerFileCommand(String componentId, long maxBytesPerFile) {
			this.componentId = componentId;
			this.maxBytesPerFile = maxBytesPerFile;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("maxBytesPerFile=" + maxBytesPerFile)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("maxBytesPerFile")
		public long getMaxBytesPerFile() {
			return maxBytesPerFile;
		}

	}

	public static class SetFileTooLargeMessageCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String fileTooLargeMessage;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetFileTooLargeMessageCommand() {
			// default constructor for Jackson
		}

		public SetFileTooLargeMessageCommand(String componentId, String fileTooLargeMessage) {
			this.componentId = componentId;
			this.fileTooLargeMessage = fileTooLargeMessage;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fileTooLargeMessage=" + fileTooLargeMessage)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fileTooLargeMessage")
		public String getFileTooLargeMessage() {
			return fileTooLargeMessage;
		}

	}

	public static class SetUploadErrorMessageCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String uploadErrorMessage;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetUploadErrorMessageCommand() {
			// default constructor for Jackson
		}

		public SetUploadErrorMessageCommand(String componentId, String uploadErrorMessage) {
			this.componentId = componentId;
			this.uploadErrorMessage = uploadErrorMessage;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("uploadErrorMessage=" + uploadErrorMessage)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("uploadErrorMessage")
		public String getUploadErrorMessage() {
			return uploadErrorMessage;
		}

	}

	public static class SetMaxFilesCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int maxFiles;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMaxFilesCommand() {
			// default constructor for Jackson
		}

		public SetMaxFilesCommand(String componentId, int maxFiles) {
			this.componentId = componentId;
			this.maxFiles = maxFiles;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("maxFiles=" + maxFiles)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("maxFiles")
		public int getMaxFiles() {
			return maxFiles;
		}

	}

	public static class SetDisplayModeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiFileFieldDisplayType displayType;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetDisplayModeCommand() {
			// default constructor for Jackson
		}

		public SetDisplayModeCommand(String componentId, UiFileFieldDisplayType displayType) {
			this.componentId = componentId;
			this.displayType = displayType;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("displayType=" + displayType)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("displayType")
		public UiFileFieldDisplayType getDisplayType() {
			return displayType;
		}

	}

}