/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiBorder;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiFieldEditingMode;
import org.teamapps.dto.UiFieldMessage;
import org.teamapps.dto.UiImageSizing;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiShadow;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiImageField
extends UiField
implements UiObject {
    protected String width;
    protected String height;
    protected UiBorder border;
    protected UiShadow shadow;
    protected UiImageSizing imageSizing = UiImageSizing.CONTAIN;
    protected String backgroundColor = "transparent";

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_IMAGE_FIELD;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + this.classNamesBySelector) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("attributesBySelector=" + this.attributesBySelector) + ", " + ("editingMode=" + this.editingMode) + ", " + ("value=" + this.value) + ", " + ("width=" + this.width) + ", " + ("height=" + this.height) + ", " + ("imageSizing=" + this.imageSizing) + ", " + ("backgroundColor=" + this.backgroundColor) + ", " + (String)(this.fieldMessages != null ? "fieldMessages={" + this.fieldMessages.toString() + "}" : "") + ", " + (String)(this.border != null ? "border={" + this.border.toString() + "}" : "") + ", " + (String)(this.shadow != null ? "shadow={" + this.shadow.toString() + "}" : "");
    }

    @JsonGetter(value="width")
    public String getWidth() {
        return this.width;
    }

    @JsonGetter(value="height")
    public String getHeight() {
        return this.height;
    }

    @JsonGetter(value="border")
    public UiBorder getBorder() {
        return this.border;
    }

    @JsonGetter(value="shadow")
    public UiShadow getShadow() {
        return this.shadow;
    }

    @JsonGetter(value="imageSizing")
    public UiImageSizing getImageSizing() {
        return this.imageSizing;
    }

    @JsonGetter(value="backgroundColor")
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    @JsonSetter(value="id")
    public UiImageField setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiImageField setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiImageField setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiImageField setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiImageField setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiImageField setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="editingMode")
    public UiImageField setEditingMode(UiFieldEditingMode editingMode) {
        this.editingMode = editingMode;
        return this;
    }

    @Override
    @JsonSetter(value="value")
    public UiImageField setValue(Object value) {
        this.value = value;
        return this;
    }

    @Override
    @JsonSetter(value="fieldMessages")
    public UiImageField setFieldMessages(List<UiFieldMessage> fieldMessages) {
        this.fieldMessages = fieldMessages;
        return this;
    }

    @JsonSetter(value="width")
    public UiImageField setWidth(String width) {
        this.width = width;
        return this;
    }

    @JsonSetter(value="height")
    public UiImageField setHeight(String height) {
        this.height = height;
        return this;
    }

    @JsonSetter(value="border")
    public UiImageField setBorder(UiBorder border) {
        this.border = border;
        return this;
    }

    @JsonSetter(value="shadow")
    public UiImageField setShadow(UiShadow shadow) {
        this.shadow = shadow;
        return this;
    }

    @JsonSetter(value="imageSizing")
    public UiImageField setImageSizing(UiImageSizing imageSizing) {
        this.imageSizing = imageSizing;
        return this;
    }

    @JsonSetter(value="backgroundColor")
    public UiImageField setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public static class UpdateCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiImageField config;

        @Deprecated
        public UpdateCommand() {
        }

        public UpdateCommand(String componentId, UiImageField config) {
            this.componentId = componentId;
            this.config = config;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.config != null ? "config={" + this.config.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="config")
        public UiImageField getConfig() {
            return this.config;
        }
    }
}

