/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto.generate;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.STWriter;
import org.teamapps.dto.TeamAppsDtoParser;
import org.teamapps.dto.generate.FileUtils;
import org.teamapps.dto.generate.StGroupFactory;
import org.teamapps.dto.generate.StringTemplatesErrorListener;
import org.teamapps.dto.generate.TeamAppsDtoModel;
import org.teamapps.dto.generate.TeamAppsGeneratorUtil;

public class TeamAppsJavaDtoGenerator {
    private static final Logger logger = LoggerFactory.getLogger(TeamAppsJavaDtoGenerator.class);
    private final STGroupFile stGroup;
    private final String packageName;
    private final TeamAppsDtoModel model;

    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.err.println("Usage: sourceDir targetDir packageName");
            System.exit(1);
        }
        File sourceDir = new File(args[0]);
        File targetDir = new File(args[1]);
        String packageName = args[2];
        List<TeamAppsDtoParser.ClassCollectionContext> classCollections = TeamAppsGeneratorUtil.parseClassCollections(sourceDir);
        new TeamAppsJavaDtoGenerator(packageName, new TeamAppsDtoModel(classCollections)).generate(targetDir);
    }

    public TeamAppsJavaDtoGenerator(TeamAppsDtoModel model) throws IOException {
        this("org.teamapps.dto", model);
    }

    public TeamAppsJavaDtoGenerator(String packageName, TeamAppsDtoModel model) throws IOException {
        this.packageName = packageName;
        this.model = model;
        this.stGroup = StGroupFactory.createStGroup("/org/teamapps/dto/TeamAppsJavaDtoGenerator.stg", this.model);
    }

    public void generate(File targetDir) throws IOException {
        FileUtils.deleteDirectory(targetDir);
        File parentDir = FileUtils.createDirectory(new File(targetDir, this.packageName.replace('.', '/')));
        for (TeamAppsDtoParser.ClassDeclarationContext clazzContext : this.model.getClassDeclarations()) {
            logger.info("Generating class: " + clazzContext.Identifier());
            this.generateClass(clazzContext, new FileWriter(new File(parentDir, clazzContext.Identifier() + ".java")));
            if (!this.model.isReferenceableBaseClass(clazzContext)) continue;
            this.generateClassReference(clazzContext, new FileWriter(new File(parentDir, clazzContext.Identifier() + "Reference.java")));
        }
        for (TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext : this.model.getInterfaceDeclarations()) {
            logger.info("Generating interface: " + interfaceContext.Identifier());
            this.generateInterface(interfaceContext, new FileWriter(new File(parentDir, interfaceContext.Identifier() + ".java")));
        }
        for (TeamAppsDtoParser.EnumDeclarationContext enumContext : this.model.getEnumDeclarations()) {
            this.generateEnum(enumContext, new FileWriter(new File(parentDir, enumContext.Identifier() + ".java")));
        }
        this.generateObjectTypeEnum(new FileWriter(new File(parentDir, "UiObjectType.java")));
        this.generateUiObjectBaseClass(new FileWriter(new File(parentDir, "UiObject.java")));
        this.generateUiEventBaseClass(new FileWriter(new File(parentDir, "UiEvent.java")));
        this.generateEventEnum(new FileWriter(new File(parentDir, "UiEventType.java")));
        this.generateUiQueryBaseClass(new FileWriter(new File(parentDir, "UiQuery.java")));
        this.generateQueryEnum(new FileWriter(new File(parentDir, "UiQueryType.java")));
        this.generateComponentCommandBaseClass(new FileWriter(new File(parentDir, "UiCommand.java")));
        this.generateJacksonTypeIdMaps(new FileWriter(new File(parentDir, "UiObjectJacksonTypeIdMaps.java")));
    }

    void generateClass(TeamAppsDtoParser.ClassDeclarationContext clazzContext, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("class").add("package", (Object)this.packageName).add("c", (Object)clazzContext);
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    void generateClassReference(TeamAppsDtoParser.ClassDeclarationContext clazzContext, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("classReference").add("package", (Object)this.packageName).add("c", (Object)clazzContext);
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    void generateInterface(TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("interface").add("package", (Object)this.packageName).add("i", (Object)interfaceContext);
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    void generateEnum(TeamAppsDtoParser.EnumDeclarationContext enumContext, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("enumClass").add("package", (Object)this.packageName).add("e", (Object)enumContext);
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    void generateUiEventBaseClass(Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("uiEventBaseClass").add("package", (Object)this.packageName).add("allEventDeclarations", this.model.getEventDeclarations());
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    void generateUiQueryBaseClass(Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("uiQueryBaseClass").add("package", (Object)this.packageName).add("allQueryDeclarations", this.model.getQueryDeclarations());
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    void generateComponentCommandBaseClass(Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("uiCommandBaseClass").add("package", (Object)this.packageName).add("allCommandDeclarations", this.model.getCommandDeclarations());
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    void generateObjectTypeEnum(Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("uiObjectTypeEnum").add("package", (Object)this.packageName).add("allClasses", this.model.getClassDeclarations());
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    void generateUiObjectBaseClass(Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("uiObjectBaseClass").add("package", (Object)this.packageName).add("allClasses", this.model.getClassDeclarations());
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    void generateEventEnum(Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("uiEventEnum").add("package", (Object)this.packageName).add("allEventDeclarations", this.model.getEventDeclarations());
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    void generateQueryEnum(Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("uiQueryEnum").add("package", (Object)this.packageName).add("allQueryDeclarations", this.model.getQueryDeclarations());
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    void generateJacksonTypeIdMaps(Writer writer) throws IOException {
        ArrayList<ParserRuleContext> allJsonSerializableClasses = new ArrayList<ParserRuleContext>();
        allJsonSerializableClasses.addAll(this.model.getClassDeclarations());
        allJsonSerializableClasses.addAll(this.model.getInterfaceDeclarations());
        allJsonSerializableClasses.addAll(this.model.getCommandDeclarations());
        allJsonSerializableClasses.addAll(this.model.getEventDeclarations());
        allJsonSerializableClasses.addAll(this.model.getQueryDeclarations());
        ST template = this.stGroup.getInstanceOf("jacksonTypeIdMaps").add("package", (Object)this.packageName).add("allJsonSerializableClasses", allJsonSerializableClasses);
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }
}

