/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto.generate;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.STWriter;
import org.teamapps.dto.TeamAppsDtoParser;
import org.teamapps.dto.generate.FileUtils;
import org.teamapps.dto.generate.StGroupFactory;
import org.teamapps.dto.generate.StringTemplatesErrorListener;
import org.teamapps.dto.generate.TeamAppsDtoModel;
import org.teamapps.dto.generate.TeamAppsGeneratorUtil;

public class TeamAppsTypeScriptGenerator {
    private static final Logger logger = LoggerFactory.getLogger(TeamAppsTypeScriptGenerator.class);
    private final STGroupFile stGroup;
    private final TeamAppsDtoModel model;

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.err.println("Usage: sourceDir targetDir");
            System.exit(1);
        }
        File sourceDir = new File(args[0]);
        File targetDir = new File(args[1]);
        System.out.println("Generating TypeScript from " + sourceDir.getAbsolutePath() + " to " + targetDir.getAbsolutePath());
        new TeamAppsTypeScriptGenerator(new TeamAppsDtoModel(TeamAppsGeneratorUtil.parseClassCollections(sourceDir))).generate(targetDir);
    }

    public TeamAppsTypeScriptGenerator(TeamAppsDtoModel model) {
        this.model = model;
        this.stGroup = StGroupFactory.createStGroup("/org/teamapps/dto/TeamAppsTypeScriptGenerator.stg", this.model);
    }

    public void generate(File targetDir) throws IOException {
        FileUtils.deleteDirectory(targetDir);
        File parentDir = FileUtils.createDirectory(targetDir);
        for (TeamAppsDtoParser.EnumDeclarationContext enumContext : this.model.getEnumDeclarations()) {
            this.generateEnum(enumContext, new FileWriter(new File(parentDir, String.valueOf(enumContext.Identifier()) + ".ts")));
        }
        for (TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext : this.model.getInterfaceDeclarations()) {
            logger.info("Generating typescript definitions for interface: " + String.valueOf(interfaceContext.Identifier()));
            this.generateInterfaceDefinition(interfaceContext, new FileWriter(new File(parentDir, String.valueOf(interfaceContext.Identifier()) + "Config.ts")));
        }
        for (TeamAppsDtoParser.ClassDeclarationContext clazzContext : this.model.getClassDeclarations()) {
            logger.info("Generating typescript definitions for class: " + String.valueOf(clazzContext.Identifier()));
            this.generateClassDefinition(clazzContext, new FileWriter(new File(parentDir, String.valueOf(clazzContext.Identifier()) + "Config.ts")));
        }
        this.generateCommandBaseDefinition(new FileWriter(new File(parentDir, "UiCommand.ts")));
        this.generateCommandExecutor(this.model.getCommandDeclarations(), new FileWriter(new File(parentDir, "CommandExecutor.ts")));
        this.generateEventBaseDefinition(this.model.getEventDeclarations(), new FileWriter(new File(parentDir, "UiEvent.ts")));
        this.generateEventRegistrator(this.model.getAllClassesAndInterfacesWithEvents(), new FileWriter(new File(parentDir, "ComponentEventDescriptors.ts")));
        this.generateQueryBaseDefinition(this.model.getEventDeclarations(), new FileWriter(new File(parentDir, "UiQuery.ts")));
        this.generateQueryFunctionAdder(this.model.getAllClassesAndInterfacesWithQueries(), new FileWriter(new File(parentDir, "QueryFunctionAdder.ts")));
    }

    public void generateEnum(TeamAppsDtoParser.EnumDeclarationContext enumContext, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("enum").add("e", (Object)enumContext);
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    public void generateClassDefinition(TeamAppsDtoParser.ClassDeclarationContext clazzContext, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("classConfigDefinition").add("c", (Object)clazzContext);
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    public void generateInterfaceDefinition(TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("interfaceConfigDefinition").add("c", (Object)interfaceContext);
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    public void generateCommandExecutor(List<TeamAppsDtoParser.CommandDeclarationContext> commandDeclarationContexts, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("commandExecutor").add("name", (Object)"CommandExecutor").add("nonStaticCommands", commandDeclarationContexts.stream().filter(c -> c.staticModifier() == null).collect(Collectors.toList())).add("staticCommands", commandDeclarationContexts.stream().filter(c -> c.staticModifier() != null).collect(Collectors.toList()));
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    public void generateCommandBaseDefinition(Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("uiCommandBaseDefinition");
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    public void generateEventBaseDefinition(List<TeamAppsDtoParser.EventDeclarationContext> eventDeclarations, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("uiEventBaseDefinition");
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    public void generateQueryBaseDefinition(List<TeamAppsDtoParser.EventDeclarationContext> eventDeclarations, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("uiQueryBaseDefinition");
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    public void generateEventRegistrator(List<ParserRuleContext> classAndInterfaceContexts, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("componentEventDescriptors").add("classesAndInterfacesWithEvents", classAndInterfaceContexts);
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    public void generateQueryFunctionAdder(List<ParserRuleContext> classAndInterfaceContexts, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("queryFunctionAdder").add("classesAndInterfacesWithQueries", classAndInterfaceContexts);
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }
}

