/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto.generate;

import java.io.File;
import java.io.IOException;

public class FileUtils {
    public static File createDirectory(File parentDir) {
        boolean successfullyCreatedParentDirs = parentDir.mkdirs();
        if (!successfullyCreatedParentDirs) {
            throw new IllegalStateException("Could not create directories to " + parentDir.getAbsolutePath());
        }
        return parentDir;
    }

    public static boolean deleteDirectory(File directory) {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException(String.valueOf(directory) + " is not a directory!");
            }
            File[] files = directory.listFiles();
            if (null != files) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        FileUtils.deleteDirectory(files[i]);
                        continue;
                    }
                    files[i].delete();
                }
            }
        }
        return directory.delete();
    }

    public File createTempDir() throws IOException {
        File tempDir = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!tempDir.delete() || !tempDir.mkdir()) {
            throw new IOException("Could not create temp dir: " + tempDir.getAbsolutePath());
        }
        return tempDir;
    }
}

