/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto.generate;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.dto.TeamAppsDtoParser;
import org.teamapps.dto.generate.ParserFactory;

public class TeamAppsGeneratorUtil {
    public static List<TeamAppsDtoParser.ClassCollectionContext> parseClassCollections(File sourceDir) throws IOException {
        return Files.find(Paths.get(sourceDir.getPath(), new String[0]), Integer.MAX_VALUE, (filePath, fileAttr) -> fileAttr.isRegularFile() && filePath.toString().endsWith(".dto"), new FileVisitOption[0]).map(dtoFile -> {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(dtoFile.toFile()), StandardCharsets.UTF_8);
                return ParserFactory.createParser(reader).classCollection();
            }
            catch (Exception e1) {
                throw new IllegalArgumentException("Exception while parsing " + String.valueOf(dtoFile) + ": " + e1.getMessage(), e1);
            }
        }).collect(Collectors.toList());
    }
}

