/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto.generate;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.dto.TeamAppsDtoParser;
import org.teamapps.dto.generate.TeamAppsDtoModel;

public class TeamAppsDtoModelValidator {
    private final TeamAppsDtoModel model;

    public TeamAppsDtoModelValidator(TeamAppsDtoModel model) {
        this.model = model;
    }

    public void validate() {
        List<TeamAppsDtoParser.ClassDeclarationContext> classDeclarations = this.model.getClassDeclarations();
        this.validateNoDuplicateClassDeclarations(classDeclarations);
        for (TeamAppsDtoParser.ClassDeclarationContext classDeclaration : classDeclarations) {
            this.validateRequiredPropertiesHaveNoDefaultValue(classDeclaration);
        }
        List<TeamAppsDtoParser.EnumDeclarationContext> enumDeclarations = this.model.getEnumDeclarations();
        this.validateNoDuplicateEnumDeclarations(enumDeclarations);
    }

    private void validateNoDuplicateClassDeclarations(List<TeamAppsDtoParser.ClassDeclarationContext> classDeclarations) {
        Map<String, Long> cardinalities = classDeclarations.stream().collect(Collectors.groupingBy(classDeclarationContext -> classDeclarationContext.Identifier().getText(), Collectors.counting()));
        this.validateNoMultipleEntries(cardinalities);
    }

    private void validateRequiredPropertiesHaveNoDefaultValue(TeamAppsDtoParser.ClassDeclarationContext classDeclaration) {
        for (TeamAppsDtoParser.PropertyDeclarationContext pd : classDeclaration.propertyDeclaration()) {
            if (pd.requiredModifier() == null || pd.defaultValueAssignment() == null) continue;
            throw new IllegalArgumentException("A required property declaration may not have a default value! Erroneous declaration: " + ((TeamAppsDtoParser.ClassDeclarationContext)pd.getParent()).Identifier().getText() + "." + pd.Identifier().getText());
        }
    }

    private void validateNoDuplicateEnumDeclarations(List<TeamAppsDtoParser.EnumDeclarationContext> enumDeclarations) {
        Map<String, Long> cardinalities = enumDeclarations.stream().collect(Collectors.groupingBy(classDeclarationContext -> classDeclarationContext.Identifier().getText(), Collectors.counting()));
        this.validateNoMultipleEntries(cardinalities);
    }

    private void validateNoMultipleEntries(Map<String, Long> cardinalities) {
        String errorMessage = cardinalities.entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(e -> (String)e.getKey() + " is declared " + String.valueOf(e.getValue()) + " times.").collect(Collectors.joining(";\n"));
        if (errorMessage.length() > 0) {
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

