/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto.generate.adapter;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.misc.STNoSuchPropertyException;
import org.teamapps.dto.TeamAppsDtoParser;
import org.teamapps.dto.generate.ParserFactory;
import org.teamapps.dto.generate.TeamAppsDtoModel;
import org.teamapps.dto.generate.adapter.ReferencableEntityModelAdaptor;

public class EventDeclarationContextModelAdaptor
extends ReferencableEntityModelAdaptor<TeamAppsDtoParser.EventDeclarationContext> {
    private static final TeamAppsDtoParser.FormalParameterWithDefaultContext COMPONENT_ID_PARAMETER;
    private final TeamAppsDtoModel astUtil;

    public EventDeclarationContextModelAdaptor(TeamAppsDtoModel astUtil) {
        this.astUtil = astUtil;
    }

    @Override
    public Object getProperty(Interpreter interpreter, ST seld, Object o, Object property, String propertyName) throws STNoSuchPropertyException {
        TeamAppsDtoParser.EventDeclarationContext eventContext = (TeamAppsDtoParser.EventDeclarationContext)((Object)o);
        if ("declaringClass".equals(propertyName)) {
            return TeamAppsDtoModel.getDeclaringClassOrInterface(eventContext);
        }
        if ("typeScriptInterfaceName".equals(propertyName)) {
            return TeamAppsDtoModel.getDeclaringClassOrInterfaceName(eventContext) + "_" + StringUtils.capitalize((String)eventContext.Identifier().getText()) + "Event";
        }
        if ("allProperties".equals(propertyName)) {
            return this.getAllParameters(eventContext);
        }
        if ("allRequiredProperties".equals(propertyName)) {
            return this.getAllParameters(eventContext);
        }
        if ("requiredPropertiesNotImplementedBySuperClasses".equals(propertyName)) {
            return this.getAllParameters(eventContext);
        }
        if ("superClassDecl".equals(propertyName)) {
            return null;
        }
        if ("allSubClasses".equals(propertyName)) {
            return null;
        }
        if ("allNonRequiredProperties".equals(propertyName)) {
            return null;
        }
        if ("simplePropertiesByRelevance".equals(propertyName)) {
            return this.getAllParameters(eventContext).stream().sorted((p1, p2) -> {
                Function<TeamAppsDtoParser.FormalParameterWithDefaultContext, Integer> getPriority = p -> {
                    if (p.Identifier().getText().equals("id")) {
                        return 50;
                    }
                    if (p.Identifier().getText().equals("name")) {
                        return 40;
                    }
                    if (p.Identifier().getText().contains("Id")) {
                        return 30;
                    }
                    if (p.Identifier().getText().contains("Name")) {
                        return 20;
                    }
                    if (this.astUtil.findReferencedClass(p.type()) == null) {
                        return 10;
                    }
                    return 0;
                };
                return getPriority.apply((TeamAppsDtoParser.FormalParameterWithDefaultContext)((Object)p2)) - getPriority.apply((TeamAppsDtoParser.FormalParameterWithDefaultContext)((Object)p1));
            }).collect(Collectors.toList());
        }
        if ("allReferencedClassesAndInterfaces".equals(propertyName)) {
            return this.astUtil.findAllReferencedClassesAndInterfaces(eventContext);
        }
        if ("allReferencedEnums".equals(propertyName)) {
            return this.astUtil.findAllReferencedEnums(eventContext);
        }
        return super.getProperty(interpreter, seld, o, property, propertyName);
    }

    @Override
    protected String getTypeScriptIdentifier(TeamAppsDtoParser.EventDeclarationContext node) {
        return this.getDeclaringTypeScriptFileBaseName(node) + "_" + StringUtils.capitalize((String)node.Identifier().getText()) + "Event";
    }

    @Override
    protected String getJsonIdentifier(TeamAppsDtoParser.EventDeclarationContext node) {
        return TeamAppsDtoModel.getDeclaringClassOrInterfaceName(node) + "." + node.Identifier().getText();
    }

    @Override
    protected String getJavaClassName(TeamAppsDtoParser.EventDeclarationContext node) {
        return TeamAppsDtoModel.getDeclaringClassOrInterfaceName(node) + "." + StringUtils.capitalize((String)node.Identifier().getText()) + "Event";
    }

    private List<TeamAppsDtoParser.FormalParameterWithDefaultContext> getAllParameters(TeamAppsDtoParser.EventDeclarationContext eventContext) {
        ArrayList<TeamAppsDtoParser.FormalParameterWithDefaultContext> allProperties = new ArrayList<TeamAppsDtoParser.FormalParameterWithDefaultContext>(eventContext.formalParameterWithDefault());
        if (eventContext.staticModifier() == null) {
            allProperties.add(0, COMPONENT_ID_PARAMETER);
        }
        return allProperties;
    }

    static {
        try {
            COMPONENT_ID_PARAMETER = ParserFactory.createParser(new StringReader("UiComponentId componentId")).formalParameterWithDefault();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

