/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto.generate.adapter;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.misc.STNoSuchPropertyException;
import org.teamapps.dto.TeamAppsDtoParser;
import org.teamapps.dto.generate.ParserFactory;
import org.teamapps.dto.generate.TeamAppsDtoModel;
import org.teamapps.dto.generate.adapter.ReferencableEntityModelAdaptor;
import org.teamapps.dto.generate.adapter.TypeContextModelAdaptor;

public class CommandDeclarationContextModelAdaptor
extends ReferencableEntityModelAdaptor<TeamAppsDtoParser.CommandDeclarationContext> {
    private static final TeamAppsDtoParser.FormalParameterWithDefaultContext COMPONENT_ID_PARAMETER;
    private final TeamAppsDtoModel astUtil;

    public CommandDeclarationContextModelAdaptor(TeamAppsDtoModel astUtil) {
        this.astUtil = astUtil;
    }

    @Override
    public Object getProperty(Interpreter interpreter, ST seld, Object o, Object property, String propertyName) throws STNoSuchPropertyException {
        TeamAppsDtoParser.CommandDeclarationContext commandContext = (TeamAppsDtoParser.CommandDeclarationContext)((Object)o);
        if ("declaringClass".equals(propertyName)) {
            return TeamAppsDtoModel.getDeclaringClassOrInterface(commandContext);
        }
        if ("allProperties".equals(propertyName)) {
            return this.getAllParameters(commandContext);
        }
        if ("allRequiredProperties".equals(propertyName)) {
            return this.getAllParameters(commandContext);
        }
        if ("requiredPropertiesNotImplementedBySuperClasses".equals(propertyName)) {
            return this.getAllParameters(commandContext);
        }
        if ("superClassDecl".equals(propertyName)) {
            return null;
        }
        if ("simplePropertiesByRelevance".equals(propertyName)) {
            return this.getAllParameters(commandContext).stream().sorted((p1, p2) -> {
                Function<TeamAppsDtoParser.FormalParameterWithDefaultContext, Integer> getPriority = p -> {
                    if (p.Identifier().getText().equals("id")) {
                        return 50;
                    }
                    if (p.Identifier().getText().equals("name")) {
                        return 40;
                    }
                    if (p.Identifier().getText().contains("Id")) {
                        return 30;
                    }
                    if (p.Identifier().getText().contains("Name")) {
                        return 20;
                    }
                    if (this.astUtil.findReferencedClass(p.type()) == null) {
                        return 10;
                    }
                    return 0;
                };
                return getPriority.apply((TeamAppsDtoParser.FormalParameterWithDefaultContext)((Object)p2)) - getPriority.apply((TeamAppsDtoParser.FormalParameterWithDefaultContext)((Object)p1));
            }).collect(Collectors.toList());
        }
        if ("returnType".equals(propertyName)) {
            if (commandContext.type() != null) {
                if (TypeContextModelAdaptor.PRIMITIVE_TYPE_TO_WRAPPER_TYPE.keySet().contains(commandContext.type().getText())) {
                    return TypeContextModelAdaptor.PRIMITIVE_TYPE_TO_WRAPPER_TYPE.get(commandContext.type().getText());
                }
                return commandContext.type().getText();
            }
            return "Void";
        }
        return super.getProperty(interpreter, seld, o, property, propertyName);
    }

    @Override
    protected String getTypeScriptIdentifier(TeamAppsDtoParser.CommandDeclarationContext node) {
        return this.getDeclaringTypeScriptFileBaseName(node) + "_" + StringUtils.capitalize((String)node.Identifier().getText()) + "Command";
    }

    private List<TeamAppsDtoParser.FormalParameterWithDefaultContext> getAllParameters(TeamAppsDtoParser.CommandDeclarationContext commandContext) {
        ArrayList<TeamAppsDtoParser.FormalParameterWithDefaultContext> allProperties = new ArrayList<TeamAppsDtoParser.FormalParameterWithDefaultContext>(commandContext.formalParameterWithDefault());
        if (commandContext.staticModifier() == null) {
            allProperties.add(0, COMPONENT_ID_PARAMETER);
        }
        return allProperties;
    }

    @Override
    protected String getJsonIdentifier(TeamAppsDtoParser.CommandDeclarationContext node) {
        return TeamAppsDtoModel.getDeclaringClassOrInterfaceName(node) + "." + node.Identifier().getText();
    }

    @Override
    protected String getJavaClassName(TeamAppsDtoParser.CommandDeclarationContext node) {
        return TeamAppsDtoModel.getDeclaringClassOrInterfaceName(node) + "." + StringUtils.capitalize((String)node.Identifier().getText()) + "Command";
    }

    static {
        try {
            COMPONENT_ID_PARAMETER = ParserFactory.createParser(new StringReader("UiComponentId componentId")).formalParameterWithDefault();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

