/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto.generate;

import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.dto.TeamAppsDtoParser;

public class ClassCollectionValidator {
    public static void validate(TeamAppsDtoParser.ClassCollectionContext classCollectionContext) {
        List<TeamAppsDtoParser.ClassDeclarationContext> classDeclarations = ClassCollectionValidator.findClassDeclarations(classCollectionContext.typeDeclaration());
        for (TeamAppsDtoParser.ClassDeclarationContext classDeclaration : classDeclarations) {
            for (TeamAppsDtoParser.PropertyDeclarationContext pd : classDeclaration.propertyDeclaration()) {
                if (pd.requiredModifier() == null || pd.defaultValueAssignment() == null) continue;
                throw new IllegalArgumentException("A required property declaration may not have a default value! Erroneous declaration: " + ((TeamAppsDtoParser.ClassDeclarationContext)pd.getParent()).Identifier().getText() + "." + pd.Identifier().getText());
            }
        }
    }

    private static List<TeamAppsDtoParser.ClassDeclarationContext> findClassDeclarations(List<TeamAppsDtoParser.TypeDeclarationContext> types) {
        return types.stream().filter(typeContext -> typeContext.classDeclaration() != null).map(typeContext -> typeContext.classDeclaration()).collect(Collectors.toList());
    }
}

