/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto.generate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.STWriter;
import org.teamapps.dto.TeamAppsDtoParser;
import org.teamapps.dto.generate.FileUtils;
import org.teamapps.dto.generate.ParserFactory;
import org.teamapps.dto.generate.StGroupFactory;
import org.teamapps.dto.generate.StringTemplatesErrorListener;
import org.teamapps.dto.generate.TeamAppsDtoModel;
import org.teamapps.dto.generate.TeamAppsGeneratorUtil;

public class TeamAppsTypeScriptGenerator {
    private static final Logger logger = LoggerFactory.getLogger(TeamAppsTypeScriptGenerator.class);
    private final STGroupFile stGroup;
    private final TeamAppsDtoModel model;

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.err.println("Usage: sourceDir targetDir");
            System.exit(1);
        }
        File sourceDir = new File(args[0]);
        File targetDir = new File(args[1]);
        List<TeamAppsDtoParser.ClassCollectionContext> classCollections = TeamAppsGeneratorUtil.getFilesInDirectory(sourceDir).stream().map(dtoFile -> {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream((File)dtoFile), "UTF-8");
                return ParserFactory.createParser(reader).classCollection();
            }
            catch (Exception e1) {
                throw new IllegalArgumentException(e1);
            }
        }).collect(Collectors.toList());
        new TeamAppsTypeScriptGenerator(new TeamAppsDtoModel(classCollections)).generate(targetDir);
    }

    public TeamAppsTypeScriptGenerator(TeamAppsDtoModel model) {
        this.model = model;
        this.stGroup = StGroupFactory.createStGroup("/org/teamapps/dto/TeamAppsTypeScriptGenerator.stg", this.model);
    }

    public void generate(File targetDir) throws IOException {
        FileUtils.deleteDirectory(targetDir);
        File parentDir = FileUtils.createDirectory(targetDir);
        for (TeamAppsDtoParser.EnumDeclarationContext enumContext : this.model.getEnumDeclarations()) {
            this.generateEnum(enumContext, new FileWriter(new File(parentDir, enumContext.Identifier() + ".ts")));
        }
        for (TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext : this.model.getInterfaceDeclarations()) {
            logger.info("Generating typescript definitions for interface: " + interfaceContext.Identifier());
            this.generateInterfaceDefinition(interfaceContext, new FileWriter(new File(parentDir, interfaceContext.Identifier() + "Config.ts")));
        }
        for (TeamAppsDtoParser.ClassDeclarationContext clazzContext : this.model.getClassDeclarations()) {
            logger.info("Generating typescript definitions for class: " + clazzContext.Identifier());
            this.generateClassDefinition(clazzContext, new FileWriter(new File(parentDir, clazzContext.Identifier() + "Config.ts")));
        }
        this.generateCommandBaseDefinition(new FileWriter(new File(parentDir, "UiCommand.ts")));
        this.generateCommandExecutor(this.model.getCommandDeclarations(), new FileWriter(new File(parentDir, "CommandExecutor.ts")));
        this.generateEventRegistrator(this.model.getAllClassesAndInterfacesWithEvents(), new FileWriter(new File(parentDir, "EventRegistrator.ts")));
        this.generateEventFactory(this.model.getAllClassesAndInterfacesWithEvents(), this.model.findAllClassesInterfacesAndEnumsReferencedByEvents(), new FileWriter(new File(parentDir, "EventFactory.ts")));
        this.generateSubEventFactory(this.model.getAllClassesAndInterfacesWithSubEvents(), this.model.findAllClassesInterfacesAndEnumsReferencedBySubEvents(), new FileWriter(new File(parentDir, "SubEventFactory.ts")));
        this.generateEventBaseDefinition(this.model.getEventDeclarations(), new FileWriter(new File(parentDir, "UiEvent.ts")));
    }

    public void generateEnum(TeamAppsDtoParser.EnumDeclarationContext enumContext, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("enum").add("e", (Object)enumContext);
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    public void generateClassDefinition(TeamAppsDtoParser.ClassDeclarationContext clazzContext, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("classConfigDefinition").add("c", (Object)clazzContext);
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    public void generateInterfaceDefinition(TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("interfaceConfigDefinition").add("c", (Object)interfaceContext);
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    public void generateCommandExecutor(List<TeamAppsDtoParser.CommandDeclarationContext> commandDeclarationContexts, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("commandExecutor").add("name", (Object)"CommandExecutor").add("nonStaticCommands", commandDeclarationContexts.stream().filter(c -> c.staticModifier() == null).collect(Collectors.toList())).add("staticCommands", commandDeclarationContexts.stream().filter(c -> c.staticModifier() != null).collect(Collectors.toList()));
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    public void generateSubCommandBaseDefinition(Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("uiSubCommandBaseDefinition");
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    public void generateSubCommandExecutor(List<TeamAppsDtoParser.SubCommandDeclarationContext> commandDeclarationContexts, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("commandExecutor").add("name", (Object)"SubCommandExecutor").add("nonStaticCommands", commandDeclarationContexts).add("staticCommands", Collections.emptyList());
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    public void generateEventFactory(List<ParserRuleContext> allClassesAndInterfacesWithEvents, List<ParserRuleContext> allClassesInterfacesAndEnumsReferencedByEvents, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("eventFactory").add("allClassesAndInterfacesWithEvents", allClassesAndInterfacesWithEvents).add("allClassesInterfacesAndEnumsReferencedByEvents", allClassesInterfacesAndEnumsReferencedByEvents);
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    public void generateSubEventFactory(List<ParserRuleContext> allClassesAndInterfacesWithSubEvents, List<ParserRuleContext> allClassesInterfacesAndEnumsReferencedBySubEvents, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("subEventFactory").add("allClassesAndInterfacesWithSubEvents", allClassesAndInterfacesWithSubEvents).add("allClassesInterfacesAndEnumsReferencedBySubEvents", allClassesInterfacesAndEnumsReferencedBySubEvents);
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    public void generateCommandBaseDefinition(Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("uiCommandBaseDefinition");
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    public void generateEventBaseDefinition(List<TeamAppsDtoParser.EventDeclarationContext> eventDeclarations, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("uiEventBaseDefinition").add("eventDeclarations", eventDeclarations);
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    public void generateSubEventBaseDefinition(List<TeamAppsDtoParser.SubEventDeclarationContext> subEventDeclarations, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("uiSubEventBaseDefinition").add("subEventDeclarations", subEventDeclarations);
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    public void generateEventRegistrator(List<ParserRuleContext> classAndInterfaceContexts, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("eventRegistrator").add("classesAndInterfacesWithEvents", classAndInterfaceContexts);
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }

    public void generateSubEventRegistrator(List<ParserRuleContext> classAndInterfaceContexts, Writer writer) throws IOException {
        ST template = this.stGroup.getInstanceOf("subEventRegistrator").add("classesAndInterfacesReferencedForSubEvents", classAndInterfaceContexts);
        AutoIndentWriter out = new AutoIndentWriter(writer);
        template.write((STWriter)out, (STErrorListener)new StringTemplatesErrorListener());
        writer.close();
    }
}

