/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto.generate;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.teamapps.dto.TeamAppsDtoParser;

public class TeamAppsDtoModel {
    private final List<TeamAppsDtoParser.ClassDeclarationContext> classDeclarations = new ArrayList<TeamAppsDtoParser.ClassDeclarationContext>();
    private final List<TeamAppsDtoParser.InterfaceDeclarationContext> interfaceDeclarations = new ArrayList<TeamAppsDtoParser.InterfaceDeclarationContext>();
    private final List<TeamAppsDtoParser.EnumDeclarationContext> enumDeclarations = new ArrayList<TeamAppsDtoParser.EnumDeclarationContext>();
    private final List<TeamAppsDtoParser.EventDeclarationContext> eventDeclarations;
    private final List<TeamAppsDtoParser.CommandDeclarationContext> commandDeclarations;
    private final List<TeamAppsDtoParser.SubEventDeclarationContext> subEventDeclarations;
    private final List<TeamAppsDtoParser.SubCommandDeclarationContext> subCommandDeclarations;
    private final List<ParserRuleContext> classesAndInterfacesReferencedForSubEvents;

    public TeamAppsDtoModel(TeamAppsDtoParser.ClassCollectionContext classCollectionContext) {
        this(Collections.singletonList(classCollectionContext));
    }

    public TeamAppsDtoModel(List<TeamAppsDtoParser.ClassCollectionContext> classCollectionContexts) {
        classCollectionContexts.forEach(classCollectionContext -> {
            List<TeamAppsDtoParser.TypeDeclarationContext> typeDeclarations = classCollectionContext.typeDeclaration();
            this.classDeclarations.addAll(this.extractClassDeclarations(typeDeclarations));
            this.interfaceDeclarations.addAll(this.extractInterfaceDeclarations(typeDeclarations));
            this.enumDeclarations.addAll(this.extractEnumDeclarations(typeDeclarations));
        });
        this.eventDeclarations = this.extractEventDeclarations();
        this.commandDeclarations = this.extractCommandDeclarations();
        this.subEventDeclarations = this.extractSubEventDeclarations();
        this.subCommandDeclarations = this.extractSubCommandDeclarations();
        this.classesAndInterfacesReferencedForSubEvents = this.extractClassesAndInterfacesReferencedForSubEvents();
    }

    private List<TeamAppsDtoParser.ClassDeclarationContext> extractClassDeclarations(List<TeamAppsDtoParser.TypeDeclarationContext> types) {
        return types.stream().filter(typeContext -> typeContext.classDeclaration() != null).map(typeContext -> typeContext.classDeclaration()).collect(Collectors.toList());
    }

    private List<TeamAppsDtoParser.InterfaceDeclarationContext> extractInterfaceDeclarations(List<TeamAppsDtoParser.TypeDeclarationContext> types) {
        return types.stream().filter(typeContext -> typeContext.interfaceDeclaration() != null).map(typeContext -> typeContext.interfaceDeclaration()).collect(Collectors.toList());
    }

    private List<TeamAppsDtoParser.EnumDeclarationContext> extractEnumDeclarations(List<TeamAppsDtoParser.TypeDeclarationContext> types) {
        return types.stream().filter(typeContext -> typeContext.enumDeclaration() != null).map(typeContext -> typeContext.enumDeclaration()).collect(Collectors.toList());
    }

    private List<TeamAppsDtoParser.EventDeclarationContext> extractEventDeclarations() {
        return Stream.concat(this.classDeclarations.stream().flatMap(c -> c.eventDeclaration().stream()), this.interfaceDeclarations.stream().flatMap(i -> i.eventDeclaration().stream())).collect(Collectors.toList());
    }

    private List<TeamAppsDtoParser.CommandDeclarationContext> extractCommandDeclarations() {
        return Stream.concat(this.classDeclarations.stream().flatMap(c -> c.commandDeclaration().stream()), this.interfaceDeclarations.stream().flatMap(i -> i.commandDeclaration().stream())).collect(Collectors.toList());
    }

    private List<TeamAppsDtoParser.SubEventDeclarationContext> extractSubEventDeclarations() {
        return Stream.concat(this.classDeclarations.stream().flatMap(c -> c.subEventDeclaration().stream()), this.interfaceDeclarations.stream().flatMap(i -> i.subEventDeclaration().stream())).collect(Collectors.toList());
    }

    private List<TeamAppsDtoParser.SubCommandDeclarationContext> extractSubCommandDeclarations() {
        return Stream.concat(this.classDeclarations.stream().flatMap(c -> c.subCommandDeclaration().stream()), this.interfaceDeclarations.stream().flatMap(i -> i.subCommandDeclaration().stream())).collect(Collectors.toList());
    }

    private List<ParserRuleContext> extractClassesAndInterfacesReferencedForSubEvents() {
        return this.eventDeclarations.stream().flatMap(ed -> ed.formalParameterWithDefault().stream()).filter(fp -> fp.type().subEventReference() != null).map(fp -> fp.type().subEventReference().typeReference().Identifier().getText()).distinct().map(referencedClassName -> this.findClassOrInterfaceByName((String)referencedClassName)).collect(Collectors.toList());
    }

    public List<TeamAppsDtoParser.ClassDeclarationContext> getClassDeclarations() {
        return this.classDeclarations;
    }

    public List<TeamAppsDtoParser.InterfaceDeclarationContext> getInterfaceDeclarations() {
        return this.interfaceDeclarations;
    }

    public List<TeamAppsDtoParser.EnumDeclarationContext> getEnumDeclarations() {
        return this.enumDeclarations;
    }

    public List<TeamAppsDtoParser.EventDeclarationContext> getEventDeclarations() {
        return this.eventDeclarations;
    }

    public List<TeamAppsDtoParser.CommandDeclarationContext> getCommandDeclarations() {
        return this.commandDeclarations;
    }

    public List<TeamAppsDtoParser.SubEventDeclarationContext> getSubEventDeclarations() {
        return this.subEventDeclarations;
    }

    public List<TeamAppsDtoParser.SubCommandDeclarationContext> getSubCommandDeclarations() {
        return this.subCommandDeclarations;
    }

    public List<ParserRuleContext> getClassesAndInterfacesReferencedForSubEvents() {
        return this.classesAndInterfacesReferencedForSubEvents;
    }

    public TeamAppsDtoParser.ClassDeclarationContext findReferencedClass(TeamAppsDtoParser.TypeContext typeContext) {
        TeamAppsDtoParser.TypeReferenceContext typeReferenceContext = typeContext.typeReference();
        if (typeReferenceContext == null) {
            return null;
        }
        String typeName = typeReferenceContext.Identifier().getText();
        return this.classDeclarations.stream().filter(classDeclaration -> classDeclaration.Identifier().getText().equals(typeName)).findFirst().orElseGet(() -> {
            if (typeReferenceContext.typeArguments() != null && !typeReferenceContext.typeArguments().typeArgument().isEmpty()) {
                return this.findReferencedClass(typeReferenceContext.typeArguments().typeArgument(0).type());
            }
            return null;
        });
    }

    public TeamAppsDtoParser.InterfaceDeclarationContext findReferencedInterface(TeamAppsDtoParser.TypeContext typeContext) {
        TeamAppsDtoParser.TypeReferenceContext typeReferenceContext = typeContext.typeReference();
        if (typeReferenceContext == null) {
            return null;
        }
        String typeName = typeReferenceContext.Identifier().getText();
        return this.interfaceDeclarations.stream().filter(interfaceDeclaration -> interfaceDeclaration.Identifier().getText().equals(typeName)).findFirst().orElseGet(() -> {
            if (typeReferenceContext.typeArguments() != null && !typeReferenceContext.typeArguments().typeArgument().isEmpty()) {
                return this.findReferencedInterface(typeReferenceContext.typeArguments().typeArgument(0).type());
            }
            return null;
        });
    }

    public TeamAppsDtoParser.ClassDeclarationContext findClassByName(String className, boolean throwExceptionIfNotFound) {
        return this.classDeclarations.stream().filter(otherClassDeclarationContext -> otherClassDeclarationContext.Identifier().getText().equals(className)).findFirst().orElseGet(() -> {
            if (throwExceptionIfNotFound) {
                throw new IllegalArgumentException("Could not find interface " + className);
            }
            return null;
        });
    }

    public TeamAppsDtoParser.EnumDeclarationContext findReferencedEnum(TeamAppsDtoParser.TypeContext typeContext) {
        TeamAppsDtoParser.TypeReferenceContext typeRef = typeContext.typeReference();
        if (typeRef == null) {
            return null;
        }
        return this.enumDeclarations.stream().filter(e -> e.Identifier().getText().equals(typeRef.getText())).findFirst().orElseGet(() -> {
            if (typeRef.typeArguments() != null && !typeRef.typeArguments().typeArgument().isEmpty()) {
                return this.findReferencedEnum(typeRef.typeArguments().typeArgument(0).type());
            }
            return null;
        });
    }

    public static <T extends RuleContext> T findAncestorOfType(RuleContext ruleContext, Class<T> ancestorType) {
        while (ruleContext != null) {
            if (!ancestorType.isInstance(ruleContext = ruleContext.getParent())) continue;
            return (T)ruleContext;
        }
        return null;
    }

    public List<TeamAppsDtoParser.ClassDeclarationContext> findAllSuperClasses(TeamAppsDtoParser.ClassDeclarationContext clazzContext) {
        ArrayList<TeamAppsDtoParser.ClassDeclarationContext> superClasses = new ArrayList<TeamAppsDtoParser.ClassDeclarationContext>();
        clazzContext = this.findSuperClass(clazzContext);
        while (clazzContext != null) {
            superClasses.add(clazzContext);
            clazzContext = this.findSuperClass(clazzContext);
        }
        return superClasses;
    }

    public List<TeamAppsDtoParser.ClassDeclarationContext> findSelfAndAllSuperClasses(TeamAppsDtoParser.ClassDeclarationContext clazzContext) {
        List<TeamAppsDtoParser.ClassDeclarationContext> allSuperClasses = this.findAllSuperClasses(clazzContext);
        allSuperClasses.add(0, clazzContext);
        return allSuperClasses;
    }

    public List<TeamAppsDtoParser.ClassDeclarationContext> findAllSubClasses(TeamAppsDtoParser.ClassDeclarationContext clazzContext) {
        return this.classDeclarations.stream().filter(otherClass -> this.findAllSuperClasses((TeamAppsDtoParser.ClassDeclarationContext)((Object)otherClass)).contains((Object)clazzContext)).collect(Collectors.toList());
    }

    public List<TeamAppsDtoParser.ClassDeclarationContext> findAllSubClasses(TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext) {
        return this.classDeclarations.stream().filter(classContext -> this.findAllImplementedInterfaces((TeamAppsDtoParser.ClassDeclarationContext)((Object)classContext)).contains((Object)interfaceContext)).collect(Collectors.toList());
    }

    public List<TeamAppsDtoParser.InterfaceDeclarationContext> findAllSubInterfaces(TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext) {
        return this.interfaceDeclarations.stream().filter(interf -> this.findSuperInterfaces((TeamAppsDtoParser.InterfaceDeclarationContext)((Object)interf)).contains((Object)interfaceContext)).collect(Collectors.toList());
    }

    public List<TeamAppsDtoParser.PropertyDeclarationContext> findAllProperties(TeamAppsDtoParser.ClassDeclarationContext clazzContext) {
        List<TeamAppsDtoParser.ClassDeclarationContext> selfAndAllSuperClasses = this.findSelfAndAllSuperClasses(clazzContext);
        Collections.reverse(selfAndAllSuperClasses);
        return Stream.concat(selfAndAllSuperClasses.stream().flatMap(classContext -> classContext.propertyDeclaration().stream()).filter(this.distinctByKey(property -> property.Identifier().getText())), this.findAllImplementedInterfaces(clazzContext).stream().flatMap(interfaceContext -> interfaceContext.propertyDeclaration().stream()).filter(this.distinctByKey(property -> property.Identifier().getText()))).distinct().collect(Collectors.toList());
    }

    public List<TeamAppsDtoParser.PropertyDeclarationContext> findAllProperties(TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext) {
        return this.findAllSuperInterfacesAndSelf(interfaceContext).stream().flatMap(interf -> interf.propertyDeclaration().stream()).filter(this.distinctByKey(property -> property.Identifier().getText())).collect(Collectors.toList());
    }

    public <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public List<TeamAppsDtoParser.PropertyDeclarationContext> filterRequiredProperties(List<TeamAppsDtoParser.PropertyDeclarationContext> propertyDeclarations, boolean required) {
        return propertyDeclarations.stream().filter(p -> required ^ p.requiredModifier() == null).collect(Collectors.toList());
    }

    public TeamAppsDtoParser.ClassDeclarationContext findSuperClass(TeamAppsDtoParser.ClassDeclarationContext clazzContext) {
        if (clazzContext.superClassDecl() != null) {
            String superClassName = clazzContext.superClassDecl().Identifier().getText();
            TeamAppsDtoParser.ClassDeclarationContext superClass = this.findClassByName(superClassName, true);
            if (superClass == null) {
                throw new IllegalArgumentException("Cannot find super class of " + clazzContext.Identifier().getText() + " with name: " + superClassName);
            }
            return superClass;
        }
        return null;
    }

    public List<TeamAppsDtoParser.InterfaceDeclarationContext> findAllSuperInterfaces(TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext) {
        if (interfaceContext.superInterfaceDecl() != null) {
            List<TeamAppsDtoParser.InterfaceDeclarationContext> superInterfaces = this.findSuperInterfaces(interfaceContext);
            superInterfaces.addAll(superInterfaces.stream().flatMap(si -> this.findAllSuperInterfaces((TeamAppsDtoParser.InterfaceDeclarationContext)((Object)si)).stream()).collect(Collectors.toList()));
            return superInterfaces.stream().distinct().collect(Collectors.toList());
        }
        return new ArrayList<TeamAppsDtoParser.InterfaceDeclarationContext>();
    }

    public List<TeamAppsDtoParser.InterfaceDeclarationContext> findSuperInterfaces(TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext) {
        if (interfaceContext.superInterfaceDecl() != null) {
            return interfaceContext.superInterfaceDecl().classList().Identifier().stream().map(identifier -> identifier.getText()).map(name -> this.findInterfaceByName((String)name, false)).collect(Collectors.toList());
        }
        return new ArrayList<TeamAppsDtoParser.InterfaceDeclarationContext>();
    }

    public List<TeamAppsDtoParser.InterfaceDeclarationContext> findAllImplementedInterfaces(TeamAppsDtoParser.ClassDeclarationContext classContext) {
        return this.findSelfAndAllSuperClasses(classContext).stream().flatMap(clazz -> clazz.implementsDecl() != null ? clazz.implementsDecl().classList().Identifier().stream().map(identifier -> this.findInterfaceByName(identifier.getText(), true)).flatMap(interfaceContext -> this.findAllSuperInterfacesAndSelf((TeamAppsDtoParser.InterfaceDeclarationContext)((Object)((Object)interfaceContext))).stream()) : Stream.empty()).collect(Collectors.toList());
    }

    public List<TeamAppsDtoParser.InterfaceDeclarationContext> getDirectlyImplementedInterfaces(TeamAppsDtoParser.ClassDeclarationContext classContext) {
        if (classContext.implementsDecl() != null) {
            return classContext.implementsDecl().classList().Identifier().stream().map(identifier -> this.findInterfaceByName(identifier.getText(), true)).collect(Collectors.toList());
        }
        return new ArrayList<TeamAppsDtoParser.InterfaceDeclarationContext>();
    }

    public TeamAppsDtoParser.InterfaceDeclarationContext findInterfaceByName(String name, boolean throwExceptionIfNotFound) {
        return this.interfaceDeclarations.stream().filter(interfaceDeclaration -> interfaceDeclaration.Identifier().getText().equals(name)).findAny().orElseGet(() -> {
            if (throwExceptionIfNotFound) {
                throw new IllegalArgumentException("Could not find interface " + name);
            }
            return null;
        });
    }

    public List<TeamAppsDtoParser.ClassDeclarationContext> findAllImplementingClasses(TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext) {
        return this.classDeclarations.stream().filter(clazz -> this.findAllImplementedInterfaces((TeamAppsDtoParser.ClassDeclarationContext)((Object)clazz)).contains((Object)interfaceContext)).collect(Collectors.toList());
    }

    public List<TeamAppsDtoParser.InterfaceDeclarationContext> findAllSuperInterfacesAndSelf(TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext) {
        List<TeamAppsDtoParser.InterfaceDeclarationContext> superInterfacesAndSelf = this.findAllSuperInterfaces(interfaceContext);
        superInterfacesAndSelf.add(0, interfaceContext);
        return superInterfacesAndSelf;
    }

    public List<TeamAppsDtoParser.PropertyDeclarationContext> getSimplePropertiesSortedByRelevance(List<TeamAppsDtoParser.PropertyDeclarationContext> properties) {
        return properties.stream().sorted((p1, p2) -> {
            Function<TeamAppsDtoParser.PropertyDeclarationContext, Integer> getPriority = p -> {
                if (p.Identifier().getText().equals("id")) {
                    return 50;
                }
                if (p.Identifier().getText().equals("name")) {
                    return 40;
                }
                if (p.Identifier().getText().contains("Id")) {
                    return 30;
                }
                if (p.Identifier().getText().contains("Name")) {
                    return 20;
                }
                if (this.findReferencedClass(p.type()) == null) {
                    return 10;
                }
                return 0;
            };
            return getPriority.apply((TeamAppsDtoParser.PropertyDeclarationContext)((Object)p2)) - getPriority.apply((TeamAppsDtoParser.PropertyDeclarationContext)((Object)p1));
        }).collect(Collectors.toList());
    }

    public List<TeamAppsDtoParser.PropertyDeclarationContext> findPropertiesNotImplementedBySuperClasses(TeamAppsDtoParser.ClassDeclarationContext classContext) {
        List<TeamAppsDtoParser.PropertyDeclarationContext> properties = this.findAllProperties(classContext);
        TeamAppsDtoParser.ClassDeclarationContext superClass = this.findSuperClass(classContext);
        if (superClass != null) {
            properties.removeAll(this.findAllProperties(superClass));
        }
        return properties;
    }

    public List<ParserRuleContext> findSuperClassAndDirectlyImplementedInterfaces(TeamAppsDtoParser.ClassDeclarationContext classContext) {
        TeamAppsDtoParser.ClassDeclarationContext superClass = this.findSuperClass(classContext);
        List<TeamAppsDtoParser.InterfaceDeclarationContext> directlyImplementedInterfaces = this.getDirectlyImplementedInterfaces(classContext);
        ArrayList<ParserRuleContext> result = new ArrayList<ParserRuleContext>();
        if (superClass != null) {
            result.add(superClass);
        }
        result.addAll(directlyImplementedInterfaces);
        return result;
    }

    public List<TeamAppsDtoParser.CommandDeclarationContext> getAllCommands(TeamAppsDtoParser.ClassDeclarationContext classContext) {
        List<TeamAppsDtoParser.CommandDeclarationContext> commands = Stream.concat(this.findSelfAndAllSuperClasses(classContext).stream().flatMap(clazz -> clazz.commandDeclaration().stream()), this.findAllImplementedInterfaces(classContext).stream().flatMap(interf -> interf.commandDeclaration().stream())).filter(this.distinctByKey(command -> command.Identifier().getText())).collect(Collectors.toList());
        Collections.reverse(commands);
        return commands;
    }

    public List<TeamAppsDtoParser.CommandDeclarationContext> getAllCommands(TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext) {
        return this.findAllSuperInterfacesAndSelf(interfaceContext).stream().flatMap(interf -> interf.commandDeclaration().stream()).filter(this.distinctByKey(command -> command.Identifier().getText())).collect(Collectors.toList());
    }

    public List<TeamAppsDtoParser.EventDeclarationContext> getAllEvents(TeamAppsDtoParser.ClassDeclarationContext classContext) {
        List<TeamAppsDtoParser.EventDeclarationContext> events = Stream.concat(this.findSelfAndAllSuperClasses(classContext).stream().flatMap(clazz -> clazz.eventDeclaration().stream()), this.findAllImplementedInterfaces(classContext).stream().flatMap(interf -> interf.eventDeclaration().stream())).filter(this.distinctByKey(event -> event.Identifier().getText())).collect(Collectors.toList());
        Collections.reverse(events);
        return events;
    }

    public List<TeamAppsDtoParser.EventDeclarationContext> getAllEvents(TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext) {
        return this.findAllSuperInterfacesAndSelf(interfaceContext).stream().flatMap(interf -> interf.eventDeclaration().stream()).filter(this.distinctByKey(event -> event.Identifier().getText())).collect(Collectors.toList());
    }

    public List<TeamAppsDtoParser.SubCommandDeclarationContext> getAllSubCommands(TeamAppsDtoParser.ClassDeclarationContext classContext) {
        List<TeamAppsDtoParser.SubCommandDeclarationContext> commands = Stream.concat(this.findSelfAndAllSuperClasses(classContext).stream().flatMap(clazz -> clazz.subCommandDeclaration().stream()), this.findAllImplementedInterfaces(classContext).stream().flatMap(interf -> interf.subCommandDeclaration().stream())).filter(this.distinctByKey(command -> command.Identifier().getText())).collect(Collectors.toList());
        Collections.reverse(commands);
        return commands;
    }

    public List<TeamAppsDtoParser.SubCommandDeclarationContext> getAllSubCommands(TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext) {
        return this.findAllSuperInterfacesAndSelf(interfaceContext).stream().flatMap(interf -> interf.subCommandDeclaration().stream()).filter(this.distinctByKey(command -> command.Identifier().getText())).collect(Collectors.toList());
    }

    public List<TeamAppsDtoParser.SubEventDeclarationContext> getAllSubEvents(TeamAppsDtoParser.ClassDeclarationContext classContext) {
        List<TeamAppsDtoParser.SubEventDeclarationContext> events = Stream.concat(this.findSelfAndAllSuperClasses(classContext).stream().flatMap(clazz -> clazz.subEventDeclaration().stream()), this.findAllImplementedInterfaces(classContext).stream().flatMap(interf -> interf.subEventDeclaration().stream())).filter(this.distinctByKey(event -> event.Identifier().getText())).collect(Collectors.toList());
        Collections.reverse(events);
        return events;
    }

    public List<TeamAppsDtoParser.SubEventDeclarationContext> getAllSubEvents(TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext) {
        return this.findAllSuperInterfacesAndSelf(interfaceContext).stream().flatMap(interf -> interf.subEventDeclaration().stream()).filter(this.distinctByKey(event -> event.Identifier().getText())).collect(Collectors.toList());
    }

    public List<ParserRuleContext> superClassAndDirectlyImplementedInterfacesWithCommands(TeamAppsDtoParser.ClassDeclarationContext classContext) {
        return Stream.concat(Optional.ofNullable(this.findSuperClass(classContext)).filter(clazz -> !this.getAllCommands((TeamAppsDtoParser.ClassDeclarationContext)((Object)clazz)).isEmpty()).map(Stream::of).orElseGet(Stream::empty), this.getDirectlyImplementedInterfaces(classContext).stream().filter(interf -> !this.getAllCommands((TeamAppsDtoParser.InterfaceDeclarationContext)((Object)interf)).isEmpty())).collect(Collectors.toList());
    }

    public List<ParserRuleContext> superClassAndDirectlyImplementedInterfacesWithSubCommands(TeamAppsDtoParser.ClassDeclarationContext classContext) {
        return Stream.concat(Optional.ofNullable(this.findSuperClass(classContext)).filter(clazz -> !this.getAllSubCommands((TeamAppsDtoParser.ClassDeclarationContext)((Object)clazz)).isEmpty()).map(Stream::of).orElseGet(Stream::empty), this.getDirectlyImplementedInterfaces(classContext).stream().filter(interf -> !this.getAllSubCommands((TeamAppsDtoParser.InterfaceDeclarationContext)((Object)interf)).isEmpty())).collect(Collectors.toList());
    }

    public List<ParserRuleContext> superClassAndDirectlyImplementedInterfacesWithEvents(TeamAppsDtoParser.ClassDeclarationContext classContext) {
        return Stream.concat(Optional.ofNullable(this.findSuperClass(classContext)).filter(clazz -> !this.getAllEvents((TeamAppsDtoParser.ClassDeclarationContext)((Object)clazz)).isEmpty()).map(Stream::of).orElseGet(Stream::empty), this.getDirectlyImplementedInterfaces(classContext).stream().filter(interf -> !this.getAllEvents((TeamAppsDtoParser.InterfaceDeclarationContext)((Object)interf)).isEmpty())).collect(Collectors.toList());
    }

    public List<ParserRuleContext> superClassAndDirectlyImplementedInterfacesWithSubEvents(TeamAppsDtoParser.ClassDeclarationContext classContext) {
        return Stream.concat(Optional.ofNullable(this.findSuperClass(classContext)).filter(clazz -> !this.getAllSubEvents((TeamAppsDtoParser.ClassDeclarationContext)((Object)clazz)).isEmpty()).map(Stream::of).orElseGet(Stream::empty), this.getDirectlyImplementedInterfaces(classContext).stream().filter(interf -> !this.getAllSubEvents((TeamAppsDtoParser.InterfaceDeclarationContext)((Object)interf)).isEmpty())).collect(Collectors.toList());
    }

    public List<ParserRuleContext> getSuperInterfacesWithCommands(TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext) {
        return this.findSuperInterfaces(interfaceContext).stream().filter(itf -> !this.getAllCommands((TeamAppsDtoParser.InterfaceDeclarationContext)((Object)itf)).isEmpty()).collect(Collectors.toList());
    }

    public List<ParserRuleContext> getSuperInterfacesWithSubCommands(TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext) {
        return this.findSuperInterfaces(interfaceContext).stream().filter(itf -> !this.getAllSubCommands((TeamAppsDtoParser.InterfaceDeclarationContext)((Object)itf)).isEmpty()).collect(Collectors.toList());
    }

    public List<ParserRuleContext> getSuperInterfacesWithEvents(TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext) {
        return this.findSuperInterfaces(interfaceContext).stream().filter(itf -> !this.getAllEvents((TeamAppsDtoParser.InterfaceDeclarationContext)((Object)itf)).isEmpty()).collect(Collectors.toList());
    }

    public List<ParserRuleContext> getSuperInterfacesWithSubEvents(TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext) {
        return this.findSuperInterfaces(interfaceContext).stream().filter(itf -> !this.getAllSubEvents((TeamAppsDtoParser.InterfaceDeclarationContext)((Object)itf)).isEmpty()).collect(Collectors.toList());
    }

    public boolean interfaceOrDescendantHasSubCommandDeclarations(TeamAppsDtoParser.InterfaceDeclarationContext interf) {
        boolean hasOwnSubCommands;
        boolean bl = hasOwnSubCommands = interf.subCommandDeclaration().size() > 0;
        if (hasOwnSubCommands) {
            return true;
        }
        return this.findAllSubClasses(interf).stream().anyMatch(subClass -> subClass.subCommandDeclaration().size() > 0) || this.findAllSubInterfaces(interf).stream().anyMatch(subInterface -> subInterface.subCommandDeclaration().size() > 0);
    }

    public boolean classOrSubClassHasSubCommandDeclarations(TeamAppsDtoParser.ClassDeclarationContext classContext) {
        boolean hasOwnSubCommands;
        boolean bl = hasOwnSubCommands = classContext.subCommandDeclaration().size() > 0;
        if (hasOwnSubCommands) {
            return true;
        }
        return this.findAllSubClasses(classContext).stream().anyMatch(subClass -> subClass.subCommandDeclaration().size() > 0);
    }

    public boolean interfaceOrDescendantHasSubEventDeclarations(TeamAppsDtoParser.InterfaceDeclarationContext interf) {
        boolean referencedForSubEvents = this.isDescendantOfClassOrInterfaceReferencedForSubEvents(interf);
        boolean hasOwnOrInheritedSubEvents = this.findAllSuperInterfacesAndSelf(interf).stream().anyMatch(i -> !i.subEventDeclaration().isEmpty());
        return referencedForSubEvents || hasOwnOrInheritedSubEvents;
    }

    public boolean classOrSubClassHasSubEventDeclarations(TeamAppsDtoParser.ClassDeclarationContext classContext) {
        boolean referencedForSubEvents = this.isDescendantOfClassOrInterfaceReferencedForSubEvents(classContext);
        boolean classHierarchyDeclaresSubEvents = this.findSelfAndAllSuperClasses(classContext).stream().anyMatch(i -> !i.subEventDeclaration().isEmpty());
        boolean inheritsSubEventsFromInterfaces = this.findAllImplementedInterfaces(classContext).stream().anyMatch(i -> !i.subEventDeclaration().isEmpty());
        return referencedForSubEvents || classHierarchyDeclaresSubEvents || inheritsSubEventsFromInterfaces;
    }

    public List<TeamAppsDtoParser.SubEventDeclarationContext> findAllSubEventsInHierarchy(TeamAppsDtoParser.ClassDeclarationContext classContext) {
        List<TeamAppsDtoParser.ClassDeclarationContext> allSubClasses = this.findAllSubClasses(classContext);
        allSubClasses.add(classContext);
        return allSubClasses.stream().flatMap(c -> this.getAllSubEvents((TeamAppsDtoParser.ClassDeclarationContext)((Object)c)).stream()).filter(this.distinctByKey(subEvent -> subEvent.Identifier().getText())).collect(Collectors.toList());
    }

    public List<TeamAppsDtoParser.SubEventDeclarationContext> findAllSubEventsInHierarchy(TeamAppsDtoParser.InterfaceDeclarationContext classContext) {
        List<TeamAppsDtoParser.ClassDeclarationContext> allSubClasses = this.findAllSubClasses(classContext);
        return allSubClasses.stream().flatMap(c -> this.getAllSubEvents((TeamAppsDtoParser.ClassDeclarationContext)((Object)c)).stream()).filter(this.distinctByKey(subEvent -> subEvent.Identifier().getText())).collect(Collectors.toList());
    }

    private ParserRuleContext findClassOrInterfaceByName(String referencedClassName) {
        TeamAppsDtoParser.ClassDeclarationContext clazz = this.findClassByName(referencedClassName, false);
        if (clazz != null) {
            return clazz;
        }
        return this.findInterfaceByName(referencedClassName, false);
    }

    public boolean isDescendantOfClassOrInterfaceReferencedForSubEvents(TeamAppsDtoParser.ClassDeclarationContext classContext) {
        boolean implementsInterfaceReferencedForSubEvent = this.findAllImplementedInterfaces(classContext).removeAll(this.classesAndInterfacesReferencedForSubEvents);
        boolean hasSuperClassReferencedForSubEvents = this.findSelfAndAllSuperClasses(classContext).removeAll(this.classesAndInterfacesReferencedForSubEvents);
        return implementsInterfaceReferencedForSubEvent || hasSuperClassReferencedForSubEvents;
    }

    public boolean isDescendantOfClassOrInterfaceReferencedForSubEvents(TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext) {
        return this.findAllSuperInterfacesAndSelf(interfaceContext).removeAll(this.classesAndInterfacesReferencedForSubEvents);
    }

    public static ParserRuleContext getDeclaringClassOrInterface(ParserRuleContext element) {
        if (element instanceof TeamAppsDtoParser.ClassDeclarationContext || element instanceof TeamAppsDtoParser.InterfaceDeclarationContext) {
            return element;
        }
        TeamAppsDtoParser.ClassDeclarationContext clazz = TeamAppsDtoModel.findAncestorOfType((RuleContext)element, TeamAppsDtoParser.ClassDeclarationContext.class);
        if (clazz != null) {
            return clazz;
        }
        return TeamAppsDtoModel.findAncestorOfType((RuleContext)element, TeamAppsDtoParser.InterfaceDeclarationContext.class);
    }

    public static String getDeclaringClassOrInterfaceName(ParserRuleContext element) {
        ParserRuleContext declaringClassOrInterface = TeamAppsDtoModel.getDeclaringClassOrInterface(element);
        if (declaringClassOrInterface instanceof TeamAppsDtoParser.ClassDeclarationContext) {
            return ((TeamAppsDtoParser.ClassDeclarationContext)declaringClassOrInterface).Identifier().getText();
        }
        if (declaringClassOrInterface instanceof TeamAppsDtoParser.InterfaceDeclarationContext) {
            return ((TeamAppsDtoParser.InterfaceDeclarationContext)declaringClassOrInterface).Identifier().getText();
        }
        return null;
    }

    public List<ParserRuleContext> getAllClassesAndInterfacesWithEvents() {
        return Stream.concat(this.classDeclarations.stream().filter(classDeclarationContext -> !this.getAllEvents((TeamAppsDtoParser.ClassDeclarationContext)((Object)classDeclarationContext)).isEmpty()), this.interfaceDeclarations.stream().filter(interfaceDeclarationContext -> !this.getAllEvents((TeamAppsDtoParser.InterfaceDeclarationContext)((Object)interfaceDeclarationContext)).isEmpty())).collect(Collectors.toList());
    }

    public List<ParserRuleContext> getAllClassesAndInterfacesWithSubEvents() {
        return Stream.concat(this.classDeclarations.stream().filter(classDeclarationContext -> !this.getAllSubEvents((TeamAppsDtoParser.ClassDeclarationContext)((Object)classDeclarationContext)).isEmpty()), this.interfaceDeclarations.stream().filter(interfaceDeclarationContext -> !this.getAllSubEvents((TeamAppsDtoParser.InterfaceDeclarationContext)((Object)interfaceDeclarationContext)).isEmpty())).collect(Collectors.toList());
    }

    private ParserRuleContext findReferencedClassOrInterface(TeamAppsDtoParser.TypeContext type) {
        TeamAppsDtoParser.ClassDeclarationContext referencedClass = this.findReferencedClass(type);
        return referencedClass != null ? referencedClass : this.findReferencedInterface(type);
    }

    public List<ParserRuleContext> findAllReferencedClassesAndInterfaces(TeamAppsDtoParser.ClassDeclarationContext classContext) {
        return Stream.of(this.findSuperClassAndDirectlyImplementedInterfaces(classContext).stream(), this.findSuperClassAndDirectlyImplementedInterfaces(classContext).stream().flatMap(c -> c instanceof TeamAppsDtoParser.ClassDeclarationContext ? this.findAllReferencedClassesAndInterfaces((TeamAppsDtoParser.ClassDeclarationContext)((Object)c)).stream() : this.findAllReferencedClassesAndInterfaces((TeamAppsDtoParser.InterfaceDeclarationContext)((Object)c)).stream()), classContext.propertyDeclaration().stream().map(p -> this.findReferencedClassOrInterface(p.type())), classContext.commandDeclaration().stream().flatMap(cd -> cd.formalParameterWithDefault().stream()).map(fp -> this.findReferencedClassOrInterface(fp.type())), classContext.eventDeclaration().stream().flatMap(cd -> cd.formalParameterWithDefault().stream()).map(fp -> this.findReferencedClassOrInterface(fp.type())), classContext.subCommandDeclaration().stream().flatMap(cd -> cd.formalParameterWithDefault().stream()).map(fp -> this.findReferencedClassOrInterface(fp.type())), classContext.subEventDeclaration().stream().flatMap(cd -> cd.formalParameterWithDefault().stream()).map(fp -> this.findReferencedClassOrInterface(fp.type()))).flatMap(Function.identity()).filter(Objects::nonNull).filter(c -> c != classContext).distinct().collect(Collectors.toList());
    }

    public List<TeamAppsDtoParser.EnumDeclarationContext> findAllReferencedEnums(TeamAppsDtoParser.ClassDeclarationContext classContext) {
        return Stream.of(classContext.propertyDeclaration().stream().map(p -> this.findReferencedEnum(p.type())), classContext.commandDeclaration().stream().flatMap(cd -> cd.formalParameterWithDefault().stream()).map(fp -> this.findReferencedEnum(fp.type())), classContext.eventDeclaration().stream().flatMap(cd -> cd.formalParameterWithDefault().stream()).map(fp -> this.findReferencedEnum(fp.type())), classContext.subCommandDeclaration().stream().flatMap(cd -> cd.formalParameterWithDefault().stream()).map(fp -> this.findReferencedEnum(fp.type())), classContext.subEventDeclaration().stream().flatMap(cd -> cd.formalParameterWithDefault().stream()).map(fp -> this.findReferencedEnum(fp.type()))).flatMap(Function.identity()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public List<ParserRuleContext> findAllReferencedClassesAndInterfaces(TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext) {
        return Stream.of(this.findAllSuperInterfaces(interfaceContext).stream().map(interfDecl -> interfDecl), interfaceContext.propertyDeclaration().stream().map(p -> this.findReferencedClassOrInterface(p.type())), interfaceContext.commandDeclaration().stream().flatMap(cd -> cd.formalParameterWithDefault().stream()).map(fp -> this.findReferencedClassOrInterface(fp.type())), interfaceContext.eventDeclaration().stream().flatMap(cd -> cd.formalParameterWithDefault().stream()).map(fp -> this.findReferencedClassOrInterface(fp.type())), interfaceContext.subCommandDeclaration().stream().flatMap(cd -> cd.formalParameterWithDefault().stream()).map(fp -> this.findReferencedClassOrInterface(fp.type())), interfaceContext.subEventDeclaration().stream().flatMap(cd -> cd.formalParameterWithDefault().stream()).map(fp -> this.findReferencedClassOrInterface(fp.type()))).flatMap(Function.identity()).filter(Objects::nonNull).filter(c -> c != interfaceContext).distinct().collect(Collectors.toList());
    }

    public List<TeamAppsDtoParser.EnumDeclarationContext> findAllReferencedEnums(TeamAppsDtoParser.InterfaceDeclarationContext interfaceContext) {
        return Stream.of(interfaceContext.propertyDeclaration().stream().map(p -> this.findReferencedEnum(p.type())), interfaceContext.commandDeclaration().stream().flatMap(cd -> cd.formalParameterWithDefault().stream()).map(fp -> this.findReferencedEnum(fp.type())), interfaceContext.eventDeclaration().stream().flatMap(cd -> cd.formalParameterWithDefault().stream()).map(fp -> this.findReferencedEnum(fp.type())), interfaceContext.subCommandDeclaration().stream().flatMap(cd -> cd.formalParameterWithDefault().stream()).map(fp -> this.findReferencedEnum(fp.type())), interfaceContext.subEventDeclaration().stream().flatMap(cd -> cd.formalParameterWithDefault().stream()).map(fp -> this.findReferencedEnum(fp.type()))).flatMap(Function.identity()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public List<ParserRuleContext> findAllReferencedClassesAndInterfaces(TeamAppsDtoParser.EventDeclarationContext eventContext) {
        return eventContext.formalParameterWithDefault().stream().map(p -> this.findReferencedClassOrInterface(p.type())).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public List<TeamAppsDtoParser.EnumDeclarationContext> findAllReferencedEnums(TeamAppsDtoParser.EventDeclarationContext eventDeclarationContext) {
        return eventDeclarationContext.formalParameterWithDefault().stream().map(p -> this.findReferencedEnum(p.type())).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public List<ParserRuleContext> findAllReferencedClassesAndInterfaces(TeamAppsDtoParser.SubEventDeclarationContext eventContext) {
        return eventContext.formalParameterWithDefault().stream().map(p -> this.findReferencedClassOrInterface(p.type())).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public List<TeamAppsDtoParser.EnumDeclarationContext> findAllReferencedEnums(TeamAppsDtoParser.SubEventDeclarationContext eventDeclarationContext) {
        return eventDeclarationContext.formalParameterWithDefault().stream().map(p -> this.findReferencedEnum(p.type())).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public List<ParserRuleContext> findAllClassesInterfacesAndEnumsReferencedByEvents() {
        return this.eventDeclarations.stream().flatMap(ed -> Stream.concat(this.findAllReferencedClassesAndInterfaces((TeamAppsDtoParser.EventDeclarationContext)((Object)ed)).stream(), this.findAllReferencedEnums((TeamAppsDtoParser.EventDeclarationContext)((Object)ed)).stream())).distinct().collect(Collectors.toList());
    }

    public List<ParserRuleContext> findAllClassesInterfacesAndEnumsReferencedBySubEvents() {
        return this.subEventDeclarations.stream().flatMap(ed -> Stream.concat(this.findAllReferencedClassesAndInterfaces((TeamAppsDtoParser.SubEventDeclarationContext)((Object)ed)).stream(), this.findAllReferencedEnums((TeamAppsDtoParser.SubEventDeclarationContext)((Object)ed)).stream())).distinct().collect(Collectors.toList());
    }

    public List<TeamAppsDtoParser.PropertyDeclarationContext> findAllNotYetImplementedProperties(TeamAppsDtoParser.ClassDeclarationContext classContext) {
        return Streams.concat((Stream[])new Stream[]{classContext.propertyDeclaration().stream(), this.findAllImplementedInterfaces(classContext).stream().flatMap(interf -> interf.propertyDeclaration().stream())}).filter(this.distinctByKey(TeamAppsDtoParser.PropertyDeclarationContext::Identifier)).collect(Collectors.toList());
    }

    public static boolean isReferenceType(TeamAppsDtoParser.TypeContext type) {
        return type.typeReference() != null && type.typeReference().referenceTypeModifier() != null;
    }

    public boolean isReferenceableClass(TeamAppsDtoParser.ClassDeclarationContext clazz) {
        return this.findSelfNearestAncestorClassWithReferenceableAttribute(clazz) != null;
    }

    public boolean isReferenceableBaseClass(TeamAppsDtoParser.ClassDeclarationContext clazz) {
        return this.findSelfNearestAncestorClassWithReferenceableAttribute(clazz) == clazz;
    }

    public TeamAppsDtoParser.ClassDeclarationContext findSelfNearestAncestorClassWithReferenceableAttribute(TeamAppsDtoParser.ClassDeclarationContext clazz) {
        return this.findSelfAndAllSuperClasses(clazz).stream().filter(c -> c.propertyDeclaration().stream().anyMatch(p -> p.referenceableAnnotation() != null)).findFirst().orElse(null);
    }

    public Object getReferenceableProperties(TeamAppsDtoParser.ClassDeclarationContext classContext) {
        return this.findAllProperties(classContext).stream().filter(p -> p.referenceableAnnotation() != null).collect(Collectors.toList());
    }
}

