/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb;

import java.util.ArrayList;
import java.util.List;
import org.teamapps.common.format.Color;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.dto.UiMapConfig;
import org.teamapps.icons.Icon;
import org.teamapps.udb.AbstractBuilder;
import org.teamapps.udb.MapModel;
import org.teamapps.udb.ModelBuilderFactory;
import org.teamapps.udb.filter.NumericQueryFilter;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.universaldb.query.AndFilter;
import org.teamapps.universaldb.query.Filter;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.map.Location;
import org.teamapps.ux.component.map.MapShapeType;
import org.teamapps.ux.component.map.MapView;
import org.teamapps.ux.component.map.shape.AbstractMapShape;
import org.teamapps.ux.component.map.shape.MapCircle;
import org.teamapps.ux.component.map.shape.MapPolygon;
import org.teamapps.ux.component.map.shape.MapRectangle;
import org.teamapps.ux.component.map.shape.ShapeProperties;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.i18n.TeamAppsDictionary;
import org.teamapps.ux.icon.TeamAppsIconBundle;

public class MapBuilder<ENTITY extends Entity<ENTITY>>
extends AbstractBuilder<ENTITY> {
    private MapModel<ENTITY> model;
    private MapView<ENTITY> map;
    private Filter geoFilter;
    private List<AbstractMapShape> mapShapes = new ArrayList<AbstractMapShape>();

    protected MapBuilder(ModelBuilderFactory<ENTITY> modelBuilderFactory) {
        super(modelBuilderFactory);
        this.createMap();
    }

    private void createMap() {
        this.map = new MapView();
        this.model = this.getModelBuilderFactory().createMapModel();
        this.model.onAllDataChanged.addListener(() -> this.map.setMarkerCluster(this.model.getMarkers()));
        this.map.setMarkerCluster(this.model.getMarkers());
        this.map.onShapeDrawn.addListener(shape -> {
            this.mapShapes.add((AbstractMapShape)shape);
            if (shape instanceof MapRectangle) {
                MapRectangle rectangle = (MapRectangle)shape;
                Location location1 = rectangle.getLocation1();
                Location location2 = rectangle.getLocation2();
                this.addLocationFilter(location1, location2);
            }
            if (shape instanceof MapCircle) {
                MapCircle circle = (MapCircle)shape;
                Location center = circle.getCenter();
                int n = circle.getRadiusMeters();
            }
            if (shape instanceof MapPolygon) {
                MapPolygon polygon = (MapPolygon)shape;
                List list = polygon.getLocations();
            }
        });
    }

    public void createAndAttachToViewWithToolbarButtons(View view, UiMapConfig mapConfig, Template template, PropertyExtractor<ENTITY> propertyExtractor) {
        MapView<ENTITY> mapView = this.getMapComponent();
        mapView.setDefaultMarkerTemplate(template);
        mapView.setMarkerPropertyExtractor(propertyExtractor);
        mapView.setMapConfig(mapConfig);
        mapView.setZoomLevel(9);
        mapView.setLocation(50.2, 8.3);
        view.setComponent(mapView);
        ToolbarButtonGroup buttonGroup = view.addLocalButtonGroup(new ToolbarButtonGroup());
        buttonGroup.addButton((ToolbarButton)ToolbarButton.createTiny((Icon)this.getIcon((String)TeamAppsIconBundle.SELECTION.getKey()), (String)this.getLocalized((String)TeamAppsDictionary.SELECT_AREA.getKey(), (Object[])new Object[0]))).onClick.addListener(() -> this.startGeoFilterUi());
        buttonGroup.addButton((ToolbarButton)ToolbarButton.createTiny((Icon)this.getIcon((String)TeamAppsIconBundle.REMOVE.getKey()), (String)this.getLocalized((String)TeamAppsDictionary.REMOVE_SELECTION.getKey(), (Object[])new Object[0]))).onClick.addListener(() -> this.removeGeoFilters());
    }

    public void addLocationFilter(Location location1, Location location2) {
        float latMin = (float)Math.min(location1.getLatitude(), location2.getLatitude());
        float latMax = (float)Math.max(location1.getLatitude(), location2.getLatitude());
        float lonMin = (float)Math.min(location1.getLongitude(), location2.getLongitude());
        float lonMax = (float)Math.max(location1.getLongitude(), location2.getLongitude());
        NumericQueryFilter latitudeFilter = new NumericQueryFilter(this.model.getLatitudeIndex().getName(), NumericFilter.betweenFilter((Number)Float.valueOf(latMin), (Number)Float.valueOf(latMax)));
        NumericQueryFilter longitudeFilter = new NumericQueryFilter(this.model.getLongitudeIndex().getName(), NumericFilter.betweenFilter((Number)Float.valueOf(lonMin), (Number)Float.valueOf(lonMax)));
        TableIndex tableIndex = this.getModelBuilderFactory().getTableIndex();
        AndFilter filter = new AndFilter(latitudeFilter.createFilter(tableIndex), longitudeFilter.createFilter(tableIndex));
        if (this.geoFilter == null) {
            this.geoFilter = filter;
        } else {
            this.geoFilter.or((Filter)filter);
        }
        this.getModelBuilderFactory().onGeoFilterChanged.fire((Object)this.geoFilter);
    }

    public void startGeoFilterUi() {
        ShapeProperties shapeProperties = new ShapeProperties((Color)Color.MATERIAL_BLUE_700);
        shapeProperties.setFillColor((Color)Color.MATERIAL_BLUE_700.withAlpha(0.7f));
        this.map.startDrawingShape(MapShapeType.RECTANGLE, shapeProperties);
    }

    public void removeGeoFilters() {
        this.mapShapes.forEach(shape -> this.map.removeShape(shape));
        this.geoFilter = null;
        this.getModelBuilderFactory().onGeoFilterChanged.fire((Object)this.geoFilter);
    }

    public void setFields(String latitudeFieldName, String longitudeFieldName) {
        this.model.setLocationFields(latitudeFieldName, longitudeFieldName);
    }

    public void setMarkerOffsets(int markerOffsetX, int markerOffsetY) {
        this.model.setMarkerOffsetX(markerOffsetX);
        this.model.setMarkerOffsetY(markerOffsetY);
    }

    public MapView<ENTITY> getMapComponent() {
        return this.map;
    }
}

